/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.expiration;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.model.Game;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.expiration.DistributedQueryExpiredEntitiesTest")
public class DistributedQueryExpiredEntitiesTest
extends MultipleCacheManagersTest {
    private static final String CACHE_NAME = "games";
    private static final int TIME = 100;
    private static final ControlledTimeService timeService = new ControlledTimeService();
    private RestServerHelper restServer;
    private RestClient restClient;

    protected void createCacheManagers() {
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        ConfigurationBuilder config = DistributedQueryExpiredEntitiesTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC);
        this.createClusteredCaches(3, global, config, true, new String[]{"default"});
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)this.cacheManagers.get(0);
        TestingUtil.replaceComponent((CacheContainer)cacheManager, TimeService.class, (Object)timeService, (boolean)true);
        Cache metadataCache = cacheManager.getCache("___protobuf_metadata");
        metadataCache.putIfAbsent((Object)Game.GameSchema.INSTANCE.getProtoFileName(), (Object)Game.GameSchema.INSTANCE.getProtoFile());
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        config.encoding().mediaType("application/x-protostream");
        config.expiration().lifespan(100L, TimeUnit.MILLISECONDS).maxIdle(100L, TimeUnit.MILLISECONDS);
        config.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("Game");
        config.statistics().enable();
        cacheManager.createCache(CACHE_NAME, config.build());
        this.restServer = new RestServerHelper(cacheManager);
        this.restServer.start(TestResourceTracker.getCurrentTestShortName());
        this.restClient = RestClient.forConfiguration((RestClientConfiguration)new RestClientConfigurationBuilder().addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).build());
    }

    @Test
    public void testQueryExpiredEntities() throws Exception {
        RestCacheClient cacheClient = this.restClient.cache(CACHE_NAME);
        Json game = Json.object().set("_type", (Object)"Game").set("name", (Object)"Ultima IV: Quest of the Avatar").set("description", (Object)"It is the first in the \"Age of Enlightenment\" trilogy ...");
        CompletionStage response = cacheClient.put("ultima-iv", RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)game.toString()));
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.query("from Game g where g.description : 'enlightenment'", 5, 0);
        ResponseAssertion.assertThat(response).isOk();
        Json body = Json.read((String)((RestResponse)response.toCompletableFuture().get()).body());
        List hits = (List)body.at("hits").getValue();
        Assertions.assertThat((List)hits).isNotEmpty();
        timeService.advance(200L);
        response = cacheClient.query("from Game g where g.description : 'enlightenment'", 5, 0);
        ResponseAssertion.assertThat(response).isOk();
        body = Json.read((String)((RestResponse)response.toCompletableFuture().get()).body());
        hits = (List)body.at("hits").getValue();
        Assertions.assertThat((List)hits).isEmpty();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        try {
            this.restClient.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.restServer.stop();
        }
    }
}

