/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.framework.impl;

import java.util.Map;
import org.infinispan.rest.framework.impl.PathInterpreter;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="rest.framework.PathInterpreterTest")
public class PathInterpreterTest {
    @Test
    public void testSingleVariable() {
        Map res = PathInterpreter.resolveVariables((String)"{id}", (String)"5435");
        Assert.assertEquals((int)1, (int)res.size());
        Assert.assertEquals((String)((String)res.get("id")), (String)"5435");
    }

    @Test
    public void testSingleVariable2() {
        Map res = PathInterpreter.resolveVariables((String)"{variable_name}", (String)"a");
        Assert.assertEquals((int)1, (int)res.size());
        Assert.assertEquals((String)((String)res.get("variable_name")), (String)"a");
    }

    @Test
    public void testDualVariables() {
        Map res = PathInterpreter.resolveVariables((String)"{cachemanager}-{cache}", (String)"default-mycache");
        Assert.assertEquals((int)2, (int)res.size());
        Assert.assertEquals((String)((String)res.get("cachemanager")), (String)"default");
        Assert.assertEquals((String)((String)res.get("cache")), (String)"mycache");
    }

    @Test
    public void testDualVariables2() {
        Map res = PathInterpreter.resolveVariables((String)"{cachemanager}{cache}", (String)"defaultmycache");
        Assert.assertEquals((int)0, (int)res.size());
    }

    @Test
    public void testDualVariables3() {
        Map res = PathInterpreter.resolveVariables((String)"{a}:{b}", (String)"value1:value2");
        Assert.assertEquals((int)2, (int)res.size());
        Assert.assertEquals((String)((String)res.get("a")), (String)"value1");
        Assert.assertEquals((String)((String)res.get("b")), (String)"value2");
    }

    @Test
    public void testPrefixSufix() {
        Map res = PathInterpreter.resolveVariables((String)"prefix_{variable1}_{variable2}_suffix", (String)"prefix_value1_value2_suffix");
        Assert.assertEquals((int)2, (int)res.size());
        Assert.assertEquals((String)((String)res.get("variable1")), (String)"value1");
        Assert.assertEquals((String)((String)res.get("variable2")), (String)"value2");
    }

    @Test
    public void testSingleVariableWithPrefix() {
        Map res = PathInterpreter.resolveVariables((String)"counter-{id}", (String)"counter-2345");
        Assert.assertEquals((int)1, (int)res.size());
        Assert.assertEquals((String)((String)res.get("id")), (String)"2345");
    }

    @Test
    public void testNull() {
        Map res1 = PathInterpreter.resolveVariables(null, (String)"whatever");
        Map res2 = PathInterpreter.resolveVariables((String)"{hello}", null);
        Assert.assertEquals((int)0, (int)res1.size());
        Assert.assertEquals((int)0, (int)res2.size());
    }

    @Test
    public void testNonConformantPath() {
        Map res = PathInterpreter.resolveVariables((String)"{cachemanager}-{cache}", (String)"default");
        Assert.assertEquals((int)0, (int)res.size());
    }

    @Test
    public void testMalformedExpression() {
        Map res = PathInterpreter.resolveVariables((String)"{counter {id}}", (String)"whatever");
        Assert.assertEquals((int)0, (int)res.size());
    }

    @Test
    public void testMalformedExpression2() {
        Map res = PathInterpreter.resolveVariables((String)"{counter }id}-", (String)"whatever");
        Assert.assertEquals((int)0, (int)res.size());
    }
}

