/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.helper;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.Exceptions;

public class RestResponses {
    public static void assertSuccessful(CompletionStage<RestResponse> responseStage) {
        RestResponses.assertStatus(200, responseStage);
    }

    public static void assertNoContent(CompletionStage<RestResponse> responseStage) {
        RestResponses.assertStatus(204, responseStage);
    }

    public static void assertStatus(int expectedStatus, CompletionStage<RestResponse> responseStage) {
        int status = RestResponses.responseStatus(responseStage);
        RestResponses.assertEquals(expectedStatus, status);
    }

    public static int responseStatus(CompletionStage<RestResponse> responseStage) {
        try (RestResponse response = RestResponses.sync(responseStage);){
            int n = response.status();
            return n;
        }
    }

    public static String responseBody(CompletionStage<RestResponse> responseStage) {
        try (RestResponse response = RestResponses.sync(responseStage);){
            RestResponses.assertEquals(200, response.status());
            String string = response.body();
            return string;
        }
    }

    public static Json jsonResponseBody(CompletionStage<RestResponse> responseCompletionStage) {
        return (Json)Exceptions.unchecked(() -> Json.read((String)RestResponses.responseBody(responseCompletionStage)));
    }

    private static <T> T sync(CompletionStage<T> stage) {
        return (T)Exceptions.unchecked(() -> stage.toCompletableFuture().get(10L, TimeUnit.SECONDS));
    }

    private static void assertEquals(int expectedStatus, int status) {
        if (status != expectedStatus) {
            throw new AssertionError((Object)("Expected: <" + expectedStatus + ">, but was: <" + status + ">"));
        }
    }
}

