/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.helper;

import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.HashMap;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.TestClass;
import org.infinispan.rest.authentication.RestAuthenticator;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.DummyServerManagement;
import org.infinispan.server.core.MockProtocolServer;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.test.fwk.TestCacheManagerFactory;

public class RestServerHelper {
    private final EmbeddedCacheManager cacheManager;
    private final RestServer restServer = new RestServer();
    private final RestServerConfigurationBuilder restServerConfigurationBuilder = new RestServerConfigurationBuilder();

    public RestServerHelper(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        try {
            ((RestServerConfigurationBuilder)((RestServerConfigurationBuilder)this.restServerConfigurationBuilder.host("localhost")).port(0)).maxContentLength(1000000).staticResources(Paths.get(this.getClass().getResource("/static-test").toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public static RestServerHelper defaultRestServer(String ... cachesDefined) {
        return RestServerHelper.defaultRestServer(new ConfigurationBuilder(), cachesDefined);
    }

    public RestServerConfigurationBuilder serverConfigurationBuilder() {
        return this.restServerConfigurationBuilder;
    }

    public static RestServerHelper defaultRestServer(ConfigurationBuilder configuration, String ... cachesDefined) {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().cacheManagerName("default");
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)globalBuilder, (ConfigurationBuilder)configuration);
        cacheManager.getClassAllowList().addClasses(new Class[]{TestClass.class});
        for (String cacheConfiguration : cachesDefined) {
            cacheManager.defineConfiguration(cacheConfiguration, configuration.build());
        }
        return new RestServerHelper(cacheManager);
    }

    public RestServerHelper withAuthenticator(RestAuthenticator authenticator) {
        this.restServerConfigurationBuilder.authentication().authenticator(authenticator);
        return this;
    }

    public RestServerHelper start(String name) {
        this.restServerConfigurationBuilder.name(name);
        HashMap<String, MockProtocolServer> protocolServers = new HashMap<String, MockProtocolServer>();
        this.restServer.setServerManagement((ServerManagement)new DummyServerManagement(this.cacheManager, protocolServers), true);
        this.restServer.start((ProtocolServerConfiguration)this.restServerConfigurationBuilder.build(), this.cacheManager);
        protocolServers.put("DummyProtocol", new MockProtocolServer("DummyProtocol", this.restServer.getTransport()));
        return this;
    }

    public void clear() {
        InternalCacheRegistry registry = (InternalCacheRegistry)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)this.cacheManager, InternalCacheRegistry.class);
        this.cacheManager.getCacheNames().stream().filter(cacheName -> !registry.isInternalCache(cacheName)).filter(arg_0 -> ((EmbeddedCacheManager)this.cacheManager).isRunning(arg_0)).forEach(cacheName -> this.cacheManager.getCache(cacheName).getAdvancedCache().getDataContainer().clear());
    }

    public void stop() {
        Util.close((AutoCloseable)this.restServer);
        Util.close((AutoCloseable)this.cacheManager);
    }

    public int getPort() {
        return this.restServer.getPort();
    }

    public RestServerConfiguration getConfiguration() {
        return (RestServerConfiguration)this.restServer.getConfiguration();
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public String getBasePath() {
        return String.format("/%s/v2/caches/%s", ((RestServerConfiguration)this.restServer.getConfiguration()).contextPath(), this.cacheManager.getCacheManagerConfiguration().defaultCacheName().get());
    }

    public RestServerHelper withKeyStore(String keyStorePath, char[] secret, String type) {
        this.restServerConfigurationBuilder.ssl().enable();
        this.restServerConfigurationBuilder.ssl().keyStoreFileName(keyStorePath).keyStorePassword(secret).keyStoreType(type);
        return this;
    }

    public RestServerHelper withTrustStore(String trustStorePath, char[] secret, String type) {
        this.restServerConfigurationBuilder.ssl().enable();
        this.restServerConfigurationBuilder.ssl().trustStoreFileName(trustStorePath).trustStorePassword(secret).trustStoreType(type);
        return this;
    }

    public RestServerHelper withClientAuth() {
        this.restServerConfigurationBuilder.ssl().enable();
        this.restServerConfigurationBuilder.ssl().requireClientAuth(true);
        return this;
    }

    public String getHost() {
        return this.restServer.getHost();
    }

    public void ignoreCache(String cacheName) {
        this.restServer.getServerStateManager().ignoreCache(cacheName).join();
    }

    public void unignoreCache(String cacheName) {
        this.restServer.getServerStateManager().unignoreCache(cacheName).join();
    }

    public RestClient createClient(boolean browser) {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.addServer().host(this.restServer.getHost()).port(this.restServer.getPort().intValue());
        if (browser) {
            builder.header("User-Agent", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:109.0) Gecko/20100101 Firefox/112.0");
        }
        return RestClient.forConfiguration((RestClientConfiguration)builder.build());
    }
}

