/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.metric;

import org.assertj.core.api.Assertions;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="rest.metric.MetricsRestTest")
public class MetricsRestTest
extends SingleCacheManagerTest {
    private RestServerHelper restServer;
    private RestClient restClient;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager();
        this.restServer = new RestServerHelper(cacheManager);
        this.restServer.start(TestResourceTracker.getCurrentTestShortName());
        this.restClient = RestClient.forConfiguration((RestClientConfiguration)new RestClientConfigurationBuilder().addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).build());
        return cacheManager;
    }

    @Test
    public void smokeTest() {
        String response = ((RestResponse)this.restClient.metrics().metrics().toCompletableFuture().join()).body();
        Assertions.assertThat((String)response).contains(new CharSequence[]{"#"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void teardown() {
        try {
            this.restClient.close();
        }
        catch (Exception exception) {
            try {
                this.restServer.stop();
            }
            finally {
                super.teardown();
            }
        }
        finally {
            try {
                this.restServer.stop();
            }
            finally {
                super.teardown();
            }
        }
    }
}

