/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.profiling;

import io.netty.util.CharsetUtil;
import java.util.Random;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.Eventually;
import org.infinispan.commons.util.Util;

public class BenchmarkHttpClient {
    private static final RestEntity CACHE_VALUE = RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (byte[])"test".getBytes(CharsetUtil.UTF_8));
    private final RestCacheClient cacheClient;
    private final ExecutorCompletionService executorCompletionService;
    private final ExecutorService executor;
    private final RestClient client;

    public BenchmarkHttpClient(RestClientConfiguration configuration, int threads) {
        this.client = RestClient.forConfiguration((RestClientConfiguration)configuration);
        this.cacheClient = this.client.cache("default");
        this.executor = Executors.newFixedThreadPool(threads);
        this.executorCompletionService = new ExecutorCompletionService(this.executor);
    }

    public void performGets(int pertentageOfMisses, int numberOfGets, String existingKey, String nonExistingKey) throws Exception {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < numberOfGets; ++i) {
            String key = ((Random)r).nextInt(100) < pertentageOfMisses ? nonExistingKey : existingKey;
            this.executorCompletionService.submit(() -> {
                count.incrementAndGet();
                this.cacheClient.get(key).whenComplete((resp, e) -> count.decrementAndGet());
                return 1;
            });
        }
        Eventually.eventually(() -> count.get() == 0);
    }

    public void performPuts(int numberOfInserts) {
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < numberOfInserts; ++i) {
            String randomKey = Util.threadLocalRandomUUID().toString();
            this.executorCompletionService.submit(() -> {
                count.incrementAndGet();
                this.cacheClient.post(randomKey, CACHE_VALUE).whenComplete((response, e) -> count.decrementAndGet());
                return 1;
            });
        }
        Eventually.eventually(() -> count.get() == 0);
    }

    public void stop() throws Exception {
        this.client.close();
        this.executor.shutdownNow();
    }
}

