/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.profiling;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.commons.dataconversion.MediaType;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class MediaTypeParsingBenchmark {
    private static final int MEASUREMENT_ITERATIONS_COUNT = 10;
    private static final int WARMUP_ITERATIONS_COUNT = 10;

    public static void main(String[] args) throws Exception {
        Options opt = new OptionsBuilder().include(MediaTypeParsingBenchmark.class.getName() + ".State.*").mode(Mode.AverageTime).timeUnit(TimeUnit.NANOSECONDS).warmupIterations(10).measurementIterations(10).threads(1).forks(3).shouldFailOnError(true).build();
        new Runner(opt).run();
    }

    @org.openjdk.jmh.annotations.State(value=Scope.Benchmark)
    public static class State {
        private final String mediaTypeNoParameter = "application/json";
        private final String mediaTypeOneQuotedParameter = "application/json; charset=\"UTF-8\"";
        private final String mediaTypeOneParameter = "application/x-java-object; type=ByteArray";
        private final String mediaTypeTwoParameters = "application/x-java-object; q=0.2; type=java.lang.Integer";
        private final String mediaTypeList = String.join((CharSequence)", ", "application/json", "application/x-java-object; type=ByteArray", "application/json; charset=\"UTF-8\"", "application/x-java-object; q=0.2; type=java.lang.Integer");

        @Benchmark
        @OperationsPerInvocation(value=100)
        public MediaType parseNoParameter() throws Exception {
            return MediaType.fromString((String)"application/json");
        }

        @Benchmark
        @OperationsPerInvocation(value=100)
        public MediaType parseOneParameter() throws Exception {
            return MediaType.fromString((String)"application/x-java-object; type=ByteArray");
        }

        @Benchmark
        @OperationsPerInvocation(value=100)
        public MediaType parseOneQuotedParameter() throws Exception {
            return MediaType.fromString((String)"application/json; charset=\"UTF-8\"");
        }

        @Benchmark
        @OperationsPerInvocation(value=100)
        public MediaType parseTwoParameters() throws Exception {
            return MediaType.fromString((String)"application/x-java-object; q=0.2; type=java.lang.Integer");
        }

        @Benchmark
        @OperationsPerInvocation(value=100)
        public List<MediaType> parseList() throws Exception {
            return MediaType.parseList((String)this.mediaTypeList).collect(Collectors.toList());
        }
    }
}

