/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.StringBuilderWriter;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.test.security.TestCertificates;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.CounterConfigurationSerializer;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.rest.RequestHeader;
import org.infinispan.rest.RestTestSCI;
import org.infinispan.rest.TestClass;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.authentication.RestAuthenticator;
import org.infinispan.rest.authentication.SecurityDomain;
import org.infinispan.rest.authentication.impl.BasicAuthenticator;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.rest.resources.security.SimpleSecurityDomain;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.server.core.DummyServerStateManager;
import org.infinispan.server.core.ServerStateManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class AbstractRestResourceTest
extends MultipleCacheManagersTest {
    public static final String REALM = "ApplicationRealm";
    public static final Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"ADMIN", "___script_manager", "___schema_manager"});
    public static final Subject USER = TestingUtil.makeSubject((String[])new String[]{"USER", "___script_manager", "___schema_manager"});
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    protected RestClient client;
    protected RestClient adminClient;
    protected static final int NUM_SERVERS = 2;
    private final List<RestServerHelper> restServers = new ArrayList<RestServerHelper>(2);
    protected boolean security;
    protected Protocol protocol = Protocol.HTTP_11;
    protected boolean ssl;
    protected boolean browser;
    protected ServerStateManager serverStateManager;

    protected String parameters() {
        return "[security=" + this.security + ", protocol=" + this.protocol.toString() + ", ssl=" + this.ssl + ", browser=" + this.browser + "]";
    }

    protected AbstractRestResourceTest withSecurity(boolean security) {
        this.security = security;
        return this;
    }

    protected AbstractRestResourceTest protocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    protected AbstractRestResourceTest ssl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    protected AbstractRestResourceTest browser(boolean browser) {
        this.browser = browser;
        return this;
    }

    public ConfigurationBuilder getDefaultCacheBuilder() {
        return AbstractRestResourceTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
    }

    protected boolean isSecurityEnabled() {
        return this.security;
    }

    protected GlobalConfigurationBuilder getGlobalConfigForNode(int id) {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder();
        ((PrivateGlobalConfigurationBuilder)globalBuilder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        TestCacheManagerFactory.configureJmx((GlobalConfigurationBuilder)globalBuilder, (String)(((Object)((Object)this)).getClass().getSimpleName() + id), (MBeanServerLookup)this.mBeanServerLookup);
        globalBuilder.cacheContainer().statistics(true);
        globalBuilder.serialization().addContextInitializer((SerializationContextInitializer)RestTestSCI.INSTANCE);
        if (this.isSecurityEnabled()) {
            this.addSecurity(globalBuilder);
        }
        return globalBuilder.clusteredDefault().cacheManagerName("default");
    }

    protected void addSecurity(GlobalConfigurationBuilder globalBuilder) {
        globalBuilder.security().authorization().enable().groupOnlyMapping(false).principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper()).role("ADMIN").description("admin role").permission(AuthorizationPermission.ALL).role("USER").description("user role").permission(new AuthorizationPermission[]{AuthorizationPermission.WRITE, AuthorizationPermission.READ, AuthorizationPermission.EXEC, AuthorizationPermission.BULK_READ});
    }

    protected void createCacheManagers() throws Exception {
        Security.doAs((Subject)ADMIN, () -> {
            for (int i = 0; i < 2; ++i) {
                GlobalConfigurationBuilder configForNode = this.getGlobalConfigForNode(i);
                this.addClusterEnabledCacheManager(new GlobalConfigurationBuilder().read(configForNode.build()), this.getDefaultCacheBuilder(), TransportFlags.minimalXsiteFlags());
            }
            this.cacheManagers.forEach(this::defineCaches);
            this.cacheManagers.forEach(cm -> cm.defineConfiguration("invalid", this.getDefaultCacheBuilder().encoding().mediaType("application/x-java-object").indexing().enabled(true).addIndexedEntities(new String[]{"invalid"}).build()));
            this.serverStateManager = new DummyServerStateManager();
            for (EmbeddedCacheManager cm2 : this.cacheManagers) {
                BasicComponentRegistry bcr = (BasicComponentRegistry)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cm2).getComponent(BasicComponentRegistry.class);
                bcr.registerComponent(ServerStateManager.class, (Object)this.serverStateManager, false);
                cm2.getClassAllowList().addClasses(new Class[]{TestClass.class});
                this.waitForClusterToForm((String[])cm2.getCacheNames().stream().filter(name -> {
                    try {
                        cm2.getCache(name);
                        return true;
                    }
                    catch (CacheConfigurationException ignored) {
                        return false;
                    }
                }).toArray(String[]::new));
                RestServerHelper restServerHelper = new RestServerHelper(cm2);
                this.configureServer(restServerHelper);
                restServerHelper.start(TestResourceTracker.getCurrentTestShortName());
                this.restServers.add(restServerHelper);
            }
        });
        this.adminClient = RestClient.forConfiguration((RestClientConfiguration)this.getClientConfig("admin", "admin").build());
        this.client = RestClient.forConfiguration((RestClientConfiguration)this.getClientConfig("user", "user").build());
    }

    protected RestServerHelper configureServer(RestServerHelper helper) {
        if (this.isSecurityEnabled()) {
            BasicAuthenticator basicAuthenticator = new BasicAuthenticator((SecurityDomain)new SimpleSecurityDomain(ADMIN, USER), REALM);
            helper.withAuthenticator((RestAuthenticator)basicAuthenticator);
        }
        if (this.ssl) {
            helper.withKeyStore(TestCertificates.certificate((String)"server"), TestCertificates.KEY_PASSWORD, TestCertificates.KEYSTORE_TYPE).withTrustStore(TestCertificates.certificate((String)"trust"), TestCertificates.KEY_PASSWORD, TestCertificates.KEYSTORE_TYPE);
        }
        return helper;
    }

    protected RestServerHelper restServer() {
        return this.restServers.get(0);
    }

    protected void defineCaches(EmbeddedCacheManager cm) {
    }

    @AfterClass
    public void afterClass() {
        Security.doAs((Subject)ADMIN, () -> this.restServers.forEach(RestServerHelper::stop));
        Util.close((AutoCloseable)this.client);
        Util.close((AutoCloseable)this.adminClient);
    }

    @AfterMethod
    public void afterMethod() {
        Security.doAs((Subject)ADMIN, () -> this.restServers.forEach(RestServerHelper::clear));
    }

    private void putInCache(String cacheName, Object key, String keyContentType, String value, String contentType) {
        String url = String.format("/rest/v2/caches/%s/%s", cacheName, key);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (keyContentType != null) {
            headers.put(RequestHeader.KEY_CONTENT_TYPE_HEADER.getValue(), contentType);
        }
        CompletionStage response = this.client.raw().put(url, headers, RestEntity.create((MediaType)MediaType.fromString((String)contentType), (String)value));
        ResponseAssertion.assertThat(response).isOk();
    }

    void putInCache(String cacheName, Object key, String value, String contentType) {
        this.putInCache(cacheName, key, null, value, contentType);
    }

    void putStringValueInCache(String cacheName, String key, String value) {
        this.putInCache(cacheName, key, value, "text/plain; charset=utf-8");
    }

    void putTextEntryInCache(String cacheName, String key, String value) {
        this.putInCache(cacheName, key, "text/plain", value, "text/plain");
    }

    void putJsonValueInCache(String cacheName, String key, String value) {
        this.putInCache(cacheName, key, value, "application/json; charset=utf-8");
    }

    void putBinaryValueInCache(String cacheName, String key, byte[] value, MediaType mediaType) {
        RestEntity restEntity = RestEntity.create((MediaType)mediaType, (byte[])value);
        CompletionStage response = this.client.cache(cacheName).put(key, restEntity);
        ResponseAssertion.assertThat(response).isOk();
    }

    private void removeFromCache(String cacheName, Object key, String keyContentType) {
        String url = String.format("/rest/v2/caches/%s/%s", cacheName, key);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (keyContentType != null) {
            headers.put(RequestHeader.KEY_CONTENT_TYPE_HEADER.getValue(), keyContentType);
        }
        CompletionStage response = this.client.raw().delete(url, headers);
        ResponseAssertion.assertThat(response).isOk();
    }

    void removeTextEntryFromCache(String cacheName, String key) {
        this.removeFromCache(cacheName, key, "text/plain");
    }

    protected RestClientConfigurationBuilder getClientConfig(String username, String password) {
        RestClientConfigurationBuilder clientConfigurationBuilder = new RestClientConfigurationBuilder();
        if (this.protocol != null) {
            clientConfigurationBuilder.protocol(this.protocol);
        }
        if (this.ssl) {
            clientConfigurationBuilder.security().ssl().enable().hostnameVerifier((hostname, session) -> true).trustStoreFileName(TestCertificates.certificate((String)"ca")).trustStorePassword(TestCertificates.KEY_PASSWORD).trustStoreType(TestCertificates.KEYSTORE_TYPE).keyStoreFileName(TestCertificates.certificate((String)"client")).keyStorePassword(TestCertificates.KEY_PASSWORD).keyStoreType(TestCertificates.KEYSTORE_TYPE);
        }
        if (this.isSecurityEnabled()) {
            clientConfigurationBuilder.security().authentication().enable().username(username).password(password);
        }
        if (this.browser) {
            clientConfigurationBuilder.header("User-Agent", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:109.0) Gecko/20100101 Firefox/112.0");
        }
        this.restServers.forEach(s -> clientConfigurationBuilder.addServer().host(s.getHost()).port(s.getPort()));
        return clientConfigurationBuilder;
    }

    public static String cacheConfigToJson(String name, Configuration configuration) {
        org.apache.logging.log4j.core.util.StringBuilderWriter sw = new org.apache.logging.log4j.core.util.StringBuilderWriter();
        try (ConfigurationWriter w = ConfigurationWriter.to((Writer)sw).withType(MediaType.APPLICATION_JSON).prettyPrint(false).build();){
            new ParserRegistry().serialize(w, name, configuration);
        }
        return sw.toString();
    }

    public static String counterConfigToJson(AbstractCounterConfiguration config) {
        StringBuilderWriter sw = new StringBuilderWriter();
        try (ConfigurationWriter w = ConfigurationWriter.to((Writer)sw).withType(MediaType.APPLICATION_JSON).build();){
            new CounterConfigurationSerializer().serializeConfiguration(w, config);
        }
        return sw.toString();
    }

    protected RestResponse join(CompletionStage<RestResponse> responseStage) {
        RestResponse response = (RestResponse)CompletionStages.join(responseStage);
        this.checkBrowserHeaders(response);
        return response;
    }

    protected void checkBrowserHeaders(RestResponse response) {
        if (this.browser) {
            AssertJUnit.assertEquals((String)"sameorigin", (String)response.header("X-Frame-Options"));
            AssertJUnit.assertEquals((String)"1; mode=block", (String)response.header("X-XSS-Protection"));
            AssertJUnit.assertEquals((String)"nosniff", (String)response.header("X-Content-Type-Options"));
            if (this.ssl) {
                AssertJUnit.assertEquals((String)"max-age=31536000 ; includeSubDomains", (String)response.header("Strict-Transport-Security"));
            }
        }
    }
}

