/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.AccessManagementResourceTest")
public class AccessManagementResourceTest
extends AbstractRestResourceTest {
    public Object[] factory() {
        return new Object[]{new AccessManagementResourceTest().withSecurity(true).protocol(Protocol.HTTP_11).ssl(false).browser(false), new AccessManagementResourceTest().withSecurity(true).protocol(Protocol.HTTP_20).ssl(false).browser(false)};
    }

    @Test
    public void testRolesList() {
        CompletionStage response = this.adminClient.security().listRoles();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        Json jsonNode = Json.read((String)this.join(response).body());
        Assertions.assertThat((boolean)jsonNode.isArray()).isTrue();
        Assertions.assertThat((List)jsonNode.asList()).containsExactlyInAnyOrder(new Object[]{"ADMIN", "USER"});
        response = this.adminClient.security().listRoles(false);
        jsonNode = Json.read((String)this.join(response).body());
        Assertions.assertThat((boolean)jsonNode.isArray()).isTrue();
        Assertions.assertThat((List)jsonNode.asList()).containsExactlyInAnyOrder(new Object[]{"ADMIN", "USER"});
    }

    @Test
    public void testDescribeRole() {
        CompletionStage response = this.adminClient.security().describeRole("ADMIN");
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)this.join(response).body());
        Assertions.assertThat((String)jsonNode.at("name").asString()).isEqualTo("ADMIN");
        Assertions.assertThat((List)jsonNode.at("permissions").asList()).containsExactly(new Object[]{"ALL"});
        Assertions.assertThat((String)jsonNode.at("description").asString()).contains(new CharSequence[]{"admin role"});
        Assertions.assertThat((boolean)jsonNode.at("implicit").asBoolean()).isFalse();
    }

    @Test
    public void testCRUDRole() {
        CompletionStage createRoleResponse = this.adminClient.security().createRole("NEW_ROLE", "something", List.of("ALL"));
        ResponseAssertion.assertThat(createRoleResponse).isOk();
        createRoleResponse = this.adminClient.security().createRole("NEW_ROLE", "something", List.of("ALL"));
        ResponseAssertion.assertThat(createRoleResponse).isConflicted();
        CompletionStage readNewRole = this.adminClient.security().describeRole("NEW_ROLE");
        ResponseAssertion.assertThat(readNewRole).isOk();
        ResponseAssertion.assertThat(readNewRole).hasContentType("application/json");
        Json jsonRole = Json.read((String)this.join(readNewRole).body());
        AccessManagementResourceTest.assertRoleJson(jsonRole, "ALL", "something");
        CompletionStage updateResponse = this.adminClient.security().updateRole("NEW_ROLE", "desUpdate", Collections.emptyList());
        ResponseAssertion.assertThat(updateResponse).isOk();
        CompletionStage updatedRole = this.adminClient.security().describeRole("NEW_ROLE");
        Json jsonUpdatedRole = Json.read((String)this.join(updatedRole).body());
        AccessManagementResourceTest.assertRoleJson(jsonUpdatedRole, "ALL", "desUpdate");
        updateResponse = this.adminClient.security().updateRole("NEW_ROLE", "", Collections.singletonList("READ"));
        ResponseAssertion.assertThat(updateResponse).isOk();
        updatedRole = this.adminClient.security().describeRole("NEW_ROLE");
        jsonUpdatedRole = Json.read((String)this.join(updatedRole).body());
        AccessManagementResourceTest.assertRoleJson(jsonUpdatedRole, "READ", "desUpdate");
        CompletionStage removeRole = this.adminClient.security().removeRole("NEW_ROLE");
        ResponseAssertion.assertThat(removeRole).isOk();
        ResponseAssertion.assertThat(this.adminClient.security().describeRole("NEW_ROLE")).isNotFound();
    }

    private static void assertRoleJson(Json jsonRole, String permission, String something) {
        Assertions.assertThat((String)jsonRole.at("name").asString()).isEqualTo("NEW_ROLE");
        Assertions.assertThat((List)jsonRole.at("permissions").asList()).containsExactly(new Object[]{permission});
        Assertions.assertThat((String)jsonRole.at("description").asString()).isEqualTo(something);
        Assertions.assertThat((boolean)jsonRole.at("implicit").asBoolean()).isFalse();
    }

    @Test
    public void testDetailedRolesList() {
        CompletionStage response = this.adminClient.security().listRoles(true);
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        Json jsonNode = Json.read((String)this.join(response).body());
        Assertions.assertThat((Map)jsonNode.asJsonMap()).hasSize(2);
        Assertions.assertThat((List)jsonNode.at("ADMIN").at("permissions").asList()).containsExactly(new Object[]{"ALL"});
        Assertions.assertThat((boolean)jsonNode.at("ADMIN").at("inheritable").asBoolean()).isTrue();
        Assertions.assertThat((boolean)jsonNode.at("ADMIN").at("implicit").asBoolean()).isFalse();
        Assertions.assertThat((String)jsonNode.at("ADMIN").at("description").asString()).contains(new CharSequence[]{"admin role"});
        Assertions.assertThat((List)jsonNode.at("USER").at("permissions").asList()).containsExactlyInAnyOrder(new Object[]{"READ", "WRITE", "BULK_READ", "EXEC"});
        Assertions.assertThat((boolean)jsonNode.at("USER").at("inheritable").asBoolean()).isTrue();
        Assertions.assertThat((boolean)jsonNode.at("USER").at("implicit").asBoolean()).isFalse();
        Assertions.assertThat((String)jsonNode.at("USER").at("description").asString()).contains(new CharSequence[]{"user role"});
    }
}

