/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.reactivex.rxjava3.core.Flowable;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.client.rest.MultiPartRestEntity;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestEventListener;
import org.infinispan.client.rest.RestRawClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.configuration.io.PropertyReplacer;
import org.infinispan.commons.configuration.io.URLConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.yaml.YamlConfigurationReader;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.globalstate.impl.CacheState;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.SegmentPublisherSupplier;
import org.infinispan.rest.RequestHeader;
import org.infinispan.rest.ResponseHeader;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.rest.resources.SSEListener;
import org.infinispan.test.TestException;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.function.SerializablePredicate;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.testng.reporters.Files;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Test(groups={"functional"}, testName="rest.CacheResourceV2Test")
public class CacheResourceV2Test
extends AbstractRestResourceTest {
    private static final long MIN_NON_EMPTY_INDEX_SIZE = 1000L;
    private static final String PERSISTENT_LOCATION = CommonsTestingUtil.tmpDirectory((String[])new String[]{CacheResourceV2Test.class.getName()});
    private static final String PROTO_SCHEMA = " /* @Indexed */                     \n message Entity {                   \n    /* @Basic */                    \n    required int32 value=1;         \n    optional string description=2;  \n }                                  \n /* @Indexed */                     \n message Another {                  \n    /* @Basic */                    \n    required int32 value=1;         \n    optional string description=2;  \n }";
    public static final String ACCEPT = "Accept";
    protected CacheMode cacheMode;

    @Override
    protected String parameters() {
        return "[security=" + this.security + ", protocol=" + this.protocol.toString() + ", ssl=" + this.ssl + ", cacheMode=" + String.valueOf(this.cacheMode) + ", browser=" + this.browser + "]";
    }

    protected CacheResourceV2Test withCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
        ConfigurationBuilder configurationBuilder = this.getDefaultCacheBuilder();
        if (this.cacheMode != null) {
            configurationBuilder.clustering().cacheMode(this.cacheMode).hash().numOwners(1);
        }
        cm.defineConfiguration("default", configurationBuilder.build());
        cm.defineConfiguration("proto", this.getProtoCacheBuilder().build());
        cm.defineConfiguration("simple-text", this.getTextCacheBuilder().build());
        if (this.security) {
            cm.defineConfiguration("secured-simple-text", this.getTextCacheBuilder().security().authorization().enable().roles(new String[]{"ADMIN"}).build());
        }
        Cache metadataCache = cm.getCache("___protobuf_metadata");
        metadataCache.putIfAbsent((Object)"sample.proto", (Object)PROTO_SCHEMA);
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        cm.defineConfiguration("indexedCache", this.getIndexedPersistedCache().build());
        cm.defineConfiguration("denyReadWritesCache", this.getDefaultCacheBuilder().clustering().partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES).build());
    }

    public ConfigurationBuilder getProtoCacheBuilder() {
        ConfigurationBuilder builder = CacheResourceV2Test.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.encoding().mediaType("application/x-protostream");
        return builder;
    }

    public ConfigurationBuilder getTextCacheBuilder() {
        ConfigurationBuilder builder = CacheResourceV2Test.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.encoding().mediaType("text/plain");
        return builder;
    }

    public Object[] factory() {
        return new Object[]{new CacheResourceV2Test().withSecurity(false).protocol(Protocol.HTTP_11).ssl(false).browser(false), new CacheResourceV2Test().withSecurity(false).protocol(Protocol.HTTP_11).ssl(false).browser(true), new CacheResourceV2Test().withSecurity(true).protocol(Protocol.HTTP_20).ssl(false).browser(false), new CacheResourceV2Test().withSecurity(true).protocol(Protocol.HTTP_20).ssl(false).browser(true), new CacheResourceV2Test().withSecurity(true).protocol(Protocol.HTTP_11).ssl(true).browser(false), new CacheResourceV2Test().withSecurity(true).protocol(Protocol.HTTP_11).ssl(true).browser(true), new CacheResourceV2Test().withSecurity(true).protocol(Protocol.HTTP_20).ssl(true).browser(false), new CacheResourceV2Test().withSecurity(true).protocol(Protocol.HTTP_20).ssl(true).browser(true), new CacheResourceV2Test().withCacheMode(CacheMode.DIST_SYNC).withSecurity(false).protocol(Protocol.HTTP_11).ssl(false).browser(false), new CacheResourceV2Test().withCacheMode(CacheMode.DIST_SYNC).withSecurity(false).protocol(Protocol.HTTP_11).ssl(false).browser(true), new CacheResourceV2Test().withCacheMode(CacheMode.DIST_SYNC).withSecurity(true).protocol(Protocol.HTTP_20).ssl(false).browser(false), new CacheResourceV2Test().withCacheMode(CacheMode.DIST_SYNC).withSecurity(true).protocol(Protocol.HTTP_20).ssl(false).browser(true), new CacheResourceV2Test().withCacheMode(CacheMode.DIST_SYNC).withSecurity(true).protocol(Protocol.HTTP_11).ssl(true).browser(false), new CacheResourceV2Test().withCacheMode(CacheMode.DIST_SYNC).withSecurity(true).protocol(Protocol.HTTP_11).ssl(true).browser(true), new CacheResourceV2Test().withCacheMode(CacheMode.DIST_SYNC).withSecurity(true).protocol(Protocol.HTTP_20).ssl(true).browser(false), new CacheResourceV2Test().withCacheMode(CacheMode.DIST_SYNC).withSecurity(true).protocol(Protocol.HTTP_20).ssl(true).browser(true)};
    }

    private ConfigurationBuilder getIndexedPersistedCache() {
        ConfigurationBuilder builder = CacheResourceV2Test.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.statistics().enable();
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("Entity").addIndexedEntity("Another").statistics().enable().persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).shared(true)).storeName("store");
        return builder;
    }

    @Override
    protected void createCacheManagers() throws Exception {
        Util.recursiveFileRemove((String)PERSISTENT_LOCATION);
        super.createCacheManagers();
    }

    @Override
    protected GlobalConfigurationBuilder getGlobalConfigForNode(int id) {
        GlobalConfigurationBuilder config = super.getGlobalConfigForNode(id);
        config.globalState().enable().configurationStorage(ConfigurationStorage.OVERLAY).persistentLocation(Paths.get(PERSISTENT_LOCATION, Integer.toString(id)).toString()).metrics().accurateSize(true);
        return config;
    }

    @Test
    public void testCacheV2KeyOps() {
        RestCacheClient cacheClient = this.client.cache("default");
        RestResponse response = this.join(cacheClient.post("key", "value"));
        ResponseAssertion.assertThat(response).isOk();
        response = this.join(cacheClient.post("key", "value"));
        ResponseAssertion.assertThat(response).isConflicted().hasReturnedText("An entry already exists");
        response = this.join(cacheClient.put("key", "value-new"));
        ResponseAssertion.assertThat(response).isOk();
        response = this.join(cacheClient.get("key"));
        ResponseAssertion.assertThat(response).hasReturnedText("value-new");
        response = this.join(cacheClient.head("key"));
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasNoContent();
        response = this.join(cacheClient.remove("key"));
        ResponseAssertion.assertThat(response).isOk();
        response = this.join(cacheClient.get("key"));
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void testCreateCacheEncodedName() {
        this.testCreateAndUseCache("a/");
        this.testCreateAndUseCache("a/b/c");
        this.testCreateAndUseCache("a-b-c");
        this.testCreateAndUseCache("\u00e1b\\\u0107\u00e9/+-$");
        this.testCreateAndUseCache("org.infinispan.cache");
        this.testCreateAndUseCache("a%25bc");
    }

    @Test
    public void testCreateCacheEncoding() {
        String cacheName = "encoding-test";
        String json = "{\"local-cache\":{\"encoding\":{\"media-type\":\"text/plain\"}}}";
        this.createCache(json, cacheName);
        String cacheConfig = this.getCacheConfig("application/json", cacheName);
        Json encoding = Json.read((String)cacheConfig).at(cacheName).at("local-cache").at("encoding");
        Json mediaType = encoding.at("media-type");
        AssertJUnit.assertEquals((String)"text/plain", (String)mediaType.asString());
    }

    private void testCreateAndUseCache(String name) {
        String cacheConfig = "{\"distributed-cache\":{\"mode\":\"SYNC\"}}";
        RestCacheClient cacheClient = this.client.cache(name);
        RestEntity config = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheConfig);
        CompletionStage response = cacheClient.createWithConfiguration(config, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        CompletionStage sizeResponse = cacheClient.size();
        ResponseAssertion.assertThat(sizeResponse).isOk();
        ResponseAssertion.assertThat(sizeResponse).containsReturnedText("0");
        RestResponse namesResponse = this.join(this.client.caches());
        ResponseAssertion.assertThat(namesResponse).isOk();
        List names = Json.read((String)namesResponse.body()).asJsonList().stream().map(Json::asString).collect(Collectors.toList());
        AssertJUnit.assertTrue((boolean)names.contains(name));
        CompletionStage putResponse = cacheClient.post("key", "value");
        ResponseAssertion.assertThat(putResponse).isOk();
        CompletionStage getResponse = cacheClient.get("key");
        ResponseAssertion.assertThat(getResponse).isOk();
        ResponseAssertion.assertThat(getResponse).containsReturnedText("value");
    }

    @Test
    public void testCreateAndAlterCache() {
        String cacheConfig = "{\n  \"distributed-cache\" : {\n    \"mode\" : \"SYNC\",\n    \"statistics\" : true,\n    \"encoding\" : {\n      \"key\" : {\n        \"media-type\" : \"application/x-protostream\"\n      },\n      \"value\" : {\n        \"media-type\" : \"application/x-protostream\"\n      }\n    },\n    \"expiration\" : {\n      \"lifespan\" : \"60000\"\n    },\n    \"memory\" : {\n      \"max-count\" : \"1000\",\n      \"when-full\" : \"REMOVE\"\n    }\n  }\n}\n";
        String cacheConfigAlter = "{\n  \"distributed-cache\" : {\n    \"mode\" : \"SYNC\",\n    \"statistics\" : true,\n    \"encoding\" : {\n      \"key\" : {\n        \"media-type\" : \"application/x-protostream\"\n      },\n      \"value\" : {\n        \"media-type\" : \"application/x-protostream\"\n      }\n    },\n    \"expiration\" : {\n      \"lifespan\" : \"30000\"\n    },\n    \"memory\" : {\n      \"max-count\" : \"2000\",\n      \"when-full\" : \"REMOVE\"\n    }\n  }\n}\n";
        String cacheConfigConflict = "{\n  \"distributed-cache\" : {\n    \"mode\" : \"ASYNC\"\n  }\n}\n";
        RestCacheClient cacheClient = this.client.cache("mutable");
        CompletionStage response = cacheClient.createWithConfiguration(RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheConfig), new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.updateWithConfiguration(RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheConfigAlter), new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        response = this.adminClient.cache("mutable").configuration();
        ResponseAssertion.assertThat(response).isOk();
        String configFromServer = this.join(response).body();
        AssertJUnit.assertTrue((boolean)configFromServer.contains("\"expiration\":{\"lifespan\":\"30000\"}"));
        AssertJUnit.assertTrue((boolean)configFromServer.contains("\"memory\":{\"max-count\":\"2000\""));
        response = cacheClient.updateWithConfiguration(RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheConfigConflict), new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isBadRequest();
    }

    @Test
    public void testUpdateFailure() {
        String cacheConfig = "localCache:\n  encoding:\n    mediaType: \"application/x-protostream\"\n";
        String cacheConfigAlter = "localCache:\n  encoding:\n    mediaType: \"application/x-java-serialized-object\"\n";
        RestCacheClient cacheClient = this.client.cache("updateFailure");
        CompletionStage response = cacheClient.createWithConfiguration(RestEntity.create((MediaType)MediaType.APPLICATION_YAML, (String)cacheConfig), new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.updateWithConfiguration(RestEntity.create((MediaType)MediaType.APPLICATION_YAML, (String)cacheConfigAlter), new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isBadRequest();
        String body = this.join(response).body();
        Assertions.assertThat((String)body).contains(new CharSequence[]{"ISPN000961: Incompatible attribute"});
    }

    @Test
    public void testMutableAttributes() {
        String cacheName = "mutable-attributes";
        String json = "{\"local-cache\":{\"encoding\":{\"media-type\":\"text/plain\"}}}";
        RestCacheClient cacheClient = this.createCache(this.adminClient, json, cacheName);
        CompletionStage response = cacheClient.configurationAttributes(true);
        ResponseAssertion.assertThat(response).isOk();
        Json attributes = Json.read((String)this.join(response).body());
        AssertJUnit.assertEquals((int)15, (int)attributes.asJsonMap().size());
        AssertJUnit.assertEquals((String)"long", (String)attributes.at("clustering.remote-timeout").at("type").asString());
        AssertJUnit.assertEquals((long)15000L, (long)attributes.at("clustering.remote-timeout").at("value").asLong());
        Assertions.assertThat((String)attributes.at("indexing.indexed-entities").at("type").asString()).isEqualTo("set");
        Assertions.assertThat((List)attributes.at("indexing.indexed-entities").at("value").asList()).isEmpty();
    }

    public void testUpdateConfigurationAttribute() {
        String protoSchema = "package org.infinispan;\n\n/**\n * @Indexed\n */\nmessage Developer {\n   /**\n    * @Basic\n    */\n   optional string nick = 1;\n   /**\n    * @Basic(sortable=true)\n    */\n   optional int32 contributions = 2;\n}\n/**\n * @Indexed\n */\nmessage Engineer {  \n   /**\n    * @Basic\n    */\n   optional string nick = 1;\n   /**\n    * @Basic(sortable=true)\n    */\n   optional int32 contributions = 2;\n}\n";
        RestResponse restResponse = this.join(this.client.schemas().put("dev.proto", protoSchema));
        ResponseAssertion.assertThat(restResponse).isOk();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntities(new String[]{"org.infinispan.Developer"});
        String cacheConfig = CacheResourceV2Test.cacheConfigToJson("developers", builder.build());
        RestCacheClient cacheClient = this.adminClient.cache("developers");
        RestEntity config = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheConfig);
        CompletionStage response = cacheClient.createWithConfiguration(config, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.updateConfigurationAttribute("indexing.indexed-entities", "org.infinispan.Developer org.infinispan.Engineer");
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.configuration();
        ResponseAssertion.assertThat(response).isOk();
        String configFromServer = this.join(response).body();
        Assertions.assertThat((String)configFromServer).contains(new CharSequence[]{"\"indexed-entities\":[\"org.infinispan.Engineer\",\"org.infinispan.Developer\"]"});
    }

    @Test
    public void testCacheV2LifeCycle() throws Exception {
        String xml = Util.getResourceAsString((String)"cache.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        String json = Util.getResourceAsString((String)"cache.json", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        RestEntity xmlEntity = RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)xml);
        RestEntity jsonEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json);
        CompletionStage response = this.client.cache("cache1").createWithConfiguration(xmlEntity, new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE});
        ResponseAssertion.assertThat(response).isOk();
        this.assertPersistence("cache1", false);
        response = this.client.cache("cache2").createWithConfiguration(jsonEntity, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        this.assertPersistence("cache2", true);
        String mediaList = "application/json,text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        response = this.adminClient.cache("cache1").configuration(mediaList);
        ResponseAssertion.assertThat(response).isOk();
        String cache1Cfg = this.join(response).body();
        response = this.adminClient.cache("cache2").configuration();
        ResponseAssertion.assertThat(response).isOk();
        String cache2Cfg = this.join(response).body();
        AssertJUnit.assertEquals((String)cache1Cfg, (String)cache2Cfg.replace("cache2", "cache1"));
        response = this.adminClient.cache("cache1").configuration("application/xml");
        ResponseAssertion.assertThat(response).isOk();
        String cache1Xml = this.join(response).body();
        ParserRegistry registry = new ParserRegistry();
        Configuration xmlConfig = registry.parse(cache1Xml).getCurrentConfigurationBuilder().build();
        AssertJUnit.assertEquals((long)1200000L, (long)xmlConfig.clustering().l1().lifespan());
        AssertJUnit.assertEquals((long)60500L, (long)xmlConfig.clustering().stateTransfer().timeout());
        response = this.adminClient.cache("cache1").configuration("application/xml; q=0.9");
        ResponseAssertion.assertThat(response).isOk();
    }

    @Test
    public void testCreateDeleteCache() throws Exception {
        this.createDeleteCache(Util.getResourceAsString((String)"cache.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
    }

    @Test
    public void testCreateDeleteCacheFromFragment() throws Exception {
        this.createDeleteCache(Util.getResourceAsString((String)"cache-fragment.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
    }

    private void createDeleteCache(String xml) {
        RestEntity xmlEntity = RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)xml);
        RestCacheClient cacheClient = this.client.cache("cacheCRUD");
        CompletionStage response = cacheClient.createWithConfiguration(xmlEntity, new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE});
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.stats();
        ResponseAssertion.assertThat(response).isOk().hasJson().hasProperty("current_number_of_entries").is(-1);
        response = cacheClient.delete();
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.stats();
        ResponseAssertion.assertThat(response).isNotFound().hasReturnedText("ISPN012010: Cache with name 'cacheCRUD' not found amongst the configured caches");
    }

    private void assertPersistence(String name, boolean persisted) {
        EmbeddedCacheManager cm = (EmbeddedCacheManager)this.cacheManagers.iterator().next();
        Cache configCache = cm.getCache("org.infinispan.CONFIG");
        AssertJUnit.assertEquals((boolean)persisted, (boolean)configCache.entrySet().stream().anyMatch((SerializablePredicate & Serializable)e -> ((ScopedState)e.getKey()).getName().equals(name) && !((CacheState)e.getValue()).getFlags().contains(CacheContainerAdmin.AdminFlag.VOLATILE)));
    }

    @Test
    public void testCacheV2Stats() {
        String cacheJson = "{ \"distributed-cache\" : { \"statistics\":true } }";
        RestCacheClient cacheClient = this.client.cache("statCache");
        RestEntity jsonEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheJson);
        CompletionStage response = cacheClient.createWithConfiguration(jsonEntity, new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE});
        ResponseAssertion.assertThat(response).isOk();
        this.putStringValueInCache("statCache", "key1", "data");
        this.putStringValueInCache("statCache", "key2", "data");
        response = cacheClient.stats();
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)this.join(response).body());
        AssertJUnit.assertEquals((int)jsonNode.at("current_number_of_entries").asInteger(), (int)2);
        AssertJUnit.assertEquals((int)jsonNode.at("stores").asInteger(), (int)2);
        response = cacheClient.clear();
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.stats();
        ResponseAssertion.assertThat(response).isOk().hasJson().hasProperty("current_number_of_entries").is(0);
    }

    @Test
    public void getCacheInfoInternalCache() {
        RestCacheClient scriptCache = this.client.cache("___script_cache");
        CompletionStage details = scriptCache.details();
        ResponseAssertion.assertThat(details).isOk();
        RestResponse response = this.join(details);
        String body = response.body();
        Assertions.assertThat((String)body).isNotBlank();
    }

    @Test
    public void testCacheV2Distribution() {
        String cacheJson = "{ \"distributed-cache\" : { \"statistics\":true, \"memory\" : {\"storage\": \"OFF_HEAP\", \"max-size\": \"1MB\" } } }";
        RestCacheClient cacheClient = this.client.cache("distributionCache");
        RestEntity jsonEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheJson);
        CompletionStage response = cacheClient.createWithConfiguration(jsonEntity, new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE});
        ResponseAssertion.assertThat(response).isOk();
        this.putStringValueInCache("distributionCache", "key1", "data");
        this.putStringValueInCache("distributionCache", "key2", "data");
        response = cacheClient.distribution();
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)this.join(response).body());
        AssertJUnit.assertTrue((boolean)jsonNode.isArray());
        List jsons = jsonNode.asJsonList();
        AssertJUnit.assertEquals((int)2, (int)jsons.size());
        Pattern pattern = Pattern.compile(((Object)((Object)this)).getClass().getSimpleName() + "-Node[a-zA-Z]$");
        HashMap<String, Long> previousSizes = new HashMap<String, Long>();
        for (Json node : jsons) {
            AssertJUnit.assertEquals((int)node.at("memory_entries").asInteger(), (int)2);
            AssertJUnit.assertEquals((int)node.at("total_entries").asInteger(), (int)2);
            AssertJUnit.assertEquals((int)node.at("node_addresses").asJsonList().size(), (int)1);
            AssertJUnit.assertTrue((boolean)pattern.matcher(node.at("node_name").asString()).matches());
            AssertJUnit.assertTrue((node.at("memory_used").asLong() > 0L ? 1 : 0) != 0);
            previousSizes.put(node.at("node_name").asString(), node.at("memory_used").asLong());
        }
        response = cacheClient.clear();
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.distribution();
        ResponseAssertion.assertThat(response).isOk();
        jsonNode = Json.read((String)this.join(response).body());
        AssertJUnit.assertTrue((boolean)jsonNode.isArray());
        jsons = jsonNode.asJsonList();
        AssertJUnit.assertEquals((int)2, (int)jsons.size());
        for (Json node : jsons) {
            AssertJUnit.assertEquals((int)node.at("memory_entries").asInteger(), (int)0);
            AssertJUnit.assertEquals((int)node.at("total_entries").asInteger(), (int)0);
            AssertJUnit.assertTrue((node.at("memory_used").asLong() > 0L ? 1 : 0) != 0);
            AssertJUnit.assertTrue((node.at("memory_used").asLong() < (Long)previousSizes.get(node.at("node_name").asString()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCacheV2KeyDistribution() {
        String cacheName = "keyDistribution";
        String cacheJson = "{ \"distributed-cache\" : { \"statistics\":true } }";
        this.createCache(cacheJson, "keyDistribution");
        RestCacheClient cacheClient = this.client.cache("keyDistribution");
        this.putStringValueInCache("keyDistribution", "key1", "data");
        this.putStringValueInCache("keyDistribution", "key2", "data");
        Map<String, Boolean> sample = Map.of("key1", true, "key2", true, "unknown", false);
        for (Map.Entry<String, Boolean> entry : sample.entrySet()) {
            CompletionStage response = cacheClient.distribution(entry.getKey());
            ResponseAssertion.assertThat(response).isOk();
            try {
                RestResponse restResponse = this.join(response);
                try {
                    Json jsonNode = Json.read((String)restResponse.body());
                    AssertJUnit.assertEquals((boolean)entry.getValue(), (boolean)jsonNode.at("contains_key").asBoolean());
                    AssertJUnit.assertTrue((boolean)jsonNode.at("owners").isArray());
                    List distribution = jsonNode.at("owners").asJsonList();
                    AssertJUnit.assertEquals((int)2, (int)distribution.size());
                    Pattern pattern = Pattern.compile(((Object)((Object)this)).getClass().getSimpleName() + "-Node[a-zA-Z]$");
                    for (Json node : distribution) {
                        AssertJUnit.assertEquals((int)node.at("node_addresses").asJsonList().size(), (int)1);
                        AssertJUnit.assertTrue((boolean)pattern.matcher(node.at("node_name").asString()).matches());
                        AssertJUnit.assertTrue((boolean)node.has("primary"));
                    }
                    if (entry.getValue().booleanValue()) {
                        AssertJUnit.assertTrue((boolean)distribution.stream().anyMatch(n -> n.at("primary").asBoolean()));
                        continue;
                    }
                    AssertJUnit.assertTrue((boolean)distribution.stream().noneMatch(n -> n.at("primary").asBoolean()));
                }
                finally {
                    if (restResponse == null) continue;
                    restResponse.close();
                }
            }
            catch (Exception e) {
                throw new TestException((Throwable)e);
            }
        }
    }

    @Test
    public void testCacheSize() {
        for (int i = 0; i < 100; ++i) {
            this.putInCache("default", i, "" + i, "application/json");
        }
        CompletionStage response = this.client.cache("default").size();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).containsReturnedText("100");
    }

    @Test
    public void testCaches() {
        RestResponse response = this.join(this.adminClient.detailedCacheList());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.body();
        Json jsonNode = Json.read((String)json);
        List<String> names = this.find(jsonNode, "name");
        HashSet expectedNames = new HashSet(((EmbeddedCacheManager)this.cacheManagers.get(0)).getCacheNames());
        expectedNames.remove("___script_cache");
        expectedNames.remove("___protobuf_metadata");
        AssertJUnit.assertEquals(expectedNames, new HashSet<String>(names));
        List<String> status = this.find(jsonNode, "status");
        Assert.assertTrue((boolean)status.contains("RUNNING"));
        List<String> types = this.find(jsonNode, "type");
        Assert.assertTrue((boolean)types.contains("distributed-cache"));
        List<String> simpleCaches = this.find(jsonNode, "simple_cache");
        Assert.assertTrue((boolean)simpleCaches.contains("false"));
        List<String> transactional = this.find(jsonNode, "transactional");
        Assert.assertTrue((boolean)transactional.contains("false"));
        List<String> persistent = this.find(jsonNode, "persistent");
        Assert.assertTrue((boolean)persistent.contains("false"));
        List<String> bounded = this.find(jsonNode, "bounded");
        Assert.assertTrue((boolean)bounded.contains("false"));
        List<String> secured = this.find(jsonNode, "secured");
        Assert.assertTrue((boolean)secured.contains("false"));
        List<String> indexed = this.find(jsonNode, "indexed");
        Assert.assertTrue((boolean)indexed.contains("false"));
        List<String> hasRemoteBackup = this.find(jsonNode, "has_remote_backup");
        Assert.assertTrue((boolean)hasRemoteBackup.contains("false"));
        List<String> health = this.find(jsonNode, "health");
        Assert.assertTrue((boolean)health.contains("HEALTHY"));
        List<String> isRebalancingEnabled = this.find(jsonNode, "rebalancing_enabled");
        Assert.assertTrue((boolean)isRebalancingEnabled.contains("true"));
    }

    private List<String> find(Json array, String name) {
        return array.asJsonList().stream().map(j -> j.at(name).getValue().toString()).collect(Collectors.toList());
    }

    @Test
    public void testCacheFullDetail() {
        RestResponse response = this.join(this.adminClient.cache("proto").details());
        Json document = Json.read((String)response.body());
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((Object)document.at("stats")).isNotNull();
        Assertions.assertThat((Object)document.at("size")).isNotNull();
        Assertions.assertThat((Object)document.at("configuration")).isNotNull();
        Assertions.assertThat((Object)document.at("rehash_in_progress")).isNotNull();
        Assertions.assertThat((Object)document.at("persistent")).isNotNull();
        Assertions.assertThat((Object)document.at("bounded")).isNotNull();
        Assertions.assertThat((Object)document.at("indexed")).isNotNull();
        Assertions.assertThat((Object)document.at("has_remote_backup")).isNotNull();
        Assertions.assertThat((Object)document.at("secured")).isNotNull();
        Assertions.assertThat((Object)document.at("indexing_in_progress")).isNotNull();
        Assertions.assertThat((Object)document.at("queryable")).isNotNull();
        Assertions.assertThat((Object)document.at("rebalancing_enabled")).isNotNull();
        Assertions.assertThat((String)document.at("key_storage").asString()).isEqualTo("application/x-protostream");
        Assertions.assertThat((String)document.at("value_storage").asString()).isEqualTo("application/x-protostream");
        Assertions.assertThat((String)document.at("mode").asString()).isEqualTo("DIST_SYNC");
        Assertions.assertThat((String)document.at("storage_type").asString()).isEqualTo("HEAP");
        Assertions.assertThat((String)document.at("max_size").asString()).isEmpty();
        Assertions.assertThat((long)document.at("max_size_bytes").asLong()).isEqualTo(-1L);
        if (this.security) {
            response = this.join(this.client.cache("default").details());
            document = Json.read((String)response.body());
            ResponseAssertion.assertThat(response).isOk();
            Assertions.assertThat((Object)document.at("configuration")).isNull();
            Assertions.assertThat((Object)document.at("storage_type")).isNull();
            Assertions.assertThat((Object)document.at("max_size")).isNull();
            Assertions.assertThat((Object)document.at("max_size_bytes")).isNull();
        }
        response = this.join(this.client.cache("proto").details());
        document = Json.read((String)response.body());
        Assertions.assertThat((String)document.at("key_storage").asString()).isEqualTo("application/x-protostream");
        Assertions.assertThat((String)document.at("value_storage").asString()).isEqualTo("application/x-protostream");
    }

    public void testCacheQueryable() {
        this.createCache(new ConfigurationBuilder(), "cacheNotQueryable");
        Json details = this.getCacheDetail("cacheNotQueryable");
        AssertJUnit.assertFalse((boolean)details.at("queryable").asBoolean());
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP);
        builder.indexing().enable().addIndexedEntity("Entity");
        this.createCache(builder, "cacheIndexed");
        details = this.getCacheDetail("cacheIndexed");
        AssertJUnit.assertTrue((boolean)details.at("queryable").asBoolean());
        ConfigurationBuilder proto = new ConfigurationBuilder();
        proto.encoding().mediaType("application/x-protostream");
        this.createCache(proto, "cacheQueryable");
        details = this.getCacheDetail("cacheQueryable");
        AssertJUnit.assertTrue((boolean)details.at("queryable").asBoolean());
    }

    @Test
    public void testCreateInvalidCache() {
        String invalidConfig = "<infinispan>\n <cache-container>\n   <replicated-cache name=\"books\">\n     <encoding media-type=\"application/x-java-object\"/>\n     <indexing>\n       <indexed-entities>\n         <indexed-entity>Dummy</indexed-entity>\n        </indexed-entities>\n     </indexing>\n   </replicated-cache>\n </cache-container>\n</infinispan>";
        CompletionStage response = this.client.cache("CACHE").createWithConfiguration(RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)invalidConfig), new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isBadRequest().containsReturnedText("Cannot instantiate class 'Dummy'");
        response = this.client.cache("CACHE").exists();
        ResponseAssertion.assertThat(response).isOk();
        CompletionStage healthResponse = this.client.container().health();
        ResponseAssertion.assertThat(healthResponse).isOk().containsReturnedText("{\"status\":\"FAILED\",\"cache_name\":\"CACHE\"}");
        response = this.client.cache("CACHE").delete();
        ResponseAssertion.assertThat(response).isOk();
        response = this.client.cache("CACHE").exists();
        ResponseAssertion.assertThat(response).isNotFound();
        invalidConfig = "<distributed-cache>\n   <encoding>\n      <key media-type=\"application/x-protostream\"/>\n      <value media-type=\"application/x-protostream\"/>\n   </encoding\n</distributed-cache>\n";
        response = this.client.cache("CACHE").createWithConfiguration(RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)invalidConfig), new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isBadRequest().hasReturnedText("expected > to finish end tag not < from line 2 (position: TEXT seen ...<value media-type=\"application/x-protostream\"/>\\n   </encoding\\n<... @6:2) ");
        response = this.client.cache("CACHE").exists();
        ResponseAssertion.assertThat(response).isNotFound();
        invalidConfig = "<distributed-cache>\n   <encoding>\n      <key media-type=\"application/x-protostream\"/>\n      <value media-type=\"application/x-protostrea\"/>\n   </encoding>\n</distributed-cache>";
        response = this.client.cache("CACHE").createWithConfiguration(RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)invalidConfig), new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isBadRequest().hasReturnedText("ISPN000492: Cannot find transcoder between 'application/x-java-object' to 'application/x-protostrea'");
        response = this.client.cache("CACHE").delete();
        ResponseAssertion.assertThat(response).isOk();
    }

    private RestCacheClient createCache(ConfigurationBuilder builder, String name) {
        return this.createCache(CacheResourceV2Test.cacheConfigToJson(name, builder.build()), name);
    }

    private RestCacheClient createCache(RestClient c, String json, String name) {
        RestEntity jsonEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json);
        RestCacheClient cache = c.cache(name);
        CompletionStage response = cache.createWithConfiguration(jsonEntity, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        return cache;
    }

    private RestCacheClient createCache(String json, String name) {
        return this.createCache(this.client, json, name);
    }

    private Json getCacheDetail(String name) {
        RestResponse response = this.join(this.client.cache(name).details());
        ResponseAssertion.assertThat(response).isOk();
        return Json.read((String)response.body());
    }

    @Test
    public void testCacheNames() {
        CompletionStage response = this.adminClient.caches();
        ResponseAssertion.assertThat(response).isOk();
        List responseCacheNames = Json.read((String)this.join(response).body()).asList();
        Assertions.assertThat((List)responseCacheNames).containsExactlyElementsOf((Iterable)((EmbeddedCacheManager)this.cacheManagers.get(0)).getCacheNames());
        ResponseAssertion.assertThat(this.client.caches()).isOk();
    }

    @Test
    public void testCacheHealth() {
        String cacheName = "default";
        CompletionStage response = this.client.cache(cacheName).health();
        ResponseAssertion.assertThat(response).isOk().hasReturnedText("HEALTHY");
        Cache cache = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache(cacheName);
        ComponentRegistry cr = TestingUtil.extractComponentRegistry((Cache)cache);
        PartitionHandlingManager phm = (PartitionHandlingManager)cr.getComponent(PartitionHandlingManager.class);
        PartitionHandlingManager spyPhm = (PartitionHandlingManager)Mockito.spy((Object)phm);
        Mockito.when((Object)spyPhm.getAvailabilityMode()).thenReturn((Object)AvailabilityMode.DEGRADED_MODE);
        TestingUtil.replaceComponent((Cache)cache, PartitionHandlingManager.class, (Object)spyPhm, (boolean)true);
        response = this.client.cache(cacheName).health();
        ResponseAssertion.assertThat(response).isOk().hasReturnedText("DEGRADED");
        response = this.client.cache("UnknownCache").health();
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void testFlags() {
        RestResponse response = this.insertEntity(1, 1000, new String[0]);
        ResponseAssertion.assertThat(response).isOk();
        this.assertIndexed(1000);
        response = this.insertEntity(2, 1200, Flag.SKIP_INDEXING.toString(), Flag.SKIP_CACHE_LOAD.toString());
        ResponseAssertion.assertThat(response).isOk();
        this.assertNotIndexed(1200);
        response = this.insertEntity(3, 1200, "Invalid");
        ResponseAssertion.assertThat(response).isBadRequest().containsReturnedText("No enum constant org.infinispan.context.Flag.Invalid");
    }

    @Test
    public void testValidateCacheQueryable() {
        this.registerSchema("simple.proto", "message Simple { required int32 value=1;}");
        this.correctReportNotQueryableCache("jsonCache", new ConfigurationBuilder().encoding().mediaType("application/json").build());
    }

    private void correctReportNotQueryableCache(String name, Configuration configuration) {
        this.createAndWriteToCache(name, configuration);
        RestResponse response = this.queryCache(name);
        ResponseAssertion.assertThat(response).isBadRequest();
        Json json = Json.read((String)response.body());
        AssertJUnit.assertTrue((boolean)json.at("error").at("cause").toString().matches(".*ISPN028015.*"));
    }

    private RestResponse queryCache(String name) {
        return this.join(this.client.cache(name).query("FROM Simple"));
    }

    private void createAndWriteToCache(String name, Configuration configuration) {
        String jsonConfig = CacheResourceV2Test.cacheConfigToJson(name, configuration);
        RestEntity configEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)jsonConfig);
        CompletionStage response = this.client.cache(name).createWithConfiguration(configEntity, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        RestEntity valueEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)"{\"_type\":\"Simple\",\"value\":1}");
        response = this.client.cache(name).post("1", valueEntity);
        ResponseAssertion.assertThat(response).isOk();
    }

    @Test
    public void testKeyStreamWithFailure() {
        String exceptionMessage = "Expected failure";
        Cache c = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache("default");
        ComponentRegistry ccr = TestingUtil.extractComponentRegistry((Cache)c);
        ClusterPublisherManager cpm = (ClusterPublisherManager)ccr.getClusterPublisherManager().running();
        ClusterPublisherManager spyCpm = (ClusterPublisherManager)Mockito.spy((Object)cpm);
        ((ClusterPublisherManager)Mockito.doAnswer(ivk -> {
            SegmentPublisherSupplier sps = (SegmentPublisherSupplier)ivk.callRealMethod();
            SegmentPublisherSupplier spySps = (SegmentPublisherSupplier)Mockito.spy((Object)sps);
            ((SegmentPublisherSupplier)Mockito.doAnswer(ignore -> Flowable.error((Throwable)new RuntimeException(exceptionMessage))).when((Object)spySps)).publisherWithoutSegments();
            return spySps;
        }).when((Object)spyCpm)).keyPublisher((IntSet)Mockito.any(), (Set)Mockito.any(), (InvocationContext)Mockito.any(), Mockito.eq((long)0L), (DeliveryGuarantee)Mockito.eq((Object)DeliveryGuarantee.EXACTLY_ONCE), Mockito.eq((int)1000), (Function)Mockito.any());
        TestingUtil.replaceComponent((Cache)c, ClusterPublisherManager.class, (Object)spyCpm, (boolean)true);
        if (this.protocol == Protocol.HTTP_11) {
            Exceptions.expectCompletionException(IOException.class, (String)"HTTP/1.1 header parser received no bytes", (CompletionStage)this.client.cache("default").keys());
        } else {
            try (RestResponse res = this.join(this.client.cache("default").keys());){
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RestResponse)res).body()).rootCause().isInstanceOf(IOException.class)).hasMessage("Received RST_STREAM: Stream cancelled");
            }
        }
        TestingUtil.replaceComponent((Cache)c, ClusterPublisherManager.class, (Object)cpm, (boolean)true);
    }

    @Test
    public void testEntryStreamWithFailure() {
        String exceptionMessage = "Expected failure";
        Cache c = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache("default");
        ComponentRegistry ccr = TestingUtil.extractComponentRegistry((Cache)c);
        ClusterPublisherManager cpm = (ClusterPublisherManager)ccr.getClusterPublisherManager().running();
        ClusterPublisherManager spyCpm = (ClusterPublisherManager)Mockito.spy((Object)cpm);
        ((ClusterPublisherManager)Mockito.doAnswer(ivk -> {
            SegmentPublisherSupplier sps = (SegmentPublisherSupplier)ivk.callRealMethod();
            SegmentPublisherSupplier spySps = (SegmentPublisherSupplier)Mockito.spy((Object)sps);
            ((SegmentPublisherSupplier)Mockito.doAnswer(ignore -> Flowable.error((Throwable)new RuntimeException(exceptionMessage))).when((Object)spySps)).publisherWithoutSegments();
            return spySps;
        }).when((Object)spyCpm)).entryPublisher((IntSet)Mockito.any(), (Set)Mockito.any(), (InvocationContext)Mockito.any(), Mockito.eq((long)0L), (DeliveryGuarantee)Mockito.eq((Object)DeliveryGuarantee.EXACTLY_ONCE), Mockito.eq((int)1000), (Function)Mockito.any());
        TestingUtil.replaceComponent((Cache)c, ClusterPublisherManager.class, (Object)spyCpm, (boolean)true);
        if (this.protocol == Protocol.HTTP_11) {
            Exceptions.expectCompletionException(IOException.class, (String)"HTTP/1.1 header parser received no bytes", (CompletionStage)this.client.cache("default").entries());
        } else {
            try (RestResponse res = this.join(this.client.cache("default").entries());){
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RestResponse)res).body()).rootCause().isInstanceOf(IOException.class)).hasMessage("Received RST_STREAM: Stream cancelled");
            }
        }
        TestingUtil.replaceComponent((Cache)c, ClusterPublisherManager.class, (Object)cpm, (boolean)true);
    }

    @Test
    public void testMultiByte() {
        this.putTextEntryInCache("default", "Jos\u00e9", "Uberl\u00e2ndia");
        RestResponse response = this.join(this.client.cache("default").keys());
        String body = response.body();
        List singleSet = Json.read((String)body).asJsonList();
        AssertJUnit.assertEquals((int)1, (int)singleSet.size());
        AssertJUnit.assertTrue((boolean)singleSet.contains(Json.factory().string("Jos\u00e9")));
        response = this.join(this.client.cache("default").entries());
        body = response.body();
        singleSet = Json.read((String)body).asJsonList();
        AssertJUnit.assertEquals((int)1, (int)singleSet.size());
        Json entity = (Json)singleSet.stream().findFirst().orElseThrow();
        AssertJUnit.assertTrue((boolean)entity.has("key"));
        AssertJUnit.assertTrue((boolean)entity.has("value"));
        AssertJUnit.assertEquals((String)entity.at("key").asString(), (String)"Jos\u00e9");
        AssertJUnit.assertEquals((String)entity.at("value").asString(), (String)"Uberl\u00e2ndia");
    }

    @Test
    public void testGetAllKeys() {
        RestResponse response = this.join(this.client.cache("default").keys());
        List emptyKeys = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)0, (int)emptyKeys.size());
        this.putTextEntryInCache("default", "1", "value");
        response = this.join(this.client.cache("default").keys());
        List singleSet = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)1, (int)singleSet.size());
        int entries = 10;
        for (int i = 0; i < entries; ++i) {
            this.putTextEntryInCache("default", String.valueOf(i), "value");
        }
        response = this.join(this.client.cache("default").keys());
        Set keys = Json.read((String)response.body()).asJsonList().stream().map(Json::asInteger).collect(Collectors.toSet());
        AssertJUnit.assertEquals((int)entries, (int)keys.size());
        AssertJUnit.assertTrue((boolean)IntStream.range(0, entries).allMatch(keys::contains));
        response = this.join(this.client.cache("default").keys(5));
        Set keysLimited = Json.read((String)response.body()).asJsonList().stream().map(Json::asInteger).collect(Collectors.toSet());
        AssertJUnit.assertEquals((int)5, (int)keysLimited.size());
    }

    @Test
    public void testGetAllKeysWithDifferentType() {
        String cacheJson = "{    \"distributed-cache\": { \"mode\": \"SYNC\", \"encoding\": { \"key\": {\"media-type\": \"application/json\"}, \"value\": {\"media-type\": \"application/xml\"}}}}";
        String value = "<?xml version=\"1.0\"?>\n<log category=\"CLUSTER\">\n    <content level=\"INFO\" message=\"hello\" detail=\"testing\"/>\n    <meta instant=\"42\" context=\"testing\" scope=\"\" who=\"\"/>\n</log>\n";
        String cacheName = "xmlCaching";
        RestCacheClient cacheClient = this.client.cache(cacheName);
        RestEntity jsonEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheJson);
        CompletionStage r = cacheClient.createWithConfiguration(jsonEntity, new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE});
        ResponseAssertion.assertThat(r).isOk();
        RestResponse response = this.join(this.client.cache(cacheName).keys());
        List emptyKeys = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)0, (int)emptyKeys.size());
        this.putInCache(cacheName, "{\"text\": \"I'm right \\\\\"here\\\\\".\"}", "application/json", value, MediaType.APPLICATION_XML);
        response = this.join(this.client.cache(cacheName).keys());
        List singleSet = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)1, (int)singleSet.size());
        this.join(this.client.cache(cacheName).clear());
        int entries = 10;
        for (int i = 0; i < entries; ++i) {
            this.putInCache(cacheName, String.format("{\"v\": %d}", i), "application/json", value, MediaType.APPLICATION_XML);
        }
        response = this.join(this.client.cache(cacheName).keys());
        List keys = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)entries, (int)keys.size());
        response = this.join(this.client.cache(cacheName).keys(5));
        List keysLimited = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)5, (int)keysLimited.size());
    }

    private void putInCache(String cacheName, String key, String keyType, String value, MediaType valueType) {
        CompletionStage r = this.client.cache(cacheName).put(key, keyType, RestEntity.create((MediaType)valueType, (String)value));
        ResponseAssertion.assertThat(r).isOk();
    }

    @Test
    public void testStreamEntries() {
        RestResponse response = this.join(this.client.cache("default").entries());
        List emptyEntries = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)0, (int)emptyEntries.size());
        this.putTextEntryInCache("default", "key_0", "value_0");
        response = this.join(this.client.cache("default").entries());
        List singleSet = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)1, (int)singleSet.size());
        for (int i = 0; i < 20; ++i) {
            this.putTextEntryInCache("default", "key_" + i, "value_" + i);
        }
        response = this.join(this.client.cache("default").entries());
        List jsons = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)20, (int)jsons.size());
        response = this.join(this.client.cache("default").entries(3));
        jsons = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)3, (int)jsons.size());
        Json first = (Json)jsons.get(0);
        String entry = first.toPrettyString();
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"key\" : \"key_"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"value\" : \"value_"});
        Assertions.assertThat((String)entry).doesNotContain(new CharSequence[]{"timeToLiveSeconds"});
        Assertions.assertThat((String)entry).doesNotContain(new CharSequence[]{"maxIdleTimeSeconds"});
        Assertions.assertThat((String)entry).doesNotContain(new CharSequence[]{"created"});
        Assertions.assertThat((String)entry).doesNotContain(new CharSequence[]{"lastUsed"});
        Assertions.assertThat((String)entry).doesNotContain(new CharSequence[]{"expireTime"});
    }

    @Test
    public void testStreamComplexProtobufEntries() {
        RestResponse response = this.join(this.client.cache("indexedCache").entries(-1, false));
        List emptyEntries = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)0, (int)emptyEntries.size());
        this.insertEntity(3, "Another", 3, "Three");
        response = this.join(this.client.cache("indexedCache").entries(-1, true));
        if (response.status() != 200) {
            Assertions.fail((String)response.body());
        }
        List jsons = Json.read((String)response.body()).asJsonList();
        Assertions.assertThat((List)jsons).hasSize(1);
        response = this.join(this.client.cache("indexedCache").keys());
        if (response.status() != 200) {
            Assertions.fail((String)response.body());
        }
        jsons = Json.read((String)response.body()).asJsonList();
        Assertions.assertThat((List)jsons).hasSize(1);
        Assertions.assertThat((List)jsons).contains((Object[])new Json[]{Json.factory().string("3")});
    }

    private String asString(Json json) {
        return json.isObject() ? json.toString() : json.asString();
    }

    private void testStreamEntriesFromCache(String cacheName, MediaType cacheMediaType, MediaType writeMediaType, Map<String, String> data) {
        this.createCache(cacheName, cacheMediaType);
        data.forEach((key, value) -> this.writeEntry((String)key, (String)value, cacheName, writeMediaType));
        RestCacheClient cacheClient = this.client.cache(cacheName);
        RestResponse response = this.join(cacheClient.entries(true));
        Map<String, String> entries = this.entriesAsMap(response);
        String contentTypeHeader = response.header(ResponseHeader.VALUE_CONTENT_TYPE_HEADER.getValue());
        AssertJUnit.assertEquals((int)data.size(), (int)entries.size());
        entries.forEach((key, value) -> AssertJUnit.assertEquals((String)value, (String)((String)data.get(key))));
        String aKey = data.keySet().iterator().next();
        String aValue = data.get(aKey);
        String changedValue = aValue.replace("value", "value-changed");
        this.writeEntry(aKey, changedValue, cacheName, MediaType.fromString((String)contentTypeHeader));
        entries = this.entriesAsMap(this.join(cacheClient.entries(true)));
        AssertJUnit.assertEquals((String)changedValue, (String)entries.get(aKey));
    }

    public void testStreamFromXMLCache() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("<id>1</id>", "<value>value1</value>");
        data.put("<id>2</id>", "<value>value2</value>");
        this.testStreamEntriesFromCache("xml", MediaType.APPLICATION_XML, MediaType.APPLICATION_XML, data);
    }

    public void testStreamFromTextPlainCache() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key-1", "value-1");
        data.put("key-2", "value-2");
        this.testStreamEntriesFromCache("text", MediaType.TEXT_PLAIN, MediaType.TEXT_PLAIN, data);
    }

    public void testStreamFromJSONCache() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("1", "{\"value\":1}");
        data.put("2", "{\"value\":2}");
        this.testStreamEntriesFromCache("json", MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON, data);
    }

    public void testStreamFromDefaultCache() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("0x01", "0x010203");
        data.put("0x02", "0x020406");
        this.testStreamEntriesFromCache("noEncoding", null, MediaType.APPLICATION_OCTET_STREAM.withEncoding("hex"), data);
    }

    private void createCache(String cacheName, MediaType mediaType) {
        RestCacheClient cacheClient = this.client.cache(cacheName);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        if (mediaType != null) {
            builder.encoding().mediaType(mediaType.toString());
        }
        String jsonConfig = CacheResourceV2Test.cacheConfigToJson(cacheName, builder.build());
        RestEntity cacheConfig = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)jsonConfig);
        RestResponse response = this.join(cacheClient.createWithConfiguration(cacheConfig, new CacheContainerAdmin.AdminFlag[0]));
        ResponseAssertion.assertThat(response).isOk();
    }

    private void writeEntry(String key, String value, String cacheName, MediaType mediaType) {
        RestCacheClient cacheClient = this.client.cache(cacheName);
        RestResponse response = mediaType == null ? this.join(cacheClient.put(key, value)) : this.join(cacheClient.put(key, mediaType.toString(), RestEntity.create((MediaType)mediaType, (String)value)));
        ResponseAssertion.assertThat(response).isOk();
    }

    private Map<String, String> entriesAsMap(RestResponse response) {
        ResponseAssertion.assertThat(response).isOk();
        List entries = Json.read((String)response.body()).asJsonList();
        return entries.stream().collect(Collectors.toMap(j -> this.asString(j.at("key")), j -> this.asString(j.at("value"))));
    }

    @Test
    public void testStreamEntriesWithMetadata() {
        RestResponse response = this.join(this.client.cache("default").entries(-1, true));
        List emptyEntries = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)0, (int)emptyEntries.size());
        this.putTextEntryInCache("default", "key_0", "value_0");
        response = this.join(this.client.cache("default").entries(-1, true));
        List singleSet = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)1, (int)singleSet.size());
        for (int i = 0; i < 20; ++i) {
            this.putTextEntryInCache("default", "key_" + i, "value_" + i);
        }
        response = this.join(this.client.cache("default").entries(-1, true));
        List jsons = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)20, (int)jsons.size());
        response = this.join(this.client.cache("default").entries(3, true));
        jsons = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)3, (int)jsons.size());
        Json first = (Json)jsons.get(0);
        String entry = first.toPrettyString();
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"key\" : \"key_"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"value\" : \"value_"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"timeToLiveSeconds\" : -1"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"maxIdleTimeSeconds\" : -1"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"created\" : -1"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"lastUsed\" : -1"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"expireTime\" : -1"});
    }

    @Test
    public void testStreamEntriesWithMetadataAndExpirationTimesConvertedToSeconds() {
        RestEntity textValue = RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (String)"value1");
        this.join(this.client.cache("default").put("key1", "text/plain", textValue, 1000L, 5000L));
        RestResponse response = this.join(this.client.cache("default").entries(1, true));
        List jsons = Json.read((String)response.body()).asJsonList();
        AssertJUnit.assertEquals((int)1, (int)jsons.size());
        Json first = (Json)jsons.get(0);
        String entry = first.toPrettyString();
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"key\" : \"key1"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"value\" : \"value1"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"timeToLiveSeconds\" : 1000"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"maxIdleTimeSeconds\" : 5000"});
    }

    @Test
    public void testProtobufMetadataManipulation() {
        String cache = "___protobuf_metadata";
        this.putStringValueInCache(cache, "file1.proto", "message A{}");
        this.putStringValueInCache(cache, "file2.proto", "message B{}");
        this.putStringValueInCache(cache, "sample.proto", PROTO_SCHEMA);
        RestResponse response = this.join(this.client.cache("___protobuf_metadata").keys());
        String contentAsString = response.body();
        List keys = Json.read((String)contentAsString).asJsonList();
        AssertJUnit.assertEquals((int)3, (int)keys.size());
    }

    @Test
    public void testVersionMetadata() {
        Metadata metadata1 = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(7L)).build();
        Metadata metadata2 = new EmbeddedMetadata.Builder().version((EntryVersion)new SimpleClusteredVersion(3, 9L)).build();
        Cache embeddedCache = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache("simple-text");
        AdvancedCache advancedCache = embeddedCache.getAdvancedCache();
        advancedCache.put((Object)"key-1", (Object)"value-1", metadata1);
        advancedCache.put((Object)"key-2", (Object)"value-2", metadata2);
        advancedCache.put((Object)"key-3", (Object)"value-3");
        RestCacheClient cacheClient = this.client.cache("simple-text");
        RestResponse response = this.join(cacheClient.entries(100, true));
        ResponseAssertion.assertThat(response).isOk();
        String body = response.body();
        Assert.assertTrue((boolean)body.contains("key-1"));
        Assert.assertTrue((boolean)body.contains("key-2"));
        Assert.assertTrue((boolean)body.contains("key-3"));
        List returnedEntries = Json.read((String)body).asJsonList();
        Assert.assertEquals((int)3, (int)returnedEntries.size());
        block10: for (int i = 0; i < 3; ++i) {
            Json entry = (Json)returnedEntries.get(0);
            String key = entry.at("key").asString();
            Json version = entry.at("version");
            Json topologyId = entry.at("topologyId");
            switch (key) {
                case "key-1": {
                    Assert.assertEquals((long)7L, (long)version.asLong());
                    Assert.assertNull((Object)topologyId);
                    continue block10;
                }
                case "key-2": {
                    Assert.assertEquals((long)3L, (long)version.asLong());
                    Assert.assertEquals((int)7, (int)topologyId.asInteger());
                    continue block10;
                }
                case "key-3": {
                    Assert.assertNull((Object)version);
                    Assert.assertNull((Object)topologyId);
                    continue block10;
                }
                default: {
                    Assert.fail((String)("unexpected key: " + key));
                }
            }
        }
    }

    @Test
    public void testRebalancingActions() {
        String cacheName = "default";
        this.assertRebalancingStatus(cacheName, true);
        RestCacheClient cacheClient = this.adminClient.cache(cacheName);
        RestResponse response = this.join(cacheClient.disableRebalancing());
        ResponseAssertion.assertThat(response).isOk();
        this.assertRebalancingStatus(cacheName, false);
        response = this.join(cacheClient.enableRebalancing());
        ResponseAssertion.assertThat(response).isOk();
        this.assertRebalancingStatus(cacheName, true);
    }

    private void assertRebalancingStatus(String cacheName, boolean enabled) {
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            this.eventuallyEquals(enabled, () -> {
                try {
                    return ((LocalTopologyManager)TestingUtil.extractGlobalComponent((CacheContainer)cm, LocalTopologyManager.class)).isCacheRebalancingEnabled(cacheName);
                }
                catch (Exception e) {
                    Assert.fail((String)"Unexpected exception", (Throwable)e);
                    return !enabled;
                }
            });
        }
    }

    private String getCacheConfig(String accept, String name) {
        RestResponse response = this.join(this.adminClient.cache(name).configuration(accept));
        ResponseAssertion.assertThat(response).isOk();
        return response.body();
    }

    @Test
    public void testConversionFromXML() {
        this.testConversionFromXML0("distributed-cache");
        this.testConversionFromXML0("distributed-cache-configuration");
    }

    private void testConversionFromXML0(String root) {
        RestRawClient rawClient = this.client.raw();
        String xml = String.format("<%s name=\"cacheName\" mode=\"SYNC\" configuration=\"parent\">\n  <memory storage=\"OBJECT\" max-count=\"20\"/>\n</%s>", root, root);
        CompletionStage response = rawClient.post("/rest/v2/caches?action=convert", Map.of(ACCEPT, "application/json"), RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)xml));
        ResponseAssertion.assertThat(response).isOk();
        this.checkJSON(response, "cacheName", root);
        response = rawClient.post("/rest/v2/caches?action=convert", Collections.singletonMap(ACCEPT, "application/yaml"), RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)xml));
        ResponseAssertion.assertThat(response).isOk();
        this.checkYaml(response, "cacheName", root);
    }

    @Test
    public void testConversionFromJSON() throws Exception {
        this.testConversionFromJSON0("distributed-cache");
        this.testConversionFromJSON0("distributed-cache-configuration");
    }

    private void testConversionFromJSON0(String root) throws Exception {
        RestRawClient rawClient = this.client.raw();
        String json = String.format("{\"%s\":{\"configuration\":\"parent\",\"mode\":\"SYNC\",\"memory\":{\"storage\":\"OBJECT\",\"max-count\":\"20\"}}}", root);
        CompletionStage response = rawClient.post("/rest/v2/caches?action=convert", Collections.singletonMap(ACCEPT, "application/xml"), RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json));
        ResponseAssertion.assertThat(response).isOk();
        this.checkXML(response, root);
        response = rawClient.post("/rest/v2/caches?action=convert", Collections.singletonMap(ACCEPT, "application/yaml"), RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json));
        ResponseAssertion.assertThat(response).isOk();
        this.checkYaml(response, "", root);
    }

    @Test
    public void testConversionFromYAML() throws Exception {
        this.testConversionFromYAML0("distributedCache");
        this.testConversionFromYAML0("distributedCacheConfiguration");
    }

    private void testConversionFromYAML0(String root) throws Exception {
        RestRawClient rawClient = this.client.raw();
        String yaml = String.format("%s:\n  mode: 'SYNC'\n  configuration: 'parent'\n  memory:\n    storage: 'OBJECT'\n    maxCount: 20", root);
        CompletionStage response = rawClient.post("/rest/v2/caches?action=convert", Collections.singletonMap(ACCEPT, "application/xml"), RestEntity.create((MediaType)MediaType.APPLICATION_YAML, (String)yaml));
        ResponseAssertion.assertThat(response).isOk();
        this.checkXML(response, root);
        response = rawClient.post("/rest/v2/caches?action=convert", Collections.singletonMap(ACCEPT, "application/json"), RestEntity.create((MediaType)MediaType.APPLICATION_YAML, (String)yaml));
        ResponseAssertion.assertThat(response).isOk();
        this.checkJSON(response, "", root);
    }

    @Test
    public void testBrokenConfiguration() throws IOException {
        for (String name : Arrays.asList("broken.xml", "broken.yaml", "broken.json")) {
            CompletionStage<RestResponse> response = this.createCacheFromResource(name);
            String body = this.join(response).body();
            Assertions.assertThat((String)body).contains(new CharSequence[]{"ISPN000327: Cannot find a parser for element 'error' in namespace '' at ["});
        }
    }

    private CompletionStage<RestResponse> createCacheFromResource(String name) throws IOException {
        String cfg;
        try (InputStream is = CacheResourceV2Test.class.getResourceAsStream("/" + name);){
            cfg = Files.readFile((InputStream)is);
        }
        RestEntity entity = RestEntity.create((MediaType)MediaType.fromExtension((String)name), (String)cfg);
        RestCacheClient cache = this.client.cache(name);
        return cache.createWithConfiguration(entity, new CacheContainerAdmin.AdminFlag[0]);
    }

    private void checkJSON(CompletionStage<RestResponse> response, String name, String rootElement) {
        Json jsonNode = Json.read((String)this.join(response).body());
        if (!name.isBlank()) {
            jsonNode = jsonNode.at(name);
        }
        Json distCache = jsonNode.at(NamingStrategy.KEBAB_CASE.convert(rootElement));
        Json memory = distCache.at("memory");
        AssertJUnit.assertEquals((String)"SYNC", (String)distCache.at("mode").asString());
        AssertJUnit.assertEquals((String)"parent", (String)distCache.at("configuration").asString());
        AssertJUnit.assertEquals((int)20, (int)memory.at("max-count").asInteger());
    }

    private void checkXML(CompletionStage<RestResponse> response, String rootElement) throws Exception {
        String xml = this.join(response).body();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
        Element root = doc.getDocumentElement();
        AssertJUnit.assertEquals((String)NamingStrategy.KEBAB_CASE.convert(rootElement), (String)root.getTagName());
        AssertJUnit.assertEquals((String)"parent", (String)root.getAttribute("configuration"));
        AssertJUnit.assertEquals((String)"SYNC", (String)root.getAttribute("mode"));
        NodeList children = root.getElementsByTagName("memory");
        AssertJUnit.assertEquals((int)1, (int)children.getLength());
        Element memory = (Element)children.item(0);
        AssertJUnit.assertEquals((String)"OBJECT", (String)memory.getAttribute("storage"));
        AssertJUnit.assertEquals((String)"20", (String)memory.getAttribute("max-count"));
    }

    private void checkYaml(CompletionStage<RestResponse> response, String name, String root) {
        String rootElement = NamingStrategy.CAMEL_CASE.convert(root);
        try (YamlConfigurationReader yaml = new YamlConfigurationReader((Reader)new StringReader(this.join(response).body()), (ConfigurationResourceResolver)new URLConfigurationResourceResolver(null), new Properties(), PropertyReplacer.DEFAULT, NamingStrategy.KEBAB_CASE);){
            Map config = yaml.asMap();
            AssertJUnit.assertEquals((String)"parent", (String)((String)CacheResourceV2Test.getYamlProperty(config, name, rootElement, "configuration")));
            AssertJUnit.assertEquals((String)"SYNC", (String)((String)CacheResourceV2Test.getYamlProperty(config, name, rootElement, "mode")));
            AssertJUnit.assertEquals((String)"OBJECT", (String)((String)CacheResourceV2Test.getYamlProperty(config, name, rootElement, "memory", "storage")));
            AssertJUnit.assertEquals((String)"20", (String)((String)CacheResourceV2Test.getYamlProperty(config, name, rootElement, "memory", "maxCount")));
        }
    }

    public static <T> T getYamlProperty(Map<String, Object> yaml, String ... names) {
        for (int i = 0; i < names.length - 1; ++i) {
            if (names[i].isBlank() || (yaml = (Map)yaml.get(names[i])) != null) continue;
            return null;
        }
        return (T)yaml.get(names[names.length - 1]);
    }

    @Test
    public void testCacheExists() {
        AssertJUnit.assertEquals((int)404, (int)this.checkCache("nonexistent"));
        AssertJUnit.assertEquals((int)204, (int)this.checkCache("invalid"));
        AssertJUnit.assertEquals((int)204, (int)this.checkCache("default"));
        AssertJUnit.assertEquals((int)204, (int)this.checkCache("indexedCache"));
    }

    @Test
    public void testCRUDWithProtobufPrimitives() throws Exception {
        RestCacheClient client = this.client.cache("proto");
        MediaType integerType = MediaType.APPLICATION_OBJECT.withClassType(Integer.class);
        RestEntity value = RestEntity.create((MediaType)integerType, (String)"1");
        CompletionStage response = client.put("1", integerType.toString(), value);
        ResponseAssertion.assertThat(response).isOk();
        RestEntity anotherValue = RestEntity.create((MediaType)integerType, (String)"2");
        response = client.put("1", integerType.toString(), anotherValue);
        ResponseAssertion.assertThat(response).isOk();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(RequestHeader.KEY_CONTENT_TYPE_HEADER.getValue(), integerType.toString());
        headers.put(RequestHeader.ACCEPT_HEADER.getValue(), integerType.toString());
        response = client.get("1", headers);
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("2");
        headers = new HashMap();
        headers.put(RequestHeader.KEY_CONTENT_TYPE_HEADER.getValue(), integerType.toString());
        headers.put(RequestHeader.ACCEPT_HEADER.getValue(), "application/x-protostream");
        response = client.get("1", headers);
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedBytes(new ProtoStreamMarshaller().objectToByteBuffer((Object)2));
    }

    @Test
    public void indexMetamodel() {
        RestCacheClient cacheClient = this.adminClient.cache("indexedCache");
        this.join(cacheClient.clear());
        RestResponse response = this.join(cacheClient.indexMetamodel());
        Json indexMetamodel = Json.read((String)response.body());
        List indexes = indexMetamodel.asJsonList();
        Assertions.assertThat((List)indexes).hasSize(2);
        Json entity = (Json)indexes.get(0);
        Assertions.assertThat((String)entity.at("entity-name").asString()).isEqualTo("Entity");
        Assertions.assertThat((String)entity.at("java-class").asString()).isEqualTo("[B");
        Assertions.assertThat((String)entity.at("index-name").asString()).isEqualTo("Entity");
        Map valueFields = entity.at("value-fields").asJsonMap();
        Assertions.assertThat((Map)valueFields).containsKey((Object)"value");
        Json valueField = (Json)valueFields.get("value");
        Assertions.assertThat((boolean)valueField.at("multi-valued").asBoolean()).isFalse();
        Assertions.assertThat((boolean)valueField.at("multi-valued-in-root").asBoolean()).isFalse();
        Assertions.assertThat((String)valueField.at("type").asString()).isEqualTo(Integer.class.getName());
        Assertions.assertThat((String)valueField.at("projection-type").asString()).isEqualTo(Integer.class.getName());
        Assertions.assertThat((String)valueField.at("argument-type").asString()).isEqualTo(Integer.class.getName());
        Assertions.assertThat((boolean)valueField.at("searchable").asBoolean()).isTrue();
        Assertions.assertThat((boolean)valueField.at("sortable").asBoolean()).isFalse();
        Assertions.assertThat((boolean)valueField.at("projectable").asBoolean()).isFalse();
        Assertions.assertThat((boolean)valueField.at("aggregable").asBoolean()).isFalse();
        Assertions.assertThat((Object)valueField.at("analyzer")).isNull();
        Assertions.assertThat((Object)valueField.at("normalizer")).isNull();
        Json another = (Json)indexes.get(1);
        Assertions.assertThat((String)another.at("entity-name").asString()).isEqualTo("Another");
        Assertions.assertThat((String)another.at("java-class").asString()).isEqualTo("[B");
        Assertions.assertThat((String)another.at("index-name").asString()).isEqualTo("Another");
    }

    @Test
    public void testSearchStatistics() {
        RestCacheClient cacheClient = this.adminClient.cache("indexedCache");
        this.join(cacheClient.clear());
        RestResponse response = this.join(cacheClient.clearSearchStats());
        ResponseAssertion.assertThat(response).isOk();
        response = this.join(cacheClient.searchStats());
        Json statJson = Json.read((String)response.body());
        this.assertIndexStatsEmpty(statJson.at("index"));
        this.assertAllQueryStatsEmpty(statJson.at("query"));
        this.insertEntity(1, "Entity", 1, "One");
        this.insertEntity(11, "Entity", 11, "Eleven");
        this.insertEntity(21, "Entity", 21, "Twenty One");
        this.insertEntity(3, "Another", 3, "Three");
        this.insertEntity(33, "Another", 33, "Thirty Three");
        response = this.join(cacheClient.size());
        ResponseAssertion.assertThat(response).hasReturnedText("5");
        response = this.join(cacheClient.searchStats());
        ResponseAssertion.assertThat(response).isOk();
        statJson = Json.read((String)response.body());
        this.assertAllQueryStatsEmpty(statJson.at("query"));
        String indexedQuery = "FROM Entity WHERE value > 5";
        IntStream.range(0, 3).forEach(i -> {
            RestResponse response1 = this.join(cacheClient.query(indexedQuery));
            ResponseAssertion.assertThat(response1).isOk();
            Json queryJson = Json.read((String)response1.body());
            AssertJUnit.assertEquals((int)2, (int)queryJson.at("hit_count").asInteger());
            AssertJUnit.assertEquals((boolean)true, (boolean)queryJson.at("hit_count_exact").asBoolean());
        });
        response = this.join(cacheClient.searchStats());
        statJson = Json.read((String)response.body());
        AssertJUnit.assertEquals((long)0L, (long)statJson.at("query").at("hybrid").at("count").asLong());
        AssertJUnit.assertEquals((long)0L, (long)statJson.at("query").at("non_indexed").at("count").asLong());
        Json queryStats = statJson.at("query");
        this.assertQueryStatEmpty(queryStats.at("hybrid"));
        this.assertQueryStatEmpty(queryStats.at("non_indexed"));
        AssertJUnit.assertEquals((long)3L, (long)statJson.at("query").at("indexed_local").at("count").asLong());
        AssertJUnit.assertTrue((statJson.at("query").at("indexed_local").at("average").asLong() > 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((statJson.at("query").at("indexed_local").at("max").asLong() > 0L ? 1 : 0) != 0);
        AssertJUnit.assertEquals((long)3L, (long)statJson.at("query").at("indexed_distributed").at("count").asLong());
        AssertJUnit.assertTrue((statJson.at("query").at("indexed_distributed").at("average").asLong() > 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((statJson.at("query").at("indexed_distributed").at("max").asLong() > 0L ? 1 : 0) != 0);
        String hybrid = "FROM Entity WHERE value > 5 AND description = 'One'";
        response = this.join(cacheClient.query(hybrid));
        Json queryJson = Json.read((String)response.body());
        AssertJUnit.assertEquals((int)0, (int)queryJson.at("hit_count").asInteger());
        AssertJUnit.assertEquals((boolean)true, (boolean)queryJson.at("hit_count_exact").asBoolean());
        response = this.join(cacheClient.searchStats());
        statJson = Json.read((String)response.body());
        AssertJUnit.assertEquals((long)1L, (long)statJson.at("query").at("hybrid").at("count").asLong());
        AssertJUnit.assertTrue((statJson.at("query").at("hybrid").at("average").asLong() > 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((statJson.at("query").at("hybrid").at("max").asLong() > 0L ? 1 : 0) != 0);
        response = this.join(cacheClient.searchStats());
        statJson = Json.read((String)response.body());
        AssertJUnit.assertEquals((int)3, (int)statJson.at("index").at("types").at("Entity").at("count").asInteger());
        AssertJUnit.assertEquals((int)2, (int)statJson.at("index").at("types").at("Another").at("count").asInteger());
        Assertions.assertThat((long)statJson.at("index").at("types").at("Entity").at("size").asLong()).isGreaterThan(1000L);
        Assertions.assertThat((long)statJson.at("index").at("types").at("Another").at("size").asLong()).isGreaterThan(1000L);
        AssertJUnit.assertFalse((boolean)statJson.at("index").at("reindexing").asBoolean());
    }

    @Test
    public void testIndexDataSyncInvalidSchema() {
        String notQuiteIndexed = "package schemas;\n /* @Indexed */\n message Entity {\n    optional string name=1;\n }";
        RestResponse restResponse = this.join(this.client.schemas().put("schemas.proto", notQuiteIndexed));
        ResponseAssertion.assertThat(restResponse).isOk();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntities(new String[]{"schemas.Entity"});
        String cacheConfig = CacheResourceV2Test.cacheConfigToJson("sync-data-index", builder.build());
        RestCacheClient cacheClient = this.client.cache("sync-data-index");
        RestEntity config = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheConfig);
        CompletionStage response = cacheClient.createWithConfiguration(config, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        String value = Json.object().set("_type", (Object)"schemas.Entity").set("name", (Object)"Jun").toString();
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)value);
        restResponse = this.join(cacheClient.put("key", restEntity));
        ResponseAssertion.assertThat(restResponse).containsReturnedText("make sure at least one field has some indexing annotation");
        response = cacheClient.size();
        ResponseAssertion.assertThat(response).containsReturnedText("0");
    }

    @Test
    public void testLazySearchMapping() {
        String proto = " package future;\n /* @Indexed */\n message Entity {\n    /* @Basic */\n    optional string name=1;\n }";
        String value = Json.object().set("_type", (Object)"future.Entity").set("name", (Object)"Kim").toString();
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)value);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntities(new String[]{"future.Entity"});
        String cacheConfig = CacheResourceV2Test.cacheConfigToJson("index-lazy", builder.build());
        RestCacheClient cacheClient = this.client.cache("index-lazy");
        RestEntity config = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheConfig);
        CompletionStage response = cacheClient.createWithConfiguration(config, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        RestResponse restResponse = this.join(cacheClient.query("From future.Entity"));
        ResponseAssertion.assertThat(restResponse).containsReturnedText("Unknown type name : future.Entity");
        restResponse = this.join(cacheClient.put("key", restEntity));
        ResponseAssertion.assertThat(restResponse).containsReturnedText("Unknown type name : future.Entity");
        restResponse = this.join(this.client.schemas().put("future.proto", proto));
        ResponseAssertion.assertThat(restResponse).isOk();
        restResponse = this.join(cacheClient.put("key", restEntity));
        ResponseAssertion.assertThat(restResponse).isOk();
        restResponse = this.join(cacheClient.query("From future.Entity"));
        ResponseAssertion.assertThat(restResponse).isOk();
        ResponseAssertion.assertThat(restResponse).containsReturnedText("Kim");
    }

    @Test
    public void testCacheListener() throws InterruptedException, IOException {
        SSEListener sseListener = new SSEListener();
        Closeable listen = this.client.raw().listen("/rest/v2/caches/default?action=listen", Collections.singletonMap(ACCEPT, "text/plain"), (RestEventListener)sseListener);
        AssertJUnit.assertTrue((boolean)sseListener.await(10L, TimeUnit.SECONDS));
        this.putTextEntryInCache("default", "AKey", "AValue");
        sseListener.expectEvent("cache-entry-created", "AKey");
        this.removeTextEntryFromCache("default", "AKey");
        sseListener.expectEvent("cache-entry-removed", "AKey");
        listen.close();
    }

    @Test
    public void testConnectStoreValidation() {
        RestCacheClient cacheClient = this.client.cache("default");
        this.assertBadResponse(cacheClient, "true");
        this.assertBadResponse(cacheClient, "2");
        this.assertBadResponse(cacheClient, "[1,2,3]");
        this.assertBadResponse(cacheClient, "\"random text\"");
        this.assertBadResponse(cacheClient, "{\"jdbc-store\":{\"shared\":true}}");
        this.assertBadResponse(cacheClient, "{\"jdbc-store\":{\"shared\":true},\"remote-store\":{\"shared\":true}}");
    }

    @Test
    public void testSourceConnected() {
        RestCacheClient cacheClient = this.client.cache("default");
        RestResponse restResponse = this.join(cacheClient.sourceConnected());
        ResponseAssertion.assertThat(restResponse).isNotFound();
    }

    @Test
    public void testCacheAvailability() {
        RestCacheClient cacheClient = this.adminClient.cache("denyReadWritesCache");
        RestResponse restResponse = this.join(cacheClient.getAvailability());
        ResponseAssertion.assertThat(restResponse).isOk().containsReturnedText("AVAILABLE");
        restResponse = this.join(cacheClient.setAvailability("DEGRADED_MODE"));
        ResponseAssertion.assertThat(restResponse).isOk();
        CacheResourceV2Test.eventuallyEquals((String)"Availability status not updated!", (Object)"DEGRADED_MODE", () -> {
            RestResponse r = this.join(cacheClient.getAvailability());
            ResponseAssertion.assertThat(r).isOk();
            return r.body();
        });
        RestCacheClient adminCacheClient = this.adminClient.cache("org.infinispan.CONFIG");
        restResponse = this.join(adminCacheClient.getAvailability());
        ResponseAssertion.assertThat(restResponse).isOk().containsReturnedText("AVAILABLE");
        restResponse = this.join(adminCacheClient.setAvailability("DEGRADED_MODE"));
        ResponseAssertion.assertThat(restResponse).isOk();
        restResponse = this.join(adminCacheClient.getAvailability());
        ResponseAssertion.assertThat(restResponse).isOk().containsReturnedText("AVAILABLE");
    }

    @Test
    public void testComparison() {
        RestRawClient rawClient = this.client.raw();
        String xml = "<distributed-cache name=\"cacheName\" mode=\"SYNC\">\n<memory storage=\"OBJECT\" max-count=\"20\"/>\n</distributed-cache>";
        String json20 = "{\"distributed-cache\":{\"memory\":{\"storage\":\"OBJECT\",\"max-count\":\"20\"}}}";
        String json30 = "{\"distributed-cache\":{\"memory\":{\"storage\":\"OBJECT\",\"max-count\":\"30\"}}}";
        String jsonrepl = "{\"replicated-cache\":{\"memory\":{\"storage\":\"OBJECT\",\"max-count\":\"30\"}}}";
        MultiPartRestEntity multiPart = RestEntity.multiPart();
        multiPart.addPart("one", xml);
        multiPart.addPart("two", json20);
        CompletionStage response = rawClient.post("/rest/v2/caches?action=compare", (RestEntity)multiPart);
        ResponseAssertion.assertThat(response).isOk();
        multiPart = RestEntity.multiPart();
        multiPart.addPart("one", xml);
        multiPart.addPart("two", json30);
        response = rawClient.post("/rest/v2/caches?action=compare", (RestEntity)multiPart);
        ResponseAssertion.assertThat(response).isConflicted();
        response = rawClient.post("/rest/v2/caches?action=compare&ignoreMutable=true", (RestEntity)multiPart);
        ResponseAssertion.assertThat(response).isOk();
        multiPart = RestEntity.multiPart();
        multiPart.addPart("one", xml);
        multiPart.addPart("two", jsonrepl);
        response = rawClient.post("/rest/v2/caches?action=compare&ignoreMutable=true", Collections.emptyMap(), (RestEntity)multiPart);
        ResponseAssertion.assertThat(response).isConflicted();
        multiPart = RestEntity.multiPart();
        multiPart.addPart("one", "{\"local-cache\":{\"statistics\":true,\"encoding\":{\"key\": {\"media-type\":\"text/plain\"} ,\"value\":{\"media-type\":\"text/plain\"}},\"memory\":{\"max-count\":\"50\"}}}");
        multiPart.addPart("two", "{\"local-cache\":{\"statistics\":true,\"encoding\":{\"key\":{\"media-type\":\"application/x-protostream\"},\"value\":{\"media-type\":\"application/x-protostream\"}},\"memory\":{\"max-count\":\"50\"}}}");
        response = rawClient.post("/rest/v2/caches?action=compare&ignoreMutable=true", Collections.emptyMap(), (RestEntity)multiPart);
        ResponseAssertion.assertThat(response).isConflicted();
        AssertJUnit.assertEquals((String)"ISPN000963: Invalid configuration in 'local-cache'\n    ISPN000961: Incompatible attribute 'local-cache.encoding.key.media-type' existing value='text/plain', new value='application/x-protostream'\n    ISPN000961: Incompatible attribute 'local-cache.encoding.value.media-type' existing value='text/plain', new value='application/x-protostream'", (String)this.join(response).body());
    }

    @Test
    public void testAccessibleCaches() {
        if (this.security) {
            RestResponse response = this.join(this.adminClient.cachesByRole("ADMIN"));
            ResponseAssertion.assertThat(response).isOk();
            String json = response.body();
            Json jsonNode = Json.read((String)json);
            Assertions.assertThat((List)jsonNode.at("secured").asList()).containsExactlyInAnyOrder(new Object[]{"secured-simple-text"});
            Assertions.assertThat((List)jsonNode.at("non-secured").asList()).containsExactlyInAnyOrder(new Object[]{"default", "simple-text", "indexedCache", "proto", "denyReadWritesCache", "defaultcache"});
            response = this.join(this.adminClient.cachesByRole("USER"));
            json = response.body();
            jsonNode = Json.read((String)json);
            Assertions.assertThat((List)jsonNode.at("secured").asList()).isEmpty();
            Assertions.assertThat((List)jsonNode.at("non-secured").asList()).containsExactlyInAnyOrder(new Object[]{"default", "simple-text", "indexedCache", "proto", "denyReadWritesCache", "defaultcache"});
            ResponseAssertion.assertThat(this.join(this.client.cachesByRole("ADMIN"))).isForbidden();
        } else {
            ResponseAssertion.assertThat(this.join(this.adminClient.cachesByRole("ADMIN"))).isNotFound();
            ResponseAssertion.assertThat(this.join(this.client.cachesByRole("ADMIN"))).isNotFound();
        }
    }

    private void assertBadResponse(RestCacheClient client, String config) {
        RestResponse response = this.join(client.connectSource(RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)config)));
        ResponseAssertion.assertThat(response).isBadRequest();
        ResponseAssertion.assertThat(response).containsReturnedText("Invalid remote-store JSON description");
    }

    private void assertQueryStatEmpty(Json queryTypeStats) {
        AssertJUnit.assertEquals((int)0, (int)queryTypeStats.at("count").asInteger());
        AssertJUnit.assertEquals((int)0, (int)queryTypeStats.at("max").asInteger());
        AssertJUnit.assertEquals((Object)0.0, (Object)queryTypeStats.at("average").asDouble());
        Assert.assertNull((Object)queryTypeStats.at("slowest"));
    }

    private void assertAllQueryStatsEmpty(Json queryStats) {
        queryStats.asJsonMap().forEach((name, s) -> this.assertQueryStatEmpty((Json)s));
    }

    private void assertIndexStatsEmpty(Json indexStats) {
        indexStats.at("types").asJsonMap().forEach((name, json) -> {
            AssertJUnit.assertEquals((int)0, (int)json.at("count").asInteger());
            Assertions.assertThat((long)json.at("size").asLong()).isGreaterThanOrEqualTo(0L);
        });
    }

    private int checkCache(String name) {
        CompletionStage response = this.client.cache(name).exists();
        return this.join(response).status();
    }

    private void registerSchema(String name, String schema) {
        CompletionStage response = this.client.schemas().put(name, schema);
        ResponseAssertion.assertThat(response).isOk().hasNoErrors();
    }

    private RestResponse insertEntity(int key, int value, String ... flags) {
        String json = String.format("{\"_type\": \"Entity\",\"value\": %d}", value);
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json);
        RestCacheClient cacheClient = this.client.cache("indexedCache");
        return this.join(cacheClient.put(String.valueOf(key), restEntity, flags));
    }

    private void insertEntity(int cacheKey, String type, int intValue, String stringValue) {
        Json json = Json.object().set("_type", (Object)type).set("value", (Object)intValue).set("description", (Object)stringValue);
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json.toString());
        RestCacheClient cacheClient = this.client.cache("indexedCache");
        CompletionStage response = cacheClient.put(String.valueOf(cacheKey), restEntity);
        ResponseAssertion.assertThat(response).isOk();
    }

    private void assertIndexed(int value) {
        this.assertIndex(value, true);
    }

    private void assertNotIndexed(int value) {
        this.assertIndex(value, false);
    }

    private void assertIndex(int value, boolean present) {
        String query = "FROM Entity WHERE value = " + value;
        RestResponse response = this.join(this.client.cache("indexedCache").query(query));
        ResponseAssertion.assertThat(response).isOk();
        AssertJUnit.assertEquals((boolean)present, (boolean)response.body().contains(String.valueOf(value)));
    }
}

