/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.ClusterResourceTest")
public class ClusterResourceTest
extends AbstractRestResourceTest {
    public Object[] factory() {
        return new Object[]{new ClusterResourceTest().withSecurity(false).protocol(Protocol.HTTP_11).ssl(false).browser(false), new ClusterResourceTest().withSecurity(false).protocol(Protocol.HTTP_11).ssl(false).browser(true), new ClusterResourceTest().withSecurity(true).protocol(Protocol.HTTP_20).ssl(false).browser(false), new ClusterResourceTest().withSecurity(true).protocol(Protocol.HTTP_20).ssl(false).browser(true), new ClusterResourceTest().withSecurity(true).protocol(Protocol.HTTP_11).ssl(true).browser(false), new ClusterResourceTest().withSecurity(true).protocol(Protocol.HTTP_11).ssl(true).browser(true), new ClusterResourceTest().withSecurity(true).protocol(Protocol.HTTP_20).ssl(true).browser(false), new ClusterResourceTest().withSecurity(true).protocol(Protocol.HTTP_20).ssl(true).browser(true)};
    }

    @Test
    public void testClusterDistribution() {
        CompletionStage response = this.adminClient.cluster().distribution();
        ResponseAssertion.assertThat(response).isOk();
        Json json = Json.read((String)this.join(response).body());
        AssertJUnit.assertTrue((boolean)json.isArray());
        List list = json.asJsonList();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        Pattern pattern = Pattern.compile(((Object)((Object)this)).getClass().getSimpleName() + "-Node[a-zA-Z]$");
        for (Json node : list) {
            AssertJUnit.assertTrue((node.at("memory_available").asLong() > 0L ? 1 : 0) != 0);
            AssertJUnit.assertTrue((node.at("memory_used").asLong() > 0L ? 1 : 0) != 0);
            AssertJUnit.assertEquals((int)node.at("node_addresses").asJsonList().size(), (int)1);
            AssertJUnit.assertTrue((boolean)pattern.matcher(node.at("node_name").asString()).matches());
        }
    }
}

