/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.infinispan.client.rest.RestContainerClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestEventListener;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.io.StringBuilderWriter;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.health.HealthStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.rest.resources.SSEListener;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.KeyValuePair;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.ContainerResourceTest")
public class ContainerResourceTest
extends AbstractRestResourceTest {
    private static final String PERSISTENT_LOCATION = CommonsTestingUtil.tmpDirectory((String[])new String[]{ContainerResourceTest.class.getName()});
    private static final String CACHE_1 = "cache1";
    private static final String CACHE_2 = "cache2";
    private static final String CACHE_3 = "cache3";
    private static final String DEFAULT_CACHE = "defaultcache";
    private static final String INVALID_CACHE = "invalid";
    public static final String TEMPLATE_CONFIG = "template";
    private Configuration cache2Config;
    private Configuration templateConfig;
    private RestContainerClient restContainerClient;
    private RestContainerClient adminRestContainerClient;
    private ControlledTimeService timeService;

    public Object[] factory() {
        return new Object[]{new ContainerResourceTest().withSecurity(true).protocol(Protocol.HTTP_11).browser(false), new ContainerResourceTest().withSecurity(true).protocol(Protocol.HTTP_11).browser(true), new ContainerResourceTest().withSecurity(false).protocol(Protocol.HTTP_11).browser(false), new ContainerResourceTest().withSecurity(false).protocol(Protocol.HTTP_11).browser(true), new ContainerResourceTest().withSecurity(true).protocol(Protocol.HTTP_20).browser(false), new ContainerResourceTest().withSecurity(true).protocol(Protocol.HTTP_20).browser(true), new ContainerResourceTest().withSecurity(false).protocol(Protocol.HTTP_20).browser(false), new ContainerResourceTest().withSecurity(false).protocol(Protocol.HTTP_20).browser(true)};
    }

    @Override
    protected GlobalConfigurationBuilder getGlobalConfigForNode(int id) {
        GlobalConfigurationBuilder config = super.getGlobalConfigForNode(id);
        config.globalState().enable().configurationStorage(ConfigurationStorage.OVERLAY).persistentLocation(Paths.get(PERSISTENT_LOCATION, Integer.toString(id)).toString()).metrics().accurateSize(true);
        return config;
    }

    @Override
    protected void createCacheManagers() throws Exception {
        Util.recursiveFileRemove((String)PERSISTENT_LOCATION);
        super.createCacheManagers();
        this.restContainerClient = this.client.container();
        this.adminRestContainerClient = this.adminClient.container();
        this.timeService = new ControlledTimeService();
        this.cacheManagers.forEach(cm -> TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, (Object)this.timeService, (boolean)true));
    }

    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
        Configuration cache1Config = this.getCache1Config();
        this.cache2Config = this.getCache2Config();
        ConfigurationBuilder templateConfigBuilder = new ConfigurationBuilder();
        templateConfigBuilder.template(true).clustering().cacheMode(CacheMode.LOCAL).encoding().key().mediaType("text/plain");
        this.templateConfig = templateConfigBuilder.build();
        cm.defineConfiguration(CACHE_1, cache1Config);
        cm.defineConfiguration(CACHE_2, this.cache2Config);
        cm.defineConfiguration(CACHE_3, this.getCache3Config());
        cm.defineConfiguration(TEMPLATE_CONFIG, this.templateConfig);
    }

    private Configuration getCache1Config() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.statistics().enable().clustering().cacheMode(CacheMode.DIST_SYNC).partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES);
        return builder.build();
    }

    private Configuration getCache2Config() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.statistics().enable().clustering().cacheMode(CacheMode.LOCAL).encoding().key().mediaType("text/plain");
        builder.memory().maxCount(1000L).storage(StorageType.HEAP).whenFull(EvictionStrategy.REMOVE);
        return builder.build();
    }

    private Configuration getCache3Config() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        if (this.security) {
            builder.security().authorization().enable().roles(new String[]{"ADMIN", "USER"});
        }
        return builder.build();
    }

    @Test
    public void testHealth() {
        RestResponse response = this.join(this.restContainerClient.health());
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)response.body());
        Json clusterHealth = jsonNode.at("cluster_health");
        AssertJUnit.assertEquals((String)clusterHealth.at("health_status").asString(), (String)HealthStatus.FAILED.toString());
        AssertJUnit.assertEquals((int)clusterHealth.at("number_of_nodes").asInteger(), (int)2);
        AssertJUnit.assertEquals((int)clusterHealth.at("node_names").asJsonList().size(), (int)2);
        Json cacheHealth = jsonNode.at("cache_health");
        List<String> cacheNames = this.extractCacheNames(cacheHealth);
        AssertJUnit.assertTrue((boolean)cacheNames.contains(CACHE_1));
        AssertJUnit.assertTrue((boolean)cacheNames.contains(CACHE_2));
        response = this.join(this.restContainerClient.health(true));
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasNoContent();
    }

    @Test
    public void testCacheConfigs() {
        String accept = "text/plain; q=0.9, application/json; q=0.6";
        RestResponse response = this.join(this.restContainerClient.cacheConfigurations(accept));
        ResponseAssertion.assertThat(response).isOk();
        String json = response.body();
        Json jsonNode = Json.read((String)json);
        Map<String, String> cachesAndConfig = this.cacheAndConfig(jsonNode);
        AssertJUnit.assertEquals((String)cachesAndConfig.get(TEMPLATE_CONFIG), (String)ContainerResourceTest.cacheConfigToJson(TEMPLATE_CONFIG, this.templateConfig));
        AssertJUnit.assertEquals((String)cachesAndConfig.get(CACHE_2), (String)ContainerResourceTest.cacheConfigToJson(CACHE_2, this.cache2Config));
    }

    @Test
    public void testCacheConfigsTemplates() {
        String accept = "text/plain; q=0.9, application/json; q=0.6";
        RestResponse response = this.join(this.restContainerClient.templates(accept));
        ResponseAssertion.assertThat(response).isOk();
        String json = response.body();
        Json jsonNode = Json.read((String)json);
        Map<String, String> cachesAndConfig = this.cacheAndConfig(jsonNode);
        AssertJUnit.assertEquals((String)cachesAndConfig.get(TEMPLATE_CONFIG), (String)ContainerResourceTest.cacheConfigToJson(TEMPLATE_CONFIG, this.templateConfig));
        AssertJUnit.assertFalse((boolean)cachesAndConfig.containsKey(CACHE_1));
        AssertJUnit.assertFalse((boolean)cachesAndConfig.containsKey(CACHE_2));
    }

    private List<String> find(Json array, String name) {
        return array.asJsonList().stream().map(j -> j.at(name).getValue().toString()).collect(Collectors.toList());
    }

    @Test
    public void testGetGlobalConfig() {
        RestResponse response = this.join(this.adminRestContainerClient.globalConfiguration());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.body();
        EmbeddedCacheManager embeddedCacheManager = (EmbeddedCacheManager)this.cacheManagers.get(0);
        GlobalConfiguration globalConfiguration = embeddedCacheManager.withSubject(ADMIN).getCacheManagerConfiguration();
        StringBuilderWriter sw = new StringBuilderWriter();
        try (ConfigurationWriter w = ConfigurationWriter.to((Writer)sw).withType(MediaType.APPLICATION_JSON).build();){
            new ParserRegistry().serialize(w, globalConfiguration, Collections.emptyMap());
        }
        AssertJUnit.assertEquals((String)sw.toString(), (String)json);
    }

    @Test
    public void testGetGlobalConfigXML() {
        RestResponse response = this.join(this.adminRestContainerClient.globalConfiguration("application/xml"));
        ResponseAssertion.assertThat(response).isOk();
        String xml = response.body();
        ParserRegistry parserRegistry = new ParserRegistry();
        ConfigurationBuilderHolder builderHolder = parserRegistry.parse(xml);
        GlobalConfigurationBuilder globalConfigurationBuilder = builderHolder.getGlobalConfigurationBuilder();
        AssertJUnit.assertNotNull((Object)globalConfigurationBuilder.build());
    }

    @Test
    public void testInfo() {
        RestResponse response = this.join(this.restContainerClient.info());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.body();
        Json cmInfo = Json.read((String)json);
        AssertJUnit.assertFalse((boolean)cmInfo.at("version").asString().isEmpty());
        AssertJUnit.assertEquals((int)2, (int)cmInfo.at("cluster_members").asList().size());
        AssertJUnit.assertEquals((int)2, (int)cmInfo.at("cluster_members_physical_addresses").asList().size());
        AssertJUnit.assertEquals((String)"LON-1", (String)cmInfo.at("local_site").asString());
        AssertJUnit.assertTrue((boolean)cmInfo.at("relay_node").asBoolean());
        AssertJUnit.assertEquals((int)1, (int)cmInfo.at("relay_nodes_address").asList().size());
        AssertJUnit.assertEquals((int)1, (int)cmInfo.at("sites_view").asList().size());
        AssertJUnit.assertEquals((Object)"LON-1", cmInfo.at("sites_view").asList().get(0));
        AssertJUnit.assertTrue((boolean)cmInfo.at("rebalancing_enabled").asBoolean());
    }

    @Test
    public void testStats() {
        RestResponse response = this.join(this.adminRestContainerClient.stats());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.body();
        Json cmStats = Json.read((String)json);
        AssertJUnit.assertTrue((boolean)cmStats.at("statistics_enabled").asBoolean());
        AssertJUnit.assertEquals((int)0, (int)cmStats.at("stores").asInteger());
        AssertJUnit.assertEquals((int)0, (int)cmStats.at("number_of_entries").asInteger());
        this.timeService.advance(1000L);
        ((EmbeddedCacheManager)this.cacheManagers.iterator().next()).getCache(CACHE_1).put((Object)"key", (Object)"value");
        cmStats = Json.read((String)this.join(this.adminRestContainerClient.stats()).body());
        AssertJUnit.assertEquals((int)1, (int)cmStats.at("stores").asInteger());
        AssertJUnit.assertEquals((int)1, (int)cmStats.at("number_of_entries").asInteger());
    }

    @Test
    public void testConfigListener() throws InterruptedException, IOException {
        SSEListener sseListener = new SSEListener();
        try (Closeable ignored = this.adminClient.raw().listen("/rest/v2/container/config?action=listen&includeCurrentState=true", Collections.emptyMap(), (RestEventListener)sseListener);){
            AssertJUnit.assertTrue((boolean)sseListener.await(10L, TimeUnit.SECONDS));
            List<String> elements = List.of(TEMPLATE_CONFIG, CACHE_1, CACHE_2, CACHE_3, DEFAULT_CACHE, INVALID_CACHE, "___protobuf_metadata", "___script_cache");
            List<KeyValuePair<String, String>> events = sseListener.poll(elements.size());
            Assertions.assertThat(events).extracting(KeyValuePair::getKey).containsAnyOf((Object[])new String[]{"create-cache", "create-template"});
            elements.stream().forEach(element -> {
                Iterator iterator = events.iterator();
                boolean found = false;
                while (iterator.hasNext() && !found) {
                    KeyValuePair next = (KeyValuePair)iterator.next();
                    if (!((String)next.getValue()).contains((CharSequence)element)) continue;
                    found = true;
                }
                AssertJUnit.assertTrue((boolean)found);
            });
            this.createCache("{\"local-cache\":{\"encoding\":{\"media-type\":\"text/plain\"}}}", "listen1");
            sseListener.expectEvent("create-cache", "text/plain");
            this.createCache("{\"local-cache\":{\"encoding\":{\"media-type\":\"application/octet-stream\"}}}", "listen2");
            sseListener.expectEvent("create-cache", "application/octet-stream");
            ResponseAssertion.assertThat(this.client.cache("listen1").delete()).isOk();
            sseListener.expectEvent("remove-cache", "listen1");
        }
    }

    private void createCache(String json, String name) {
        RestEntity jsonEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json);
        CompletionStage response = this.client.cache(name).createWithConfiguration(jsonEntity, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
    }

    @Test
    public void testRebalancingActions() {
        this.assertRebalancingStatus(true);
        RestResponse response = this.join(this.adminRestContainerClient.disableRebalancing());
        ResponseAssertion.assertThat(response).isOk();
        this.assertRebalancingStatus(false);
        response = this.join(this.adminRestContainerClient.enableRebalancing());
        ResponseAssertion.assertThat(response).isOk();
        this.assertRebalancingStatus(true);
    }

    private void assertRebalancingStatus(boolean enabled) {
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            this.eventuallyEquals(enabled, () -> {
                try {
                    return ((LocalTopologyManager)TestingUtil.extractGlobalComponent((CacheContainer)cm, LocalTopologyManager.class)).isRebalancingEnabled();
                }
                catch (Exception e) {
                    AssertJUnit.fail((String)("Unexpected exception " + String.valueOf(e)));
                    return !enabled;
                }
            });
        }
    }

    private Map<String, String> cacheAndConfig(Json list) {
        HashMap<String, String> result = new HashMap<String, String>();
        list.asJsonList().forEach(node -> result.put(node.at("name").asString(), node.at("configuration").toString()));
        return result;
    }

    private List<String> extractCacheNames(Json cacheStatuses) {
        return cacheStatuses.asJsonList().stream().map(j -> j.at("cache_name").asString()).collect(Collectors.toList());
    }
}

