/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.util.Collection;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestCounterClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.ConvertUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.CounterResourceTest")
public class CounterResourceTest
extends AbstractRestResourceTest {
    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
        CounterManager counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)cm);
        counterManager.defineCounter("weak", CounterConfiguration.builder((CounterType)CounterType.WEAK).build());
        counterManager.defineCounter("strong", CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).build());
    }

    public Object[] factory() {
        return new Object[]{new CounterResourceTest().withSecurity(false).browser(false), new CounterResourceTest().withSecurity(false).browser(true), new CounterResourceTest().withSecurity(true).browser(false), new CounterResourceTest().withSecurity(true).browser(true)};
    }

    @Test
    public void testWeakCounterLifecycle() {
        CounterConfiguration counterConfig = CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(5L).storage(Storage.VOLATILE).concurrencyLevel(6).build();
        this.createCounter("sample-counter", counterConfig);
        RestCounterClient counterClient = this.client.counter("sample-counter");
        RestResponse response = this.join(counterClient.configuration("application/json"));
        Json jsonNode = Json.read((String)response.body());
        Json config = jsonNode.at("weak-counter");
        AssertJUnit.assertEquals((int)config.at("initial-value").asInteger(), (int)5);
        AssertJUnit.assertEquals((String)config.at("storage").asString(), (String)"VOLATILE");
        AssertJUnit.assertEquals((int)config.at("concurrency-level").asInteger(), (int)6);
        response = this.join(counterClient.delete());
        ResponseAssertion.assertThat(response).isOk();
        response = this.join(counterClient.configuration());
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void testWeakCounterOps() {
        String name = "weak-test";
        this.createCounter(name, CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(5L).build());
        RestCounterClient counterClient = this.client.counter(name);
        CompletionStage response = counterClient.increment();
        ResponseAssertion.assertThat(response).hasNoContent();
        this.waitForCounterToReach(name, 6);
        response = counterClient.increment();
        ResponseAssertion.assertThat(response).hasNoContent();
        this.waitForCounterToReach(name, 7);
        response = counterClient.decrement();
        ResponseAssertion.assertThat(response).hasNoContent();
        this.waitForCounterToReach(name, 6);
        response = counterClient.decrement();
        ResponseAssertion.assertThat(response).hasNoContent();
        this.waitForCounterToReach(name, 5);
        response = counterClient.add(10L);
        ResponseAssertion.assertThat(response).hasNoContent();
        this.waitForCounterToReach(name, 15);
        response = counterClient.reset();
        ResponseAssertion.assertThat(response).hasNoContent();
        this.waitForCounterToReach(name, 5);
    }

    @Test
    public void testStrongCounterOps() {
        String name = "strong-test";
        this.createCounter(name, CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).lowerBound(0L).upperBound(100L).initialValue(0L).build());
        RestCounterClient counterClient = this.client.counter(name);
        CompletionStage response = counterClient.increment();
        ResponseAssertion.assertThat(response).hasReturnedText("1");
        response = counterClient.increment();
        ResponseAssertion.assertThat(response).hasReturnedText("2");
        response = counterClient.decrement();
        ResponseAssertion.assertThat(response).hasReturnedText("1");
        response = counterClient.decrement();
        ResponseAssertion.assertThat(response).hasReturnedText("0");
        response = counterClient.add(35L);
        ResponseAssertion.assertThat(response).hasReturnedText("35");
        this.waitForCounterToReach(name, 35);
        response = counterClient.compareAndSet(5L, 32L);
        ResponseAssertion.assertThat(response).hasReturnedText("false");
        response = counterClient.compareAndSet(35L, 50L);
        ResponseAssertion.assertThat(response).hasReturnedText("true");
        this.waitForCounterToReach(name, 50);
        response = counterClient.compareAndSwap(50L, 90L);
        ResponseAssertion.assertThat(response).hasReturnedText("50");
        response = counterClient.get();
        ResponseAssertion.assertThat(response).hasReturnedText("90");
        response = counterClient.getAndSet(10L);
        ResponseAssertion.assertThat(response).hasReturnedText("90");
    }

    @Test
    public void testCounterNames() {
        String name = "weak-one-%d";
        for (int i = 0; i < 5; ++i) {
            this.createCounter(String.format(name, i), CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(5L).build());
        }
        RestResponse response = this.join(this.client.counters());
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)response.body());
        Collection counterNames = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)((EmbeddedCacheManager)this.cacheManagers.get(0))).getCounterNames();
        int size = jsonNode.asList().size();
        AssertJUnit.assertEquals((int)counterNames.size(), (int)size);
        for (int i = 0; i < size; ++i) {
            AssertJUnit.assertTrue((boolean)counterNames.contains(jsonNode.at(i).asString()));
        }
    }

    @Test
    public void testCounterCreation() {
        String counterName = "counter-creation";
        this.createCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(1L).build());
        ResponseAssertion.assertThat(this.doCounterCreateRequest(counterName, CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(1L).build())).isNotModified();
        ResponseAssertion.assertThat(this.doCounterCreateRequest(counterName, CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).initialValue(2L).build())).isNotModified();
    }

    private CompletionStage<RestResponse> doCounterCreateRequest(String name, CounterConfiguration configuration) {
        AbstractCounterConfiguration config = ConvertUtil.configToParsedConfig((String)name, (CounterConfiguration)configuration);
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)CounterResourceTest.counterConfigToJson(config));
        return this.client.counter(name).create(restEntity);
    }

    private void createCounter(String name, CounterConfiguration configuration) {
        ResponseAssertion.assertThat(this.doCounterCreateRequest(name, configuration)).isOk();
    }

    private void waitForCounterToReach(String name, int i) {
        RestCounterClient counterClient = this.client.counter(name);
        CounterResourceTest.eventually(() -> {
            RestResponse r = this.join(counterClient.get());
            ResponseAssertion.assertThat(r).isOk();
            long value = Long.parseLong(r.body());
            return value == (long)i;
        });
    }
}

