/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.OverviewReportResourceTest")
public class OverviewReportResourceTest
extends AbstractRestResourceTest {
    public Object[] factory() {
        return new Object[]{new OverviewReportResourceTest().withSecurity(false), new OverviewReportResourceTest().withSecurity(true)};
    }

    @Test
    public void overviewReport() {
        CompletionStage response = this.adminClient.server().overviewReport();
        ResponseAssertion.assertThat(response).isOk();
        Json report = Json.read((String)this.join(response).body());
        Assertions.assertThat((String)report.at("version").asString()).isNotBlank();
        Assertions.assertThat((String)report.at("product-version").asString()).isNotBlank();
        Assertions.assertThat((String)report.at("node-id").asString()).isNotBlank();
        Assertions.assertThat((String)report.at("coordinator-id").asString()).isNotBlank();
        Assertions.assertThat((int)report.at("cluster-size").asInteger()).isEqualTo(2);
        Assertions.assertThat((int)report.at("sites").asInteger()).isEqualTo(1);
        Assertions.assertThat((Map)report.at("cache-features").asJsonMap()).containsExactly(new Map.Entry[]{Map.entry("no-features", Json.make((Object)1))});
    }
}

