/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestSchemaClient;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.Util;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.security.Security;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.ProtobufResourceTest")
public class ProtobufResourceTest
extends AbstractRestResourceTest {
    public Object[] factory() {
        return new Object[]{new ProtobufResourceTest().withSecurity(false).browser(false), new ProtobufResourceTest().withSecurity(false).browser(true), new ProtobufResourceTest().withSecurity(true).browser(false), new ProtobufResourceTest().withSecurity(true).browser(true)};
    }

    @BeforeMethod(alwaysRun=true)
    public void createBeforeMethod() {
        Security.doAs((Subject)ADMIN, () -> ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache("___protobuf_metadata").clear());
    }

    public void listSchemasWhenEmpty() {
        CompletionStage response = this.client.schemas().names();
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)this.join(response).body());
        AssertJUnit.assertEquals((int)0, (int)jsonNode.asList().size());
    }

    @Test
    public void getNotExistingSchema() {
        CompletionStage response = this.client.schemas().get("coco");
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void updateNonExistingSchema() throws Exception {
        String person = Util.getResourceAsString((String)"person.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        CompletionStage response = this.client.schemas().put("person", person);
        ResponseAssertion.assertThat(response).isOk();
    }

    @Test
    public void putAndGetWrongProtobuf() throws Exception {
        RestSchemaClient schemaClient = this.client.schemas();
        String errorProto = Util.getResourceAsString((String)"error.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        RestResponse response = this.join(schemaClient.post("error", errorProto));
        String cause = "Syntax error in error.proto at 3:7: unexpected label: messoge";
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)response.body());
        AssertJUnit.assertEquals((String)"error.proto", (String)jsonNode.at("name").asString());
        AssertJUnit.assertEquals((String)"Schema error.proto has errors", (String)jsonNode.at("error").at("message").asString());
        AssertJUnit.assertEquals((String)cause, (String)jsonNode.at("error").at("cause").asString());
        response = this.join(schemaClient.get("error"));
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentEqualToFile("error.proto");
        this.checkListProtobufEndpointUrl("error.proto", cause);
    }

    @Test
    public void crudSchema() throws Exception {
        RestSchemaClient schemaClient = this.client.schemas();
        String personProto = Util.getResourceAsString((String)"person.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        RestResponse response = this.join(schemaClient.post("person", personProto));
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)response.body());
        Assert.assertTrue((boolean)jsonNode.at("error").isNull());
        response = this.join(schemaClient.get("person"));
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentEqualToFile("person.proto");
        response = this.join(schemaClient.get("person.proto"));
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentEqualToFile("person.proto");
        response = this.join(schemaClient.put("person", personProto));
        ResponseAssertion.assertThat(response).isOk();
        response = this.join(schemaClient.delete("person"));
        ResponseAssertion.assertThat(response).isOk();
        response = this.join(schemaClient.get("person"));
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void createTwiceSchema() throws Exception {
        RestSchemaClient schemaClient = this.client.schemas();
        String personProto = Util.getResourceAsString((String)"person.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        CompletionStage response = schemaClient.post("person", personProto);
        ResponseAssertion.assertThat(response).isOk();
        response = schemaClient.post("person", personProto);
        ResponseAssertion.assertThat(response).isConflicted();
    }

    @Test
    public void addAndGetListOrderedByName() throws Exception {
        RestSchemaClient schemaClient = this.client.schemas();
        String personProto = Util.getResourceAsString((String)"person.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.join(schemaClient.post("users", personProto));
        this.join(schemaClient.post("people", personProto));
        this.join(schemaClient.post("dancers", personProto));
        RestResponse response = this.join(schemaClient.names());
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)response.body());
        AssertJUnit.assertEquals((int)3, (int)jsonNode.asList().size());
        AssertJUnit.assertEquals((String)"dancers.proto", (String)jsonNode.at(0).at("name").asString());
        AssertJUnit.assertEquals((String)"people.proto", (String)jsonNode.at(1).at("name").asString());
        AssertJUnit.assertEquals((String)"users.proto", (String)jsonNode.at(2).at("name").asString());
    }

    @Test
    public void getSchemaTypes() throws Exception {
        RestSchemaClient schemaClient = this.client.schemas();
        String personProto = Util.getResourceAsString((String)"person.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.join(schemaClient.post("users", personProto));
        RestResponse response = this.join(schemaClient.types());
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)response.body());
        AssertJUnit.assertEquals((int)4, (int)jsonNode.asList().size());
        Assert.assertTrue((boolean)jsonNode.asList().contains("org.infinispan.rest.search.entity.Person"));
    }

    @Test
    public void uploadEmptySchema() {
        CompletionStage response = this.client.schemas().put("empty", "");
        ResponseAssertion.assertThat(response).isBadRequest();
    }

    private void checkListProtobufEndpointUrl(String fileName, String errorMessage) {
        RestSchemaClient schemaClient = this.client.schemas();
        RestResponse response = this.join(schemaClient.names());
        Json jsonNode = Json.read((String)response.body());
        AssertJUnit.assertEquals((int)1, (int)jsonNode.asList().size());
        AssertJUnit.assertEquals((String)fileName, (String)jsonNode.at(0).at("name").asString());
        AssertJUnit.assertEquals((String)"Schema error.proto has errors", (String)jsonNode.at(0).at("error").at("message").asString());
        AssertJUnit.assertEquals((String)errorMessage, (String)jsonNode.at(0).at("error").at("cause").asString());
    }
}

