/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.infinispan.client.rest.RestEventListener;
import org.infinispan.client.rest.RestResponseInfo;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;

public class SSEListener
implements RestEventListener {
    protected static final Consumer<KeyValuePair<String, String>> NO_OP = ignore -> {};
    private static final Log log = LogFactory.getLog(SSEListener.class);
    BlockingDeque<KeyValuePair<String, String>> events = new LinkedBlockingDeque<KeyValuePair<String, String>>();
    private final CountDownLatch openLatch = new CountDownLatch(1);

    public void onOpen(RestResponseInfo response) {
        log.tracef("open", new Object[0]);
        if (response.status() < 300) {
            this.openLatch.countDown();
        }
    }

    public void onMessage(String id, String type, String data) {
        log.tracef("Received %s %s %s", (Object)id, (Object)type, (Object)data);
        this.events.add((KeyValuePair<String, String>)new KeyValuePair((Object)type, (Object)data));
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.openLatch.await(timeout, unit);
    }

    public void expectEvent(String type, String subString) throws InterruptedException {
        this.expectEvent(type, subString, NO_OP);
    }

    public List<KeyValuePair<String, String>> poll(int num) throws InterruptedException {
        ArrayList<KeyValuePair<String, String>> polled = new ArrayList<KeyValuePair<String, String>>();
        for (int i = 0; i < num; ++i) {
            KeyValuePair<String, String> event = this.events.poll(10L, TimeUnit.SECONDS);
            Assert.assertNotNull(event);
            polled.add(event);
        }
        return polled;
    }

    public void expectEvent(String type, String subString, Consumer<KeyValuePair<String, String>> consumer) throws InterruptedException {
        KeyValuePair<String, String> event = this.events.poll(10L, TimeUnit.SECONDS);
        Assert.assertNotNull(event);
        AssertJUnit.assertEquals((String)type, (String)((String)event.getKey()));
        Assert.assertTrue((boolean)((String)event.getValue()).contains(subString));
        consumer.accept(event);
    }
}

