/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.util.concurrent.CompletionStage;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.Version;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.ServerResourceTest")
public class ServerResourceTest
extends AbstractRestResourceTest {
    public Object[] factory() {
        return new Object[]{new ServerResourceTest().withSecurity(false), new ServerResourceTest().withSecurity(true)};
    }

    @Test
    public void testServerInfo() {
        CompletionStage response = this.client.server().info();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).containsReturnedText(Version.printVersion());
    }

    @Test
    public void testServerConnectorNames() {
        CompletionStage response = this.adminClient.server().connectorNames();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).containsReturnedText("DummyProtocol");
    }

    @Test
    public void testServerConnectorDetail() {
        CompletionStage response = this.adminClient.server().connector("DummyProtocol");
        ResponseAssertion.assertThat(response).isOk();
        String body = this.join(response).body();
        Json jsonNode = Json.read((String)body);
        AssertJUnit.assertEquals((String)"DummyProtocol", (String)jsonNode.at("name").asString());
        AssertJUnit.assertEquals((String)"dummyCache", (String)jsonNode.at("default-cache").asString());
        AssertJUnit.assertTrue((boolean)jsonNode.at("enabled").asBoolean());
        AssertJUnit.assertTrue((boolean)jsonNode.at("ip-filter-rules").asJsonList().isEmpty());
        AssertJUnit.assertEquals((String)"localhost", (String)jsonNode.at("host").asString());
        AssertJUnit.assertTrue((boolean)jsonNode.has("port"));
        AssertJUnit.assertTrue((boolean)jsonNode.has("local-connections"));
        AssertJUnit.assertTrue((boolean)jsonNode.has("global-connections"));
        AssertJUnit.assertTrue((boolean)jsonNode.has("io-threads"));
        AssertJUnit.assertTrue((boolean)jsonNode.has("pending-tasks"));
        AssertJUnit.assertTrue((boolean)jsonNode.has("total-bytes-read"));
        AssertJUnit.assertTrue((boolean)jsonNode.has("total-bytes-written"));
        AssertJUnit.assertTrue((boolean)jsonNode.has("send-buffer-size"));
        AssertJUnit.assertTrue((boolean)jsonNode.has("receive-buffer-size"));
    }

    @Test
    public void testServerReport() {
        CompletionStage response = this.adminClient.server().report();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/gzip");
    }

    @Test
    public void testIgnoreCache() {
        CompletionStage response = this.adminClient.server().listIgnoredCaches();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("[]");
        response = this.adminClient.server().ignoreCache("one-cache");
        ResponseAssertion.assertThat(response).isNotFound();
        response = this.adminClient.server().ignoreCache("defaultcache");
        ResponseAssertion.assertThat(response).isOk();
        response = this.adminClient.server().listIgnoredCaches();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("[\"defaultcache\"]");
        response = this.adminClient.server().unIgnoreCache("one-cache");
        ResponseAssertion.assertThat(response).isNotFound();
        response = this.adminClient.server().unIgnoreCache("defaultcache");
        ResponseAssertion.assertThat(response).isOk();
        response = this.adminClient.server().listIgnoredCaches();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("[]");
    }
}

