/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.infinispan.commons.util.ByRef;
import org.infinispan.rest.resources.SSEListener;
import org.infinispan.test.TestException;
import org.infinispan.util.KeyValuePair;

public class WeakSSEListener
extends SSEListener {
    private final ConcurrentMap<String, List<String>> backup = new ConcurrentHashMap<String, List<String>>();

    @Override
    public void expectEvent(String type, String subString, Consumer<KeyValuePair<String, String>> consumer) throws InterruptedException {
        CompletableFuture<KeyValuePair> waitEvent = CompletableFuture.supplyAsync(() -> {
            ByRef pair = new ByRef(null);
            this.backup.computeIfPresent(type, (k, v) -> {
                int index = -1;
                for (int i = 0; i < v.size() && pair.get() == null; ++i) {
                    if (!((String)v.get(i)).contains(subString)) continue;
                    pair.set((Object)new KeyValuePair(k, (Object)((String)v.get(i))));
                    index = i;
                    break;
                }
                if (index >= 0) {
                    v.remove(index);
                }
                return v;
            });
            while (pair.get() == null) {
                try {
                    KeyValuePair event = (KeyValuePair)this.events.poll(10L, TimeUnit.SECONDS);
                    assert (event != null) : "No event received";
                    if (type.equals(event.getKey()) && ((String)event.getValue()).contains(subString)) {
                        pair.set((Object)event);
                        break;
                    }
                    this.backup.compute((String)event.getKey(), (k, v) -> {
                        if (v == null) {
                            v = new ArrayList<String>();
                        }
                        v.add((String)event.getValue());
                        return v;
                    });
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new TestException((Throwable)e);
                }
            }
            assert (pair.get() != null) : "Should contain event with: " + subString;
            return (KeyValuePair)pair.get();
        });
        try {
            KeyValuePair pair = waitEvent.get(10L, TimeUnit.SECONDS);
            consumer.accept((KeyValuePair<String, String>)pair);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new TestException((Throwable)e);
        }
    }
}

