/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.search;

import java.util.ArrayList;
import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.model.Game;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.search.RestHitCountAccuracyTest")
public class RestHitCountAccuracyTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "games";
    private static final int ENTRIES = 5000;
    private RestServerHelper restServer;
    private RestClient restClient;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager();
        Cache metadataCache = cacheManager.getCache("___protobuf_metadata");
        metadataCache.putIfAbsent((Object)Game.GameSchema.INSTANCE.getProtoFileName(), (Object)Game.GameSchema.INSTANCE.getProtoFile());
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.encoding().mediaType("application/x-protostream").indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("Game").query().hitCountAccuracy(10);
        cacheManager.createCache(CACHE_NAME, config.build());
        this.restServer = new RestServerHelper(cacheManager);
        this.restServer.start(TestResourceTracker.getCurrentTestShortName());
        this.restClient = RestClient.forConfiguration((RestClientConfiguration)new RestClientConfigurationBuilder().addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).protocol(Protocol.HTTP_20).build());
        return cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void teardown() {
        try {
            this.restClient.close();
        }
        catch (Exception exception) {
            try {
                this.restServer.stop();
            }
            finally {
                super.teardown();
            }
        }
        finally {
            try {
                this.restServer.stop();
            }
            finally {
                super.teardown();
            }
        }
    }

    @Test
    public void test() throws Exception {
        RestCacheClient cacheClient = this.restClient.cache(CACHE_NAME);
        RestHitCountAccuracyTest.writeEntries(5000, cacheClient);
        Assert.assertEquals((int)5000, (int)this.count(cacheClient));
        CompletionStage response = cacheClient.query("from Game where description : 'game'", 10, 0);
        ResponseAssertion.assertThat(response).isOk();
        Json body = Json.read((String)((RestResponse)response.toCompletableFuture().get()).body());
        Object hitCountExact = body.at("hit_count_exact").getValue();
        Assert.assertEquals((Object)hitCountExact, (Object)false);
        response = cacheClient.query("from Game where description : 'game'", 10, 0, 5000);
        ResponseAssertion.assertThat(response).isOk();
        body = Json.read((String)((RestResponse)response.toCompletableFuture().get()).body());
        hitCountExact = body.at("hit_count_exact").getValue();
        Assert.assertEquals((Object)hitCountExact, (Object)true);
        Assert.assertEquals((int)body.at("hit_count").asInteger(), (int)5000);
    }

    private static void writeEntries(int entries, RestCacheClient cacheClient) {
        ArrayList<CompletionStage> responses = new ArrayList<CompletionStage>(entries);
        for (int i = 0; i < entries; ++i) {
            Json game = Json.object().set("_type", (Object)"Game").set("name", (Object)("Game n." + i)).set("description", (Object)("This is the game #" + i));
            responses.add(cacheClient.put("game-" + i, RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)game.toString())));
        }
        for (CompletionStage response : responses) {
            ResponseAssertion.assertThat(response).isOk();
        }
    }

    private int count(RestCacheClient cacheClient) {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.searchStats());
        Json stat = Json.read((String)response.body());
        Json indexGame = stat.at("index").at("types").at("Game");
        return indexGame.at("count").asInteger();
    }
}

