/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.search.projection;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.search.projection.RestProjectionSearchTest")
public class RestProjectionTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "items";
    private static final int ENTRIES = 10;
    private RestServerHelper restServer;
    private RestClient restClient;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager();
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.encoding().mediaType("application/x-protostream").indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("Game");
        cacheManager.createCache(CACHE_NAME, config.build());
        this.restServer = new RestServerHelper(cacheManager);
        this.restServer.start(TestResourceTracker.getCurrentTestShortName());
        this.restClient = RestClient.forConfiguration((RestClientConfiguration)new RestClientConfigurationBuilder().addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).protocol(Protocol.HTTP_20).build());
        return cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void teardown() {
        try {
            this.restClient.close();
        }
        catch (Exception exception) {
            try {
                this.restServer.stop();
            }
            finally {
                super.teardown();
            }
        }
        finally {
            try {
                this.restServer.stop();
            }
            finally {
                super.teardown();
            }
        }
    }

    @Test
    public void test() throws Exception {
        RestCacheClient cacheClient = this.restClient.cache(CACHE_NAME);
        RestProjectionTest.writeEntries(cacheClient);
        CompletionStage response = cacheClient.query("from Game g where g.description : 'bla3'", 10, 0);
        ResponseAssertion.assertThat(response).isOk();
        Json body = Json.read((String)((RestResponse)response.toCompletableFuture().get()).body());
        Assertions.assertThat((List)body.at("hits").asJsonList()).extracting(json -> json.at("hit").at("name").asString()).containsExactly((Object[])new String[]{"bla3"});
        response = cacheClient.query("select g.description from Game g where g.description : 'bla3'", 10, 0);
        ResponseAssertion.assertThat(response).isOk();
        body = Json.read((String)((RestResponse)response.toCompletableFuture().get()).body());
        Assertions.assertThat((List)body.at("hits").asJsonList()).extracting(json -> json.at("hit").at("description").asString()).containsExactly((Object[])new String[]{"bla bla3"});
        response = cacheClient.query("select g from Game g where g.description : 'bla3'", 10, 0);
        ResponseAssertion.assertThat(response).isOk();
        body = Json.read((String)((RestResponse)response.toCompletableFuture().get()).body());
        Assertions.assertThat((List)body.at("hits").asJsonList()).extracting(json -> json.at("hit").at("*").at("name").asString()).containsExactly((Object[])new String[]{"bla3"});
        response = cacheClient.query("select g, g.description from Game g where g.description : 'bla3'", 10, 0);
        ResponseAssertion.assertThat(response).isOk();
        body = Json.read((String)((RestResponse)response.toCompletableFuture().get()).body());
        Assertions.assertThat((List)body.at("hits").asJsonList()).extracting(json -> json.at("hit").at("description").asString()).containsExactly((Object[])new String[]{"bla bla3"});
        Assertions.assertThat((List)body.at("hits").asJsonList()).extracting(json -> json.at("hit").at("*").at("name").asString()).containsExactly((Object[])new String[]{"bla3"});
    }

    private static void writeEntries(RestCacheClient cacheClient) {
        ArrayList<CompletionStage> responses = new ArrayList<CompletionStage>(10);
        for (byte i = 1; i <= 10; i = (byte)(i + 1)) {
            Json game = Json.object().set("_type", (Object)"Game").set("name", (Object)("bla" + i)).set("description", (Object)("bla bla" + i));
            String json = game.toString();
            responses.add(cacheClient.put("g" + i, RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json)));
        }
        for (CompletionStage response : responses) {
            ResponseAssertion.assertThat(response).isOk();
        }
    }
}

