/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.search.reindex;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.cache.IndexingMode;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.model.Game;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="rest.search.reindex.RestReindexRemoveAndStatisticsTest")
public class RestReindexRemoveAndStatisticsTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "types";
    private static final int ENTRIES = 5000;
    private static final int FEW_ENTRIES = 5;
    private RestServerHelper restServer;
    private RestClient restClient;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager();
        Cache metadataCache = cacheManager.getCache("___protobuf_metadata");
        metadataCache.putIfAbsent((Object)Game.GameSchema.INSTANCE.getProtoFileName(), (Object)Game.GameSchema.INSTANCE.getProtoFile());
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.encoding().mediaType("application/x-protostream").indexing().enable().indexingMode(IndexingMode.MANUAL).storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("Game");
        cacheManager.createCache(CACHE_NAME, config.build());
        this.restServer = new RestServerHelper(cacheManager);
        this.restServer.start(TestResourceTracker.getCurrentTestShortName());
        this.restClient = RestClient.forConfiguration((RestClientConfiguration)new RestClientConfigurationBuilder().addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).build());
        return cacheManager;
    }

    @Test
    public void reindexRemoveAndGetStatistics() {
        RestCacheClient cacheClient = this.restClient.cache(CACHE_NAME);
        ResponseAssertion.assertThat(cacheClient.clearIndex()).isOk();
        AssertJUnit.assertEquals((int)0, (int)this.count(cacheClient));
        RestReindexRemoveAndStatisticsTest.writeEntries(5000, cacheClient);
        AssertJUnit.assertEquals((int)0, (int)this.count(cacheClient));
        ResponseAssertion.assertThat(cacheClient.reindex()).isOk();
        AssertJUnit.assertEquals((int)5000, (int)this.count(cacheClient));
        ResponseAssertion.assertThat(cacheClient.clearIndex()).isOk();
        AssertJUnit.assertEquals((int)0, (int)this.count(cacheClient));
    }

    @Test
    public void reindexAsFirstOperation() {
        RestCacheClient cacheClient = this.restClient.cache(CACHE_NAME);
        ResponseAssertion.assertThat(cacheClient.reindex()).isOk();
    }

    @Test
    public void reindexAndConcurrentlyGetStatistics() throws Exception {
        RestCacheClient cacheClient = this.restClient.cache(CACHE_NAME);
        ResponseAssertion.assertThat(cacheClient.clearIndex()).isOk();
        AssertJUnit.assertEquals((int)0, (int)this.count(cacheClient));
        RestReindexRemoveAndStatisticsTest.writeEntries(5, cacheClient);
        AssertJUnit.assertEquals((int)0, (int)this.count(cacheClient));
        for (int i = 0; i < 3; ++i) {
            CompletableFuture<RestResponse> reindexOperation = cacheClient.reindex().toCompletableFuture();
            while (!reindexOperation.isDone()) {
                CompletionStage searchStatsRequest = cacheClient.searchStats();
                ResponseAssertion.assertThat(searchStatsRequest).isOk();
            }
            ResponseAssertion.assertThat(reindexOperation).isOk();
        }
    }

    protected void teardown() {
        Util.close((AutoCloseable)this.restClient);
        try {
            this.restServer.stop();
        }
        finally {
            super.teardown();
        }
    }

    private static void writeEntries(int entries, RestCacheClient cacheClient) {
        ArrayList<CompletionStage> responses = new ArrayList<CompletionStage>(entries);
        for (int i = 0; i < entries; ++i) {
            Json game = Json.object().set("_type", (Object)"Game").set("name", (Object)("Game n." + i)).set("description", (Object)("This is the game #" + i));
            responses.add(cacheClient.put("game-" + i, RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)game.toString())));
        }
        for (CompletionStage response : responses) {
            ResponseAssertion.assertThat(response).isOk();
        }
    }

    private int count(RestCacheClient cacheClient) {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.searchStats());
        Json stat = Json.read((String)response.body());
        Json indexGame = stat.at("index").at(CACHE_NAME).at("Game");
        return indexGame.at("count").asInteger();
    }
}

