/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.search.vector;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.search.vector.RestVectorSearchTest")
public class RestVectorSearchTest
extends SingleCacheManagerTest {
    private static final String[] BUGGY_OPTIONS = new String[]{"cat lover", "code lover", "mystical", "philologist", "algorithm designer", "decisionist", "philosopher"};
    private static final String CACHE_NAME = "items";
    private static final int ENTRIES = 50;
    private RestServerHelper restServer;
    private RestClient restClient;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager();
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.encoding().mediaType("application/x-protostream").indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("Item");
        cacheManager.createCache(CACHE_NAME, config.build());
        this.restServer = new RestServerHelper(cacheManager);
        this.restServer.start(TestResourceTracker.getCurrentTestShortName());
        this.restClient = RestClient.forConfiguration((RestClientConfiguration)new RestClientConfigurationBuilder().addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).protocol(Protocol.HTTP_20).build());
        return cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void teardown() {
        try {
            this.restClient.close();
        }
        catch (Exception exception) {
            try {
                this.restServer.stop();
            }
            finally {
                super.teardown();
            }
        }
        finally {
            try {
                this.restServer.stop();
            }
            finally {
                super.teardown();
            }
        }
    }

    @Test
    public void test() throws Exception {
        RestCacheClient cacheClient = this.restClient.cache(CACHE_NAME);
        RestVectorSearchTest.writeEntries(cacheClient);
        CompletionStage response = cacheClient.query("from Item i where i.byteVector <-> [7,6,7]~3", 10, 0);
        ResponseAssertion.assertThat(response).isOk();
        Json body = Json.read((String)((RestResponse)response.toCompletableFuture().get()).body());
        Assertions.assertThat((List)body.at("hits").asJsonList()).extracting(json -> json.at("hit").at("code").asString()).containsExactly((Object[])new String[]{"c7", "c6", "c8"});
        response = cacheClient.query("from Item i where i.floatVector <-> [7.1,7.0,3.1]~3", 10, 0);
        ResponseAssertion.assertThat(response).isOk();
        body = Json.read((String)((RestResponse)response.toCompletableFuture().get()).body());
        Assertions.assertThat((List)body.at("hits").asJsonList()).extracting(json -> json.at("hit").at("code").asString()).containsExactly((Object[])new String[]{"c5", "c6", "c4"});
        response = cacheClient.query("select i, score(i) from Item i where i.floatVector <-> [7.1,7.0,3.1]~3", 10, 0);
        ResponseAssertion.assertThat(response).isOk();
        body = Json.read((String)((RestResponse)response.toCompletableFuture().get()).body());
        Assertions.assertThat((List)body.at("hits").asJsonList()).extracting(json -> json.at("hit").at("*").at("code").asString()).containsExactly((Object[])new String[]{"c5", "c6", "c4"});
        Assertions.assertThat((List)body.at("hits").asJsonList()).extracting(json -> json.at("hit").at("score()").asString()).hasSize(3);
        response = cacheClient.query("from Item i where i.floatVector <-> [7,7,7]~3 filtering i.buggy : 'cat'", 10, 0);
        ResponseAssertion.assertThat(response).isOk();
        body = Json.read((String)((RestResponse)response.toCompletableFuture().get()).body());
        Assertions.assertThat((List)body.at("hits").asJsonList()).extracting(json -> json.at("hit").at("code").asString()).containsExactly((Object[])new String[]{"c7", "c14", "c21"});
        response = cacheClient.query("from Item i where i.floatVector <-> [7,7,7]~3 filtering (i.buggy : 'cat' or i.buggy : 'code')", 10, 0);
        ResponseAssertion.assertThat(response).isOk();
        body = Json.read((String)((RestResponse)response.toCompletableFuture().get()).body());
        Assertions.assertThat((List)body.at("hits").asJsonList()).extracting(json -> json.at("hit").at("code").asString()).containsExactly((Object[])new String[]{"c7", "c8", "c1"});
        response = cacheClient.query("select score(i), i from Item i where i.floatVector <-> [7,7,7]~3 filtering i.buggy : 'cat'", 10, 0);
        ResponseAssertion.assertThat(response).isOk();
        body = Json.read((String)((RestResponse)response.toCompletableFuture().get()).body());
        Assertions.assertThat((List)body.at("hits").asJsonList()).extracting(json -> json.at("hit").at("*").at("code").asString()).containsExactly((Object[])new String[]{"c7", "c14", "c21"});
        response = cacheClient.query("select score(i), i from Item i where i.floatVector <-> [7,7,7]~3 filtering (i.buggy : 'cat' or i.buggy : 'code')", 10, 0);
        ResponseAssertion.assertThat(response).isOk();
        body = Json.read((String)((RestResponse)response.toCompletableFuture().get()).body());
        Assertions.assertThat((List)body.at("hits").asJsonList()).extracting(json -> json.at("hit").at("*").at("code").asString()).containsExactly((Object[])new String[]{"c7", "c8", "c1"});
    }

    private static void writeEntries(RestCacheClient cacheClient) {
        ArrayList<CompletionStage> responses = new ArrayList<CompletionStage>(50);
        for (byte item = 1; item <= 50; item = (byte)(item + 1)) {
            String buggy = BUGGY_OPTIONS[item % 7];
            Json game = Json.object().set("_type", (Object)"Item").set("code", (Object)("c" + item)).set("byteVector", RestVectorSearchTest.byteArray(item)).set("floatVector", (Object)new float[]{1.1f * (float)item, 1.1f * (float)item, 1.1f * (float)item}).set("buggy", (Object)buggy);
            String json = game.toString();
            responses.add(cacheClient.put("item-" + item, RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json)));
        }
        for (CompletionStage response : responses) {
            ResponseAssertion.assertThat(response).isOk();
        }
    }

    private static Object byteArray(byte item) {
        if (item % 2 == 0) {
            return Json.array((Object[])new Object[]{item, item, item});
        }
        byte[] byteArray = new byte[]{item, item, item};
        return Base64.getEncoder().encodeToString(byteArray);
    }
}

