/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.tracing;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.server.core.telemetry.inmemory.InMemoryTelemetryClient;
import org.infinispan.telemetry.SpanCategory;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"tracing"}, testName="rest.tracing.RestTracingPropagationTest")
public class RestTracingPropagationTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "tracing";
    private static final String CLIENT_SPAN_NAME = "user-client-side-span";
    private static final String PUT_OPERATION_SPAN_NAME = "putValueToCache";
    private final InMemoryTelemetryClient telemetryClient = new InMemoryTelemetryClient();
    private RestServerHelper restServer;
    private RestClient restClient;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder().nonClusteredDefault();
        global.tracing().collectorEndpoint("file://in-memory-local-process");
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createServerModeCacheManager((GlobalConfigurationBuilder)global);
        cacheManager.createCache(CACHE_NAME, RestTracingPropagationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.LOCAL).build());
        this.restServer = new RestServerHelper(cacheManager);
        this.restServer.start(TestResourceTracker.getCurrentTestShortName());
        this.restClient = RestClient.forConfiguration((RestClientConfiguration)new RestClientConfigurationBuilder().addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).build());
        return cacheManager;
    }

    @Test
    public void smokeTest() {
        RestCacheClient client = this.restClient.cache(CACHE_NAME);
        this.telemetryClient.withinClientSideSpan(CLIENT_SPAN_NAME, () -> {
            Map<String, String> contextMap = RestTracingPropagationTest.getContextMap();
            Assertions.assertThat(contextMap).isNotEmpty();
            CompletionStage resp1 = client.put("aaa", MediaType.TEXT_PLAIN.toString(), RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (String)"bbb"), contextMap);
            CompletionStage resp2 = client.put("bbb", MediaType.TEXT_PLAIN.toString(), RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (String)"ccc"), contextMap);
            ResponseAssertion.assertThat(resp1).isOk();
            ResponseAssertion.assertThat(resp2).isOk();
        });
        List allSpans = this.telemetryClient.finishedSpanItems();
        Map spansByName = InMemoryTelemetryClient.aggregateByName((List)allSpans);
        Assertions.assertThat((Map)spansByName).containsKeys((Object[])new String[]{PUT_OPERATION_SPAN_NAME, CLIENT_SPAN_NAME});
        List clientSpans = (List)spansByName.get(CLIENT_SPAN_NAME);
        Assertions.assertThat((List)clientSpans).hasSize(1);
        SpanData clientSpan = (SpanData)clientSpans.get(0);
        String clientTraceId = clientSpan.getTraceId();
        String clientSpanId = clientSpan.getSpanId();
        List serverSpans = (List)spansByName.get(PUT_OPERATION_SPAN_NAME);
        ((ListAssert)Assertions.assertThat((List)serverSpans).hasSize(2)).allSatisfy(spanData -> {
            Assertions.assertThat((String)spanData.getTraceId()).isEqualTo(clientTraceId);
            Assertions.assertThat((String)spanData.getParentSpanId()).isEqualTo(clientSpanId);
            Attributes attributes = spanData.getAttributes();
            Assertions.assertThat((String)((String)attributes.get(AttributeKey.stringKey((String)"cache")))).isEqualTo(CACHE_NAME);
            Assertions.assertThat((String)((String)attributes.get(AttributeKey.stringKey((String)"category")))).isEqualTo(SpanCategory.CONTAINER.toString());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void teardown() {
        try {
            this.telemetryClient.reset();
            this.restClient.close();
        }
        catch (Exception exception) {
            try {
                this.restServer.stop();
            }
            finally {
                super.teardown();
            }
        }
        finally {
            try {
                this.restServer.stop();
            }
            finally {
                super.teardown();
            }
        }
    }

    public static Map<String, String> getContextMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        W3CTraceContextPropagator.getInstance().inject(Context.current(), result, (carrier, key, value) -> carrier.put(key, value));
        return result;
    }
}

