/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.tracing;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.hibernate.search.util.common.impl.Closer;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.server.core.telemetry.inmemory.InMemoryTelemetryClient;
import org.infinispan.telemetry.SpanCategory;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"tracing"}, testName="rest.tracing.RestTracingRuntimeEnablingTest")
public class RestTracingRuntimeEnablingTest
extends SingleCacheManagerTest {
    private static final String CACHE_A = "cacheA";
    private static final String CACHE_B = "cacheB";
    private static final String PUT_OPERATION_SPAN_NAME = "putValueToCache";
    private static final String PERSISTENT_LOCATION = CommonsTestingUtil.tmpDirectory((String[])new String[]{RestTracingRuntimeEnablingTest.class.getName()});
    private final InMemoryTelemetryClient telemetryClient = new InMemoryTelemetryClient();
    private RestServerHelper restServer;
    private RestClient restClient;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Util.recursiveFileRemove((String)PERSISTENT_LOCATION);
        ConfigurationBuilder configA = RestTracingRuntimeEnablingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.LOCAL);
        configA.tracing().enable();
        ConfigurationBuilder configB = RestTracingRuntimeEnablingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.LOCAL);
        configB.tracing().disable();
        EmbeddedCacheManager manager = TestCacheManagerFactory.createServerModeCacheManager((GlobalConfigurationBuilder)this.globalConfiguration());
        manager.administration().createCache(CACHE_A, configA.build());
        manager.administration().createCache(CACHE_B, configB.build());
        this.restServer = new RestServerHelper(manager);
        this.restServer.start(TestResourceTracker.getCurrentTestShortName());
        this.restClient = RestClient.forConfiguration((RestClientConfiguration)new RestClientConfigurationBuilder().addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).build());
        return manager;
    }

    @Test
    public void smokeTest() {
        RestCacheClient cacheA = this.restClient.cache(CACHE_A);
        RestCacheClient cacheB = this.restClient.cache(CACHE_B);
        CompletionStage resp1 = cacheA.put("aaa", MediaType.TEXT_PLAIN.toString(), RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (String)"bbb"));
        CompletionStage resp2 = cacheB.put("bbb", MediaType.TEXT_PLAIN.toString(), RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (String)"ccc"));
        ResponseAssertion.assertThat(resp1).isOk();
        ResponseAssertion.assertThat(resp2).isOk();
        this.eventuallyEquals(1, () -> this.telemetryClient.finishedSpanItems().size());
        List result = this.telemetryClient.finishedSpanItems();
        SpanData span = (SpanData)result.get(0);
        Assertions.assertThat((String)span.getName()).isEqualTo(PUT_OPERATION_SPAN_NAME);
        Attributes attributes = span.getAttributes();
        Assertions.assertThat((String)((String)attributes.get(AttributeKey.stringKey((String)"cache")))).isEqualTo(CACHE_A);
        Assertions.assertThat((String)((String)attributes.get(AttributeKey.stringKey((String)"category")))).isEqualTo(SpanCategory.CONTAINER.toString());
        this.telemetryClient.reset();
        resp1 = cacheA.updateConfigurationAttribute("tracing.enabled", "false");
        resp2 = cacheB.updateConfigurationAttribute("tracing.enabled", "true");
        ResponseAssertion.assertThat(resp1).isOk();
        ResponseAssertion.assertThat(resp2).isOk();
        this.eventuallyEquals(false, () -> this.cacheManager.getCache(CACHE_A).getCacheConfiguration().tracing().enabled());
        this.eventuallyEquals(true, () -> this.cacheManager.getCache(CACHE_B).getCacheConfiguration().tracing().enabled());
        resp1 = cacheA.put("ccc", MediaType.TEXT_PLAIN.toString(), RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (String)"ddd"));
        resp2 = cacheB.put("ddd", MediaType.TEXT_PLAIN.toString(), RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (String)"eee"));
        ResponseAssertion.assertThat(resp1).isOk();
        ResponseAssertion.assertThat(resp2).isOk();
        this.eventuallyEquals(1, () -> this.telemetryClient.finishedSpanItems().size());
        result = this.telemetryClient.finishedSpanItems();
        span = (SpanData)result.get(0);
        Assertions.assertThat((String)span.getName()).isEqualTo(PUT_OPERATION_SPAN_NAME);
        attributes = span.getAttributes();
        Assertions.assertThat((String)((String)attributes.get(AttributeKey.stringKey((String)"cache")))).isEqualTo(CACHE_B);
        Assertions.assertThat((String)((String)attributes.get(AttributeKey.stringKey((String)"category")))).isEqualTo(SpanCategory.CONTAINER.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void teardown() {
        try (Closer closer = new Closer();){
            closer.push(InMemoryTelemetryClient::reset, (Object)this.telemetryClient);
            closer.push(AutoCloseable::close, (Object)this.restClient);
            closer.push(RestServerHelper::stop, (Object)this.restServer);
        }
        catch (Exception exception) {
        }
        finally {
            Util.recursiveFileRemove((String)PERSISTENT_LOCATION);
            super.teardown();
        }
    }

    private GlobalConfigurationBuilder globalConfiguration() {
        GlobalConfigurationBuilder config = new GlobalConfigurationBuilder().nonClusteredDefault();
        config.globalState().enable().configurationStorage(ConfigurationStorage.OVERLAY).persistentLocation(Paths.get(PERSISTENT_LOCATION, new String[0]).toString()).metrics().accurateSize(true).tracing().collectorEndpoint("file://in-memory-local-process");
        return config;
    }
}

