/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tasks;

import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.tasks.DummyTaskEngine;
import org.infinispan.tasks.MemoryEventLogger;
import org.infinispan.tasks.Task;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskExecution;
import org.infinispan.tasks.TaskExecutionMode;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.impl.TaskManagerImpl;
import org.infinispan.tasks.logging.Messages;
import org.infinispan.tasks.spi.TaskEngine;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.EventLogger;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="tasks.TaskManagerTest", groups={"functional"})
public class TaskManagerTest
extends SingleCacheManagerTest {
    protected TaskManagerImpl taskManager;
    private DummyTaskEngine taskEngine;
    private MemoryEventLogger memoryLogger;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager();
    }

    protected void setup() throws Exception {
        super.setup();
        GlobalComponentRegistry gcr = this.cacheManager.getGlobalComponentRegistry();
        this.taskManager = (TaskManagerImpl)gcr.getComponent(TaskManager.class);
        this.taskEngine = new DummyTaskEngine();
        this.taskManager.registerTaskEngine((TaskEngine)this.taskEngine);
        this.memoryLogger = new MemoryEventLogger(this.cacheManager, gcr.getTimeService());
        ((EventLogManager)gcr.getComponent(EventLogManager.class)).replaceEventLogger((EventLogger)this.memoryLogger);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testUnhandledTask() throws Throwable {
        try {
            CompletionStages.join((CompletionStage)this.taskManager.runTask("UnhandledTask", new TaskContext()));
        }
        catch (CompletionException e) {
            throw CompletableFutures.extractException((Throwable)e);
        }
    }

    public void testStoredEngines() {
        List engines = this.taskManager.getEngines();
        AssertJUnit.assertEquals((int)1, (int)engines.size());
        AssertJUnit.assertEquals((String)this.taskEngine.getName(), (String)((TaskEngine)engines.iterator().next()).getName());
    }

    public void testRunTask() {
        this.memoryLogger.reset();
        CompletionStage okTask = this.taskManager.runTask(DummyTaskEngine.DummyTaskTypes.SUCCESSFUL_TASK.name(), new TaskContext().logEvent(true));
        AssertJUnit.assertEquals((String)"result", (String)((String)CompletionStages.join((CompletionStage)okTask)));
        AssertJUnit.assertEquals((int)0, (int)this.taskManager.getCurrentTasks().size());
        AssertJUnit.assertEquals((String)Messages.MESSAGES.taskSuccess(DummyTaskEngine.DummyTaskTypes.SUCCESSFUL_TASK.name()), (String)this.memoryLogger.getMessage());
        AssertJUnit.assertEquals((String)"result", (String)this.memoryLogger.getDetail());
        AssertJUnit.assertEquals((Object)EventLogCategory.TASKS, (Object)this.memoryLogger.getCategory());
        AssertJUnit.assertEquals((Object)EventLogLevel.INFO, (Object)this.memoryLogger.getLevel());
        this.memoryLogger.reset();
        CompletionStage paramTask = this.taskManager.runTask(DummyTaskEngine.DummyTaskTypes.PARAMETERIZED_TASK.name(), new TaskContext().logEvent(true).addParameter("parameter", (Object)"Hello"));
        AssertJUnit.assertEquals((String)"Hello", (String)((String)CompletionStages.join((CompletionStage)paramTask)));
        AssertJUnit.assertEquals((int)0, (int)this.taskManager.getCurrentTasks().size());
        AssertJUnit.assertEquals((String)Messages.MESSAGES.taskSuccess(DummyTaskEngine.DummyTaskTypes.PARAMETERIZED_TASK.name()), (String)this.memoryLogger.getMessage());
        AssertJUnit.assertEquals((String)"Hello", (String)this.memoryLogger.getDetail());
        AssertJUnit.assertEquals((Object)EventLogCategory.TASKS, (Object)this.memoryLogger.getCategory());
        AssertJUnit.assertEquals((Object)EventLogLevel.INFO, (Object)this.memoryLogger.getLevel());
        this.memoryLogger.reset();
        CompletionStage koTask = this.taskManager.runTask(DummyTaskEngine.DummyTaskTypes.FAILING_TASK.name(), new TaskContext().logEvent(true));
        String message = (String)CompletionStages.join(koTask.handle((r, e) -> e.getCause().getMessage()));
        AssertJUnit.assertEquals((int)0, (int)this.taskManager.getCurrentTasks().size());
        AssertJUnit.assertEquals((String)"exception", (String)message);
        AssertJUnit.assertEquals((String)Messages.MESSAGES.taskFailure(DummyTaskEngine.DummyTaskTypes.FAILING_TASK.name()), (String)this.memoryLogger.getMessage());
        AssertJUnit.assertTrue((boolean)this.memoryLogger.getDetail().contains("java.lang.Exception: exception"));
        AssertJUnit.assertEquals((Object)EventLogCategory.TASKS, (Object)this.memoryLogger.getCategory());
        AssertJUnit.assertEquals((Object)EventLogLevel.ERROR, (Object)this.memoryLogger.getLevel());
        this.memoryLogger.reset();
        CompletionStage slowTask = this.taskManager.runTask(DummyTaskEngine.DummyTaskTypes.SLOW_TASK.name(), new TaskContext().logEvent(true));
        List currentTasks = this.taskManager.getCurrentTasks();
        AssertJUnit.assertEquals((int)1, (int)currentTasks.size());
        TaskExecution execution = (TaskExecution)currentTasks.iterator().next();
        AssertJUnit.assertEquals((String)DummyTaskEngine.DummyTaskTypes.SLOW_TASK.name(), (String)execution.getName());
        List tasks = this.taskManager.getTasks();
        AssertJUnit.assertEquals((int)DummyTaskEngine.DummyTaskTypes.values().length, (int)tasks.size());
        Task task = (Task)tasks.get(4);
        AssertJUnit.assertEquals((String)DummyTaskEngine.DummyTaskTypes.SLOW_TASK.name(), (String)task.getName());
        AssertJUnit.assertEquals((String)"Dummy", (String)task.getType());
        AssertJUnit.assertEquals((Object)TaskExecutionMode.ONE_NODE, (Object)task.getExecutionMode());
        this.taskEngine.getSlowTask().complete("slow");
        AssertJUnit.assertEquals((int)0, (int)this.taskManager.getCurrentTasks().size());
        AssertJUnit.assertEquals((Object)"slow", (Object)CompletionStages.join((CompletionStage)slowTask));
    }
}

