/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.readdetect.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.infrastructurebuilder.util.readdetect.model.IBCPTInputLocationTracker;
import org.infrastructurebuilder.util.readdetect.model.IBCPTInputSource;

public final class IBCPTInputLocation
implements Serializable,
Cloneable,
IBCPTInputLocationTracker {
    private int lineNumber = -1;
    private int columnNumber = -1;
    private IBCPTInputSource source;
    private Map<Object, IBCPTInputLocation> locations;
    private IBCPTInputLocation location;

    public IBCPTInputLocation(int lineNumber, int columnNumber) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public IBCPTInputLocation(int lineNumber, int columnNumber, IBCPTInputSource source) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.source = source;
    }

    public IBCPTInputLocation clone() {
        try {
            IBCPTInputLocation copy = (IBCPTInputLocation)super.clone();
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, IBCPTInputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public IBCPTInputLocation getLocation(Object key) {
        if (key instanceof String) {
            if ("".equals(key)) {
                return this.location;
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public Map<Object, IBCPTInputLocation> getLocations() {
        return this.locations;
    }

    @Override
    public void setLocation(Object key, IBCPTInputLocation location) {
        if (key instanceof String) {
            if ("".equals(key)) {
                this.location = location;
                return;
            }
            this.setOtherLocation(key, location);
            return;
        }
        this.setOtherLocation(key, location);
    }

    public void setOtherLocation(Object key, IBCPTInputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, IBCPTInputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    private IBCPTInputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public IBCPTInputSource getSource() {
        return this.source;
    }

    public static IBCPTInputLocation merge(IBCPTInputLocation target, IBCPTInputLocation source, boolean sourceDominant) {
        Map<Object, IBCPTInputLocation> locations;
        if (source == null) {
            return target;
        }
        if (target == null) {
            return source;
        }
        IBCPTInputLocation result = new IBCPTInputLocation(target.getLineNumber(), target.getColumnNumber(), target.getSource());
        Map<Object, IBCPTInputLocation> sourceLocations = source.getLocations();
        Map<Object, IBCPTInputLocation> targetLocations = target.getLocations();
        if (sourceLocations == null) {
            locations = targetLocations;
        } else if (targetLocations == null) {
            locations = sourceLocations;
        } else {
            locations = new LinkedHashMap<Object, IBCPTInputLocation>();
            locations.putAll(sourceDominant ? targetLocations : sourceLocations);
            locations.putAll(sourceDominant ? sourceLocations : targetLocations);
        }
        result.setLocations(locations);
        return result;
    }

    public static IBCPTInputLocation merge(IBCPTInputLocation target, IBCPTInputLocation source, Collection<Integer> indices) {
        Map<Object, IBCPTInputLocation> locations;
        if (source == null) {
            return target;
        }
        if (target == null) {
            return source;
        }
        IBCPTInputLocation result = new IBCPTInputLocation(target.getLineNumber(), target.getColumnNumber(), target.getSource());
        Map<Object, IBCPTInputLocation> sourceLocations = source.getLocations();
        Map<Object, IBCPTInputLocation> targetLocations = target.getLocations();
        if (sourceLocations == null) {
            locations = targetLocations;
        } else if (targetLocations == null) {
            locations = sourceLocations;
        } else {
            locations = new LinkedHashMap<Object, IBCPTInputLocation>();
            for (Integer index : indices) {
                IBCPTInputLocation location = index < 0 ? sourceLocations.get(~index.intValue()) : targetLocations.get(index);
                locations.put(locations.size(), location);
            }
        }
        result.setLocations(locations);
        return result;
    }

    public void setLocations(Map<Object, IBCPTInputLocation> locations) {
        this.locations = locations;
    }

    public static abstract class StringFormatter {
        public abstract String toString(IBCPTInputLocation var1);
    }
}

