/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.readdetect.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.infrastructurebuilder.util.readdetect.model.IBCPTInputLocation;
import org.infrastructurebuilder.util.readdetect.model.IBCPTInputLocationTracker;
import org.infrastructurebuilder.util.readdetect.model.IBResourceCacheIF;
import org.infrastructurebuilder.util.readdetect.model.IBResourceModel;

public class IBResourceCache
implements IBResourceCacheIF,
Serializable,
Cloneable,
IBCPTInputLocationTracker {
    private String root;
    private String description;
    private long size = 0L;
    private Properties additionalProperties;
    private Set<IBResourceModel> resources;
    private String modelEncoding = "UTF-8";
    private Map<Object, IBCPTInputLocation> locations;
    private IBCPTInputLocation location;
    private IBCPTInputLocation rootLocation;
    private IBCPTInputLocation descriptionLocation;
    private IBCPTInputLocation sizeLocation;
    private IBCPTInputLocation additionalPropertiesLocation;
    private IBCPTInputLocation resourcesLocation;

    public void addAdditionalProperty(String key, String value) {
        this.getAdditionalProperties().put(key, value);
    }

    public void addResource(IBResourceModel iBResourceModel) {
        this.getResources().add(iBResourceModel);
    }

    public IBResourceCache clone() {
        try {
            IBResourceCache copy = (IBResourceCache)super.clone();
            if (this.additionalProperties != null) {
                copy.additionalProperties = (Properties)this.additionalProperties.clone();
            }
            if (this.resources != null) {
                copy.resources = new HashSet<IBResourceModel>();
                for (IBResourceModel item : this.resources) {
                    copy.resources.add(item.clone());
                }
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, IBCPTInputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public Properties getAdditionalProperties() {
        if (this.additionalProperties == null) {
            this.additionalProperties = new Properties();
        }
        return this.additionalProperties;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public IBCPTInputLocation getLocation(Object key) {
        if (key instanceof String) {
            if ("".equals(key)) {
                return this.location;
            }
            if ("root".equals(key)) {
                return this.rootLocation;
            }
            if ("description".equals(key)) {
                return this.descriptionLocation;
            }
            if ("size".equals(key)) {
                return this.sizeLocation;
            }
            if ("additionalProperties".equals(key)) {
                return this.additionalPropertiesLocation;
            }
            if ("resources".equals(key)) {
                return this.resourcesLocation;
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    @Override
    public void setLocation(Object key, IBCPTInputLocation location) {
        if (key instanceof String) {
            if ("".equals(key)) {
                this.location = location;
                return;
            }
            if ("root".equals(key)) {
                this.rootLocation = location;
                return;
            }
            if ("description".equals(key)) {
                this.descriptionLocation = location;
                return;
            }
            if ("size".equals(key)) {
                this.sizeLocation = location;
                return;
            }
            if ("additionalProperties".equals(key)) {
                this.additionalPropertiesLocation = location;
                return;
            }
            if ("resources".equals(key)) {
                this.resourcesLocation = location;
                return;
            }
            this.setOtherLocation(key, location);
            return;
        }
        this.setOtherLocation(key, location);
    }

    public void setOtherLocation(Object key, IBCPTInputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, IBCPTInputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    private IBCPTInputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public Set<IBResourceModel> getResources() {
        if (this.resources == null) {
            this.resources = new HashSet<IBResourceModel>();
        }
        return this.resources;
    }

    public String getRoot() {
        return this.root;
    }

    public long getSize() {
        return this.size;
    }

    public void removeResource(IBResourceModel iBResourceModel) {
        this.getResources().remove(iBResourceModel);
    }

    public void setAdditionalProperties(Properties additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public void setResources(Set<IBResourceModel> resources) {
        this.resources = resources;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setSize(long size) {
        this.size = size;
    }
}

