/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.readdetect.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.infrastructurebuilder.util.readdetect.model.IBCPTInputLocation;
import org.infrastructurebuilder.util.readdetect.model.IBCPTInputLocationTracker;
import org.infrastructurebuilder.util.readdetect.model.IBResourceModelIF;

public class IBResourceModel
implements IBResourceModelIF,
Serializable,
Cloneable,
IBCPTInputLocationTracker {
    private String filePath;
    private boolean cached = false;
    private String subPath;
    private String fileChecksum;
    private String type;
    private String source;
    private String name;
    private String mostRecentReadTime;
    private String lastUpdate;
    private String created;
    private String realized;
    private String description;
    private long size = 0L;
    private Properties additionalProperties;
    private Map<Object, IBCPTInputLocation> locations;
    private IBCPTInputLocation location;
    private IBCPTInputLocation filePathLocation;
    private IBCPTInputLocation cachedLocation;
    private IBCPTInputLocation subPathLocation;
    private IBCPTInputLocation fileChecksumLocation;
    private IBCPTInputLocation typeLocation;
    private IBCPTInputLocation sourceLocation;
    private IBCPTInputLocation nameLocation;
    private IBCPTInputLocation mostRecentReadTimeLocation;
    private IBCPTInputLocation lastUpdateLocation;
    private IBCPTInputLocation createdLocation;
    private IBCPTInputLocation realizedLocation;
    private IBCPTInputLocation descriptionLocation;
    private IBCPTInputLocation sizeLocation;
    private IBCPTInputLocation additionalPropertiesLocation;

    public void addAdditionalProperty(String key, String value) {
        this.getAdditionalProperties().put(key, value);
    }

    public IBResourceModel clone() {
        try {
            IBResourceModel copy = (IBResourceModel)super.clone();
            if (this.additionalProperties != null) {
                copy.additionalProperties = (Properties)this.additionalProperties.clone();
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, IBCPTInputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public Properties getAdditionalProperties() {
        if (this.additionalProperties == null) {
            this.additionalProperties = new Properties();
        }
        return this.additionalProperties;
    }

    @Override
    public String getCreated() {
        return this.created;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFileChecksum() {
        return this.fileChecksum;
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public String getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public IBCPTInputLocation getLocation(Object key) {
        if (key instanceof String) {
            if ("".equals(key)) {
                return this.location;
            }
            if ("filePath".equals(key)) {
                return this.filePathLocation;
            }
            if ("cached".equals(key)) {
                return this.cachedLocation;
            }
            if ("subPath".equals(key)) {
                return this.subPathLocation;
            }
            if ("fileChecksum".equals(key)) {
                return this.fileChecksumLocation;
            }
            if ("type".equals(key)) {
                return this.typeLocation;
            }
            if ("source".equals(key)) {
                return this.sourceLocation;
            }
            if ("name".equals(key)) {
                return this.nameLocation;
            }
            if ("mostRecentReadTime".equals(key)) {
                return this.mostRecentReadTimeLocation;
            }
            if ("lastUpdate".equals(key)) {
                return this.lastUpdateLocation;
            }
            if ("created".equals(key)) {
                return this.createdLocation;
            }
            if ("realized".equals(key)) {
                return this.realizedLocation;
            }
            if ("description".equals(key)) {
                return this.descriptionLocation;
            }
            if ("size".equals(key)) {
                return this.sizeLocation;
            }
            if ("additionalProperties".equals(key)) {
                return this.additionalPropertiesLocation;
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public String getMostRecentReadTime() {
        return this.mostRecentReadTime;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setLocation(Object key, IBCPTInputLocation location) {
        if (key instanceof String) {
            if ("".equals(key)) {
                this.location = location;
                return;
            }
            if ("filePath".equals(key)) {
                this.filePathLocation = location;
                return;
            }
            if ("cached".equals(key)) {
                this.cachedLocation = location;
                return;
            }
            if ("subPath".equals(key)) {
                this.subPathLocation = location;
                return;
            }
            if ("fileChecksum".equals(key)) {
                this.fileChecksumLocation = location;
                return;
            }
            if ("type".equals(key)) {
                this.typeLocation = location;
                return;
            }
            if ("source".equals(key)) {
                this.sourceLocation = location;
                return;
            }
            if ("name".equals(key)) {
                this.nameLocation = location;
                return;
            }
            if ("mostRecentReadTime".equals(key)) {
                this.mostRecentReadTimeLocation = location;
                return;
            }
            if ("lastUpdate".equals(key)) {
                this.lastUpdateLocation = location;
                return;
            }
            if ("created".equals(key)) {
                this.createdLocation = location;
                return;
            }
            if ("realized".equals(key)) {
                this.realizedLocation = location;
                return;
            }
            if ("description".equals(key)) {
                this.descriptionLocation = location;
                return;
            }
            if ("size".equals(key)) {
                this.sizeLocation = location;
                return;
            }
            if ("additionalProperties".equals(key)) {
                this.additionalPropertiesLocation = location;
                return;
            }
            this.setOtherLocation(key, location);
            return;
        }
        this.setOtherLocation(key, location);
    }

    public void setOtherLocation(Object key, IBCPTInputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, IBCPTInputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    private IBCPTInputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Override
    public String getRealized() {
        return this.realized;
    }

    public long getSize() {
        return this.size;
    }

    public String getSource() {
        return this.source;
    }

    public String getSubPath() {
        return this.subPath;
    }

    public String getType() {
        return this.type;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setAdditionalProperties(Properties additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFileChecksum(String fileChecksum) {
        this.fileChecksum = fileChecksum;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setLastUpdate(String lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setMostRecentReadTime(String mostRecentReadTime) {
        this.mostRecentReadTime = mostRecentReadTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRealized(String realized) {
        this.realized = realized;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSubPath(String subPath) {
        this.subPath = subPath;
    }

    public void setType(String type) {
        this.type = type;
    }
}

