/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.readdetect.model;

import java.time.Instant;
import java.util.Optional;
import java.util.function.Function;

public interface IBResourceModelIF {
    public static final Function<String, Optional<Instant>> parseInstant = i -> {
        try {
            return Optional.of(Instant.parse(i));
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    };

    public String getRealized();

    public String getLastUpdate();

    public String getCreated();

    default public Optional<Instant> getRealizedInstant() {
        return parseInstant.apply(this.getRealized());
    }

    default public Optional<Instant> getLastUpdateInstant() {
        return parseInstant.apply(this.getLastUpdate());
    }

    default public Optional<Instant> getCreatedInstant() {
        return parseInstant.apply(this.getCreated());
    }

    default public boolean isRealized() {
        return this.getRealizedInstant().isPresent();
    }
}

