/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.util.readdetect.model.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;
import org.infrastructurebuilder.util.readdetect.model.IBCPTInputLocation;
import org.infrastructurebuilder.util.readdetect.model.IBCPTInputLocationTracker;
import org.infrastructurebuilder.util.readdetect.model.IBResourceCache;
import org.infrastructurebuilder.util.readdetect.model.IBResourceModel;

public class IBResourceModelXpp3WriterEx {
    private static final String NAMESPACE = null;
    private String fileComment = null;
    protected IBCPTInputLocation.StringFormatter stringFormatter;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void setStringFormatter(IBCPTInputLocation.StringFormatter stringFormatter) {
        this.stringFormatter = stringFormatter;
    }

    protected String toString(IBCPTInputLocation location) {
        if (this.stringFormatter != null) {
            return this.stringFormatter.toString(location);
        }
        return " " + location.getSource().toString() + ":" + location.getLineNumber() + " ";
    }

    public void write(Writer writer, IBResourceCache iBResourceCache) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(iBResourceCache.getModelEncoding(), null);
        this.writeIBResourceCache(iBResourceCache, "resourceCache", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, IBResourceCache iBResourceCache) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, iBResourceCache.getModelEncoding());
        serializer.startDocument(iBResourceCache.getModelEncoding(), null);
        this.writeIBResourceCache(iBResourceCache, "resourceCache", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeIBResourceCache(IBResourceCache iBResourceCache, String tagName, XmlSerializer serializer) throws IOException {
        if (this.fileComment != null) {
            serializer.comment(this.fileComment);
        }
        serializer.setPrefix("", "https://resources.infrastructurebuilder.org/IBResource/0.21");
        serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        serializer.startTag(NAMESPACE, tagName);
        serializer.attribute("", "xsi:schemaLocation", "https://resources.infrastructurebuilder.org/IBResource/0.21 https://resources.infrastructurebuilder.org/xsd/IBDataSet-0.21");
        if (iBResourceCache.getRoot() != null) {
            serializer.startTag(NAMESPACE, "root").text(iBResourceCache.getRoot()).endTag(NAMESPACE, "root");
            this.writeLocationTracking(iBResourceCache, "root", serializer);
        }
        if (iBResourceCache.getDescription() != null) {
            serializer.startTag(NAMESPACE, "description").text(iBResourceCache.getDescription()).endTag(NAMESPACE, "description");
            this.writeLocationTracking(iBResourceCache, "description", serializer);
        }
        if (iBResourceCache.getSize() != 0L) {
            serializer.startTag(NAMESPACE, "size").text(String.valueOf(iBResourceCache.getSize())).endTag(NAMESPACE, "size");
            this.writeLocationTracking(iBResourceCache, "size", serializer);
        }
        if (iBResourceCache.getAdditionalProperties() != null && iBResourceCache.getAdditionalProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "additionalProperties");
            IBCPTInputLocation location = iBResourceCache.getLocation("additionalProperties");
            for (String string : iBResourceCache.getAdditionalProperties().keySet()) {
                String value = (String)iBResourceCache.getAdditionalProperties().get(string);
                serializer.startTag(NAMESPACE, string).text(value).endTag(NAMESPACE, string);
                this.writeLocationTracking(location, string, serializer);
            }
            serializer.endTag(NAMESPACE, "additionalProperties");
        }
        if (iBResourceCache.getResources() != null && iBResourceCache.getResources().size() > 0) {
            serializer.startTag(NAMESPACE, "resources");
            for (IBResourceModel o : iBResourceCache.getResources()) {
                this.writeIBResourceModel(o, "resource", serializer);
            }
            serializer.endTag(NAMESPACE, "resources");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeIBResourceModel(IBResourceModel iBResourceModel, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (iBResourceModel.getSubPath() != null) {
            serializer.startTag(NAMESPACE, "subPath").text(iBResourceModel.getSubPath()).endTag(NAMESPACE, "subPath");
            this.writeLocationTracking(iBResourceModel, "subPath", serializer);
        }
        if (iBResourceModel.getFileChecksum() != null) {
            serializer.startTag(NAMESPACE, "fileChecksum").text(iBResourceModel.getFileChecksum()).endTag(NAMESPACE, "fileChecksum");
            this.writeLocationTracking(iBResourceModel, "fileChecksum", serializer);
        }
        if (iBResourceModel.getType() != null) {
            serializer.startTag(NAMESPACE, "type").text(iBResourceModel.getType()).endTag(NAMESPACE, "type");
            this.writeLocationTracking(iBResourceModel, "type", serializer);
        }
        if (iBResourceModel.getSource() != null) {
            serializer.startTag(NAMESPACE, "source").text(iBResourceModel.getSource()).endTag(NAMESPACE, "source");
            this.writeLocationTracking(iBResourceModel, "source", serializer);
        }
        if (iBResourceModel.getName() != null) {
            serializer.startTag(NAMESPACE, "name").text(iBResourceModel.getName()).endTag(NAMESPACE, "name");
            this.writeLocationTracking(iBResourceModel, "name", serializer);
        }
        if (iBResourceModel.getLastUpdate() != null) {
            serializer.startTag(NAMESPACE, "lastUpdate").text(iBResourceModel.getLastUpdate()).endTag(NAMESPACE, "lastUpdate");
            this.writeLocationTracking(iBResourceModel, "lastUpdate", serializer);
        }
        if (iBResourceModel.getCreated() != null) {
            serializer.startTag(NAMESPACE, "created").text(iBResourceModel.getCreated()).endTag(NAMESPACE, "created");
            this.writeLocationTracking(iBResourceModel, "created", serializer);
        }
        if (iBResourceModel.getRealized() != null) {
            serializer.startTag(NAMESPACE, "realized").text(iBResourceModel.getRealized()).endTag(NAMESPACE, "realized");
            this.writeLocationTracking(iBResourceModel, "realized", serializer);
        }
        if (iBResourceModel.getDescription() != null) {
            serializer.startTag(NAMESPACE, "description").text(iBResourceModel.getDescription()).endTag(NAMESPACE, "description");
            this.writeLocationTracking(iBResourceModel, "description", serializer);
        }
        if (iBResourceModel.getSize() != 0L) {
            serializer.startTag(NAMESPACE, "size").text(String.valueOf(iBResourceModel.getSize())).endTag(NAMESPACE, "size");
            this.writeLocationTracking(iBResourceModel, "size", serializer);
        }
        if (iBResourceModel.getAdditionalProperties() != null && iBResourceModel.getAdditionalProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "additionalProperties");
            IBCPTInputLocation location = iBResourceModel.getLocation("additionalProperties");
            for (String string : iBResourceModel.getAdditionalProperties().keySet()) {
                String value = (String)iBResourceModel.getAdditionalProperties().get(string);
                serializer.startTag(NAMESPACE, string).text(value).endTag(NAMESPACE, string);
                this.writeLocationTracking(location, string, serializer);
            }
            serializer.endTag(NAMESPACE, "additionalProperties");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeLocationTracking(IBCPTInputLocationTracker locationTracker, Object key, XmlSerializer serializer) throws IOException {
        IBCPTInputLocation location;
        IBCPTInputLocation iBCPTInputLocation = location = locationTracker == null ? null : locationTracker.getLocation(key);
        if (location != null) {
            serializer.comment(this.toString(location));
        }
    }
}

