/*
 * Decompiled with CFR 0.152.
 */
package com.mscharhag.et;

import com.mscharhag.et.ET;
import com.mscharhag.et.ExceptionTranslator;
import com.mscharhag.et.TranslationException;
import com.mscharhag.et.test.TestUtil;
import com.mscharhag.et.test.exceptions.BarException;
import com.mscharhag.et.test.exceptions.BarRuntimeException;
import com.mscharhag.et.test.exceptions.FooChildException;
import com.mscharhag.et.test.exceptions.FooChildRuntimeException;
import com.mscharhag.et.test.exceptions.FooException;
import com.mscharhag.et.test.exceptions.FooRuntimeException;
import com.mscharhag.oleaster.matcher.Matchers;
import org.junit.Test;

public class CustomConfigurationTest {
    @Test
    public void customExceptionMappingIsUsed() {
        ExceptionTranslator et = ET.newConfiguration().translate(new Class[]{FooException.class}).to(FooRuntimeException.class).done();
        RuntimeException result = TestUtil.translateException(et, TestUtil.FOO_EXCEPTION);
        TestUtil.expectException(result, FooRuntimeException.class, "fooException", TestUtil.FOO_EXCEPTION);
    }

    @Test
    public void runtimeExceptionsCanBeMapped() {
        ExceptionTranslator et = ET.newConfiguration().translate(new Class[]{FooRuntimeException.class}).to(BarRuntimeException.class).done();
        RuntimeException result = TestUtil.translateException(et, TestUtil.FOO_RUNTIME_EXCEPTION);
        TestUtil.expectException(result, BarRuntimeException.class, "fooRuntimeException", TestUtil.FOO_RUNTIME_EXCEPTION);
    }

    @Test
    public void defaultMappingWillBeUsedIfNoCustomMappingCanBeFound() {
        ExceptionTranslator et = ET.newConfiguration().translate(new Class[]{FooException.class}).to(FooRuntimeException.class).done();
        RuntimeException result = TestUtil.translateException(et, TestUtil.BAR_EXCEPTION);
        TestUtil.expectException(result, RuntimeException.class, "barException", TestUtil.BAR_EXCEPTION);
    }

    @Test
    public void baseClassCanBeUsedInMappings() {
        ExceptionTranslator et = ET.newConfiguration().translate(new Class[]{FooException.class}).to(FooRuntimeException.class).done();
        RuntimeException result = TestUtil.translateException(et, TestUtil.FOO_CHILD_EXCEPTION);
        TestUtil.expectException(result, FooRuntimeException.class, "fooChildException", TestUtil.FOO_CHILD_EXCEPTION);
    }

    @Test
    public void mostSpecificMappingIsUsed() {
        ExceptionTranslator et = ET.newConfiguration().translate(new Class[]{Exception.class}).to(BarRuntimeException.class).translate(new Class[]{FooChildException.class}).to(FooChildRuntimeException.class).translate(new Class[]{FooException.class}).to(FooRuntimeException.class).done();
        RuntimeException result = TestUtil.translateException(et, TestUtil.FOO_CHILD_EXCEPTION);
        TestUtil.expectException(result, FooChildRuntimeException.class, "fooChildException", TestUtil.FOO_CHILD_EXCEPTION);
    }

    @Test
    public void lambdaMapping() {
        ExceptionTranslator et = ET.newConfiguration().translate(new Class[]{FooException.class}).using((m, ex) -> TestUtil.FOO_RUNTIME_EXCEPTION).done();
        RuntimeException result = TestUtil.translateException(et, TestUtil.FOO_EXCEPTION);
        Matchers.expect((Object)result).toEqual((Object)TestUtil.FOO_RUNTIME_EXCEPTION);
    }

    @Test(expected=TranslationException.class)
    public void lambdaMappingReturnsNull() {
        ExceptionTranslator et = ET.newConfiguration().translate(new Class[]{FooException.class}).using((m, ex) -> null).done();
        et.withTranslation(() -> {
            throw new FooException("foo");
        });
    }

    @Test
    public void multipleMappings() {
        ExceptionTranslator et = ET.newConfiguration().translate(new Class[]{FooException.class, BarException.class}).to(FooRuntimeException.class).done();
        RuntimeException first = TestUtil.translateException(et, TestUtil.FOO_EXCEPTION);
        RuntimeException second = TestUtil.translateException(et, TestUtil.BAR_EXCEPTION);
        TestUtil.expectException(first, FooRuntimeException.class, "fooException", TestUtil.FOO_EXCEPTION);
        TestUtil.expectException(second, FooRuntimeException.class, "barException", TestUtil.BAR_EXCEPTION);
    }

    @Test
    public void methodReference() {
        ExceptionTranslator et = ET.newConfiguration().translate(new Class[]{FooException.class}).using(FooRuntimeException::new).done();
        RuntimeException result = TestUtil.translateException(et, TestUtil.FOO_EXCEPTION);
        Matchers.expect((String)result.getMessage()).toEqual((Object)TestUtil.FOO_EXCEPTION.getMessage());
        Matchers.expect((Object)result.getCause()).toEqual((Object)TestUtil.FOO_EXCEPTION);
    }
}

