/*
 * Decompiled with CFR 0.152.
 */
package com.mscharhag.et.impl;

import com.mscharhag.et.TranslationException;
import com.mscharhag.et.impl.ReflectiveExceptionResolver;
import com.mscharhag.et.test.TestUtil;
import com.mscharhag.et.test.exceptions.FooException;
import org.junit.Test;

public class ReflectiveExceptionResolverTest {
    ReflectiveExceptionResolver resolver;

    @Test
    public void stringConstructor() {
        this.resolver = new ReflectiveExceptionResolver(StringConstructorException.class);
        RuntimeException result = this.resolver.getTargetException((Exception)new FooException("foo"));
        TestUtil.expectException(result, StringConstructorException.class, "foo", null);
    }

    @Test
    public void throwableConstructor() {
        this.resolver = new ReflectiveExceptionResolver(ThrowableConstructorException.class);
        FooException source = new FooException("foo");
        RuntimeException result = this.resolver.getTargetException((Exception)source);
        TestUtil.expectException(result, ThrowableConstructorException.class, "com.mscharhag.et.test.exceptions.FooException: foo", source);
    }

    @Test
    public void defaultConstructor() {
        this.resolver = new ReflectiveExceptionResolver(DefaultConstructorException.class);
        RuntimeException result = this.resolver.getTargetException((Exception)new FooException("foo"));
        TestUtil.expectException(result, DefaultConstructorException.class, null, null);
    }

    @Test(expected=TranslationException.class)
    public void noSuitableConstructor() {
        this.resolver = new ReflectiveExceptionResolver(NoSuitableConstructorException.class);
        this.resolver.getTargetException((Exception)new FooException("foo"));
    }

    public static class NoSuitableConstructorException
    extends RuntimeException {
        public NoSuitableConstructorException(long l) {
        }
    }

    public static class DefaultConstructorException
    extends RuntimeException {
    }

    public static class ThrowableConstructorException
    extends RuntimeException {
        public ThrowableConstructorException(Throwable cause) {
            super(cause);
        }
    }

    private static class StringConstructorException
    extends RuntimeException {
        public StringConstructorException(String message) {
            super(message);
        }
    }
}

