/*
 * Decompiled with CFR 0.152.
 */
package com.mscharhag.et.impl;

import com.mscharhag.et.TargetExceptionResolver;
import com.mscharhag.et.TranslationException;
import com.mscharhag.et.impl.Arguments;
import java.util.HashMap;
import java.util.Map;

public class ExceptionMappings {
    protected ExceptionMappings parentExceptionMappings;
    protected Map<Class<? extends Exception>, TargetExceptionResolver> exceptionMappings = new HashMap<Class<? extends Exception>, TargetExceptionResolver>();

    private ExceptionMappings() {
    }

    ExceptionMappings(ExceptionMappings parentExceptionMappings) {
        this.parentExceptionMappings = parentExceptionMappings;
        if (this.parentExceptionMappings == null) {
            this.parentExceptionMappings = this.createDefaultParentExceptionMappings();
        }
    }

    protected ExceptionMappings createDefaultParentExceptionMappings() {
        ExceptionMappings parentMappings = new ExceptionMappings();
        parentMappings.addExceptionMapping(Exception.class, (m, ex) -> {
            if (ex instanceof RuntimeException) {
                RuntimeException rex = (RuntimeException)ex;
                return rex;
            }
            return new RuntimeException(ex.getMessage(), ex);
        });
        return parentMappings;
    }

    void addExceptionMapping(Class<? extends Exception> sourceClass, TargetExceptionResolver targetExceptionResolver) {
        Arguments.ensureNotNull(sourceClass, "source class cannot be null");
        Arguments.ensureNotNull(targetExceptionResolver, "targetExceptionResolver cannot be null");
        if (this.exceptionMappings.containsKey(sourceClass)) {
            throw new TranslationException("Duplicate exception mapping for source class " + sourceClass.getCanonicalName());
        }
        this.exceptionMappings.put(sourceClass, targetExceptionResolver);
    }

    TargetExceptionResolver getExceptionResolver(Class<? extends Exception> sourceExceptionClass) {
        Class<? extends Exception> exceptionClass = sourceExceptionClass;
        while (!exceptionClass.equals(Throwable.class)) {
            TargetExceptionResolver resolver = this.exceptionMappings.get(exceptionClass);
            if (resolver != null) {
                return resolver;
            }
            exceptionClass = exceptionClass.getSuperclass();
        }
        if (this.parentExceptionMappings != null) {
            return this.parentExceptionMappings.getExceptionResolver(sourceExceptionClass);
        }
        throw new TranslationException("No resolver for exception found, exception: " + sourceExceptionClass.getCanonicalName());
    }
}

