/*
 * Decompiled with CFR 0.152.
 */
package com.mscharhag.et.impl;

import com.mscharhag.et.ExceptionMappingConfigurer;
import com.mscharhag.et.TargetExceptionResolver;
import com.mscharhag.et.impl.DefaultExceptionTranslatorConfigurer;
import com.mscharhag.et.impl.ExceptionMappings;
import com.mscharhag.et.impl.ReflectiveExceptionResolver;
import java.util.List;

public class DefaultExceptionMappingConfigurer
implements ExceptionMappingConfigurer {
    private final ExceptionMappings exceptionMappings;
    private final List<Class<? extends Exception>> sourceExceptionClasses;

    public DefaultExceptionMappingConfigurer(ExceptionMappings exceptionMappings, List<Class<? extends Exception>> sourceExceptionClasses) {
        this.exceptionMappings = exceptionMappings;
        this.sourceExceptionClasses = sourceExceptionClasses;
    }

    @Override
    public DefaultExceptionTranslatorConfigurer to(Class<? extends RuntimeException> targetException) {
        return this.to(new ReflectiveExceptionResolver(targetException));
    }

    @Override
    public DefaultExceptionTranslatorConfigurer using(TargetExceptionResolver resolver) {
        return this.to(resolver);
    }

    private DefaultExceptionTranslatorConfigurer to(TargetExceptionResolver targetExceptionResolver) {
        for (Class<? extends Exception> sourceExceptionClass : this.sourceExceptionClasses) {
            this.exceptionMappings.addExceptionMapping(sourceExceptionClass, targetExceptionResolver);
        }
        return new DefaultExceptionTranslatorConfigurer(this.exceptionMappings);
    }
}

