/*
 * Decompiled with CFR 0.152.
 */
package com.mscharhag.et.impl;

import com.mscharhag.et.TargetExceptionResolver;
import com.mscharhag.et.TranslationException;
import com.mscharhag.et.impl.Arguments;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ReflectiveExceptionResolver
implements TargetExceptionResolver {
    private Class<? extends RuntimeException> targetExceptionClass;

    ReflectiveExceptionResolver(Class<? extends RuntimeException> targetExceptionClass) {
        Arguments.ensureNotNull(targetExceptionClass, "targetExceptionClass cannot be null");
        this.targetExceptionClass = targetExceptionClass;
    }

    @Override
    public RuntimeException getTargetException(String message, Exception sourceException) {
        List<ConstructorArgumentMapping> mappings = this.getConstructorMappings(sourceException);
        for (ConstructorArgumentMapping mapping : mappings) {
            for (Constructor<?> constructor : this.targetExceptionClass.getConstructors()) {
                if (!mapping.matches(constructor)) continue;
                try {
                    return (RuntimeException)constructor.newInstance(mapping.getArguments());
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new TranslationException("Unable to instantiate target exception of type " + this.targetExceptionClass.getCanonicalName(), e);
                }
            }
        }
        throw new TranslationException("No valid constructor found for target exception of type " + this.targetExceptionClass.getCanonicalName(), sourceException);
    }

    protected List<ConstructorArgumentMapping> getConstructorMappings(Exception source) {
        ArrayList<ConstructorArgumentMapping> mappings = new ArrayList<ConstructorArgumentMapping>();
        mappings.add(new ConstructorArgumentMapping(String.class, Throwable.class).arguments(source.getMessage(), source));
        mappings.add(new ConstructorArgumentMapping(String.class, Exception.class).arguments(source.getMessage(), source));
        if (source instanceof RuntimeException) {
            mappings.add(new ConstructorArgumentMapping(String.class, RuntimeException.class).arguments(source.getMessage(), source));
        }
        mappings.add(new ConstructorArgumentMapping(Throwable.class).arguments(source));
        mappings.add(new ConstructorArgumentMapping(Exception.class).arguments(source));
        if (source instanceof RuntimeException) {
            mappings.add(new ConstructorArgumentMapping(RuntimeException.class).arguments(source));
        }
        mappings.add(new ConstructorArgumentMapping(String.class).arguments(source.getMessage()));
        mappings.add(new ConstructorArgumentMapping(new Class[0]));
        return mappings;
    }

    private static class ConstructorArgumentMapping {
        private Class<?>[] types;
        private Object[] arguments;

        ConstructorArgumentMapping(Class<?> ... types) {
            this.types = types;
        }

        public ConstructorArgumentMapping arguments(Object ... arguments) {
            Arguments.ensureTrue(this.types.length == arguments.length, "length of arguments has to be " + this.types.length);
            this.arguments = arguments;
            return this;
        }

        public boolean matches(Constructor<?> constructor) {
            return Arrays.equals(constructor.getParameterTypes(), this.types);
        }

        public Object[] getArguments() {
            return this.arguments;
        }
    }
}

