/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.dataconversion;

import java.io.Reader;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.intermine.bio.dataconversion.BioFileConverter;
import org.intermine.dataconversion.ItemWriter;
import org.intermine.metadata.Model;
import org.intermine.util.FormattedTextParser;
import org.intermine.xml.full.Item;

public class WormBaseIdentifiersConverter
extends BioFileConverter {
    protected Item worm;
    private static final String HEADER_LINE = "Gene WB ID";

    public WormBaseIdentifiersConverter(ItemWriter writer, Model model) {
        super(writer, model, "WormBase", "WormBase gene identifiers");
    }

    public void process(Reader reader) throws Exception {
        Iterator lineIter = FormattedTextParser.parseTabDelimitedReader((Reader)reader);
        while (lineIter.hasNext()) {
            String[] line = (String[])lineIter.next();
            if (line.length < 3 || line[0].startsWith("#") || line[0].startsWith(HEADER_LINE)) continue;
            String primaryidentifier = line[0];
            String symbol = line[1];
            String identifier = line[2];
            Item gene = this.createItem("Gene");
            if (!StringUtils.isEmpty((String)primaryidentifier)) {
                gene.setAttribute("primaryIdentifier", primaryidentifier);
            }
            if (!StringUtils.isEmpty((String)symbol)) {
                gene.setAttribute("symbol", symbol);
                gene.setAttribute("name", symbol);
            }
            if (!StringUtils.isEmpty((String)identifier)) {
                gene.setAttribute("secondaryIdentifier", identifier);
            }
            gene.setReference("organism", this.getOrganism("6239"));
            this.store(gene);
        }
    }
}

