/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.model.bio;

import java.util.HashSet;
import java.util.Set;
import org.intermine.metadata.TypeUtil;
import org.intermine.model.InterMineObject;
import org.intermine.model.ShadowClass;
import org.intermine.model.StringConstructor;
import org.intermine.model.bio.BioEntity;
import org.intermine.model.bio.CrossReference;
import org.intermine.model.bio.DataSet;
import org.intermine.model.bio.Location;
import org.intermine.model.bio.OntologyAnnotation;
import org.intermine.model.bio.Organism;
import org.intermine.model.bio.Publication;
import org.intermine.model.bio.Synonym;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.intermine.NotXmlParser;
import org.intermine.objectstore.intermine.NotXmlRenderer;
import org.intermine.objectstore.proxy.ProxyCollection;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.util.DynamicUtil;

public class BioEntityShadow
implements BioEntity,
ShadowClass {
    public static final Class<BioEntity> shadowOf = BioEntity.class;
    protected String symbol;
    protected String name;
    protected String secondaryIdentifier;
    protected InterMineObject organism;
    protected Set<Location> locatedFeatures = new HashSet<Location>();
    protected Set<Location> locations = new HashSet<Location>();
    protected Set<Synonym> synonyms = new HashSet<Synonym>();
    protected Set<DataSet> dataSets = new HashSet<DataSet>();
    protected Set<CrossReference> crossReferences = new HashSet<CrossReference>();
    protected String primaryIdentifier;
    protected Set<OntologyAnnotation> ontologyAnnotations = new HashSet<OntologyAnnotation>();
    protected Set<Publication> publications = new HashSet<Publication>();
    protected Integer id;

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSecondaryIdentifier() {
        return this.secondaryIdentifier;
    }

    @Override
    public void setSecondaryIdentifier(String secondaryIdentifier) {
        this.secondaryIdentifier = secondaryIdentifier;
    }

    @Override
    public Organism getOrganism() {
        if (this.organism instanceof ProxyReference) {
            return (Organism)((ProxyReference)this.organism).getObject();
        }
        return (Organism)this.organism;
    }

    @Override
    public void setOrganism(Organism organism) {
        this.organism = organism;
    }

    @Override
    public void proxyOrganism(ProxyReference organism) {
        this.organism = organism;
    }

    @Override
    public InterMineObject proxGetOrganism() {
        return this.organism;
    }

    @Override
    public Set<Location> getLocatedFeatures() {
        return this.locatedFeatures;
    }

    @Override
    public void setLocatedFeatures(Set<Location> locatedFeatures) {
        this.locatedFeatures = locatedFeatures;
    }

    @Override
    public void addLocatedFeatures(Location arg) {
        this.locatedFeatures.add(arg);
    }

    @Override
    public Set<Location> getLocations() {
        return this.locations;
    }

    @Override
    public void setLocations(Set<Location> locations) {
        this.locations = locations;
    }

    @Override
    public void addLocations(Location arg) {
        this.locations.add(arg);
    }

    @Override
    public Set<Synonym> getSynonyms() {
        return this.synonyms;
    }

    @Override
    public void setSynonyms(Set<Synonym> synonyms) {
        this.synonyms = synonyms;
    }

    @Override
    public void addSynonyms(Synonym arg) {
        this.synonyms.add(arg);
    }

    @Override
    public Set<DataSet> getDataSets() {
        return this.dataSets;
    }

    @Override
    public void setDataSets(Set<DataSet> dataSets) {
        this.dataSets = dataSets;
    }

    @Override
    public void addDataSets(DataSet arg) {
        this.dataSets.add(arg);
    }

    @Override
    public Set<CrossReference> getCrossReferences() {
        return this.crossReferences;
    }

    @Override
    public void setCrossReferences(Set<CrossReference> crossReferences) {
        this.crossReferences = crossReferences;
    }

    @Override
    public void addCrossReferences(CrossReference arg) {
        this.crossReferences.add(arg);
    }

    @Override
    public String getPrimaryIdentifier() {
        return this.primaryIdentifier;
    }

    @Override
    public void setPrimaryIdentifier(String primaryIdentifier) {
        this.primaryIdentifier = primaryIdentifier;
    }

    @Override
    public Set<OntologyAnnotation> getOntologyAnnotations() {
        return this.ontologyAnnotations;
    }

    @Override
    public void setOntologyAnnotations(Set<OntologyAnnotation> ontologyAnnotations) {
        this.ontologyAnnotations = ontologyAnnotations;
    }

    @Override
    public void addOntologyAnnotations(OntologyAnnotation arg) {
        this.ontologyAnnotations.add(arg);
    }

    @Override
    public Set<Publication> getPublications() {
        return this.publications;
    }

    @Override
    public void setPublications(Set<Publication> publications) {
        this.publications = publications;
    }

    @Override
    public void addPublications(Publication arg) {
        this.publications.add(arg);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        return o instanceof BioEntity && this.id != null ? this.id.equals(((BioEntity)o).getId()) : this == o;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    public String toString() {
        return "BioEntity [id=" + this.id + ", name=" + (this.name == null ? "null" : "\"" + this.name + "\"") + ", organism=" + (this.organism == null ? "null" : (this.organism.getId() == null ? "no id" : this.organism.getId().toString())) + ", primaryIdentifier=" + (this.primaryIdentifier == null ? "null" : "\"" + this.primaryIdentifier + "\"") + ", secondaryIdentifier=" + (this.secondaryIdentifier == null ? "null" : "\"" + this.secondaryIdentifier + "\"") + ", symbol=" + (this.symbol == null ? "null" : "\"" + this.symbol + "\"") + "]";
    }

    public Object getFieldValue(String fieldName) throws IllegalAccessException {
        if ("symbol".equals(fieldName)) {
            return this.symbol;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("secondaryIdentifier".equals(fieldName)) {
            return this.secondaryIdentifier;
        }
        if ("organism".equals(fieldName)) {
            if (this.organism instanceof ProxyReference) {
                return ((ProxyReference)this.organism).getObject();
            }
            return this.organism;
        }
        if ("locatedFeatures".equals(fieldName)) {
            return this.locatedFeatures;
        }
        if ("locations".equals(fieldName)) {
            return this.locations;
        }
        if ("synonyms".equals(fieldName)) {
            return this.synonyms;
        }
        if ("dataSets".equals(fieldName)) {
            return this.dataSets;
        }
        if ("crossReferences".equals(fieldName)) {
            return this.crossReferences;
        }
        if ("primaryIdentifier".equals(fieldName)) {
            return this.primaryIdentifier;
        }
        if ("ontologyAnnotations".equals(fieldName)) {
            return this.ontologyAnnotations;
        }
        if ("publications".equals(fieldName)) {
            return this.publications;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if (!BioEntity.class.equals(this.getClass())) {
            return TypeUtil.getFieldValue((Object)this, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }

    public Object getFieldProxy(String fieldName) throws IllegalAccessException {
        if ("symbol".equals(fieldName)) {
            return this.symbol;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("secondaryIdentifier".equals(fieldName)) {
            return this.secondaryIdentifier;
        }
        if ("organism".equals(fieldName)) {
            return this.organism;
        }
        if ("locatedFeatures".equals(fieldName)) {
            return this.locatedFeatures;
        }
        if ("locations".equals(fieldName)) {
            return this.locations;
        }
        if ("synonyms".equals(fieldName)) {
            return this.synonyms;
        }
        if ("dataSets".equals(fieldName)) {
            return this.dataSets;
        }
        if ("crossReferences".equals(fieldName)) {
            return this.crossReferences;
        }
        if ("primaryIdentifier".equals(fieldName)) {
            return this.primaryIdentifier;
        }
        if ("ontologyAnnotations".equals(fieldName)) {
            return this.ontologyAnnotations;
        }
        if ("publications".equals(fieldName)) {
            return this.publications;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if (!BioEntity.class.equals(this.getClass())) {
            return TypeUtil.getFieldProxy((Object)this, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }

    public void setFieldValue(String fieldName, Object value) {
        if ("symbol".equals(fieldName)) {
            this.symbol = (String)value;
        } else if ("name".equals(fieldName)) {
            this.name = (String)value;
        } else if ("secondaryIdentifier".equals(fieldName)) {
            this.secondaryIdentifier = (String)value;
        } else if ("organism".equals(fieldName)) {
            this.organism = (InterMineObject)value;
        } else if ("locatedFeatures".equals(fieldName)) {
            this.locatedFeatures = (Set)value;
        } else if ("locations".equals(fieldName)) {
            this.locations = (Set)value;
        } else if ("synonyms".equals(fieldName)) {
            this.synonyms = (Set)value;
        } else if ("dataSets".equals(fieldName)) {
            this.dataSets = (Set)value;
        } else if ("crossReferences".equals(fieldName)) {
            this.crossReferences = (Set)value;
        } else if ("primaryIdentifier".equals(fieldName)) {
            this.primaryIdentifier = (String)value;
        } else if ("ontologyAnnotations".equals(fieldName)) {
            this.ontologyAnnotations = (Set)value;
        } else if ("publications".equals(fieldName)) {
            this.publications = (Set)value;
        } else if ("id".equals(fieldName)) {
            this.id = (Integer)value;
        } else {
            if (!BioEntity.class.equals(this.getClass())) {
                DynamicUtil.setFieldValue((Object)this, (String)fieldName, (Object)value);
                return;
            }
            throw new IllegalArgumentException("Unknown field " + fieldName);
        }
    }

    public Class<?> getFieldType(String fieldName) {
        if ("symbol".equals(fieldName)) {
            return String.class;
        }
        if ("name".equals(fieldName)) {
            return String.class;
        }
        if ("secondaryIdentifier".equals(fieldName)) {
            return String.class;
        }
        if ("organism".equals(fieldName)) {
            return Organism.class;
        }
        if ("locatedFeatures".equals(fieldName)) {
            return Set.class;
        }
        if ("locations".equals(fieldName)) {
            return Set.class;
        }
        if ("synonyms".equals(fieldName)) {
            return Set.class;
        }
        if ("dataSets".equals(fieldName)) {
            return Set.class;
        }
        if ("crossReferences".equals(fieldName)) {
            return Set.class;
        }
        if ("primaryIdentifier".equals(fieldName)) {
            return String.class;
        }
        if ("ontologyAnnotations".equals(fieldName)) {
            return Set.class;
        }
        if ("publications".equals(fieldName)) {
            return Set.class;
        }
        if ("id".equals(fieldName)) {
            return Integer.class;
        }
        if (!BioEntity.class.equals(this.getClass())) {
            return TypeUtil.getFieldType(BioEntity.class, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }

    public StringConstructor getoBJECT() {
        int delimPosition;
        String string;
        if (!BioEntityShadow.class.equals(this.getClass())) {
            return NotXmlRenderer.render((Object)this);
        }
        StringConstructor sb = new StringConstructor();
        sb.append("$_^org.intermine.model.bio.BioEntity");
        if (this.symbol != null) {
            sb.append("$_^asymbol$_^");
            string = this.symbol;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.name != null) {
            sb.append("$_^aname$_^");
            string = this.name;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.secondaryIdentifier != null) {
            sb.append("$_^asecondaryIdentifier$_^");
            string = this.secondaryIdentifier;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.organism != null) {
            sb.append("$_^rorganism$_^").append((Object)this.organism.getId());
        }
        if (this.primaryIdentifier != null) {
            sb.append("$_^aprimaryIdentifier$_^");
            string = this.primaryIdentifier;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.id != null) {
            sb.append("$_^aid$_^").append((Object)this.id);
        }
        return sb;
    }

    public void setoBJECT(String notXml, ObjectStore os) {
        this.setoBJECT(NotXmlParser.SPLITTER.split(notXml), os);
    }

    public void setoBJECT(String[] notXml, ObjectStore os) {
        if (!BioEntityShadow.class.equals(this.getClass())) {
            throw new IllegalStateException("Class " + this.getClass().getName() + " does not match code (org.intermine.model.bio.BioEntity)");
        }
        int i = 2;
        while (i < notXml.length) {
            StringBuilder string;
            int startI = i;
            if (i < notXml.length && "asymbol".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.symbol = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "aname".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.name = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "asecondaryIdentifier".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.secondaryIdentifier = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "rorganism".equals(notXml[i])) {
                this.organism = new ProxyReference(os, Integer.valueOf(notXml[++i]), Organism.class);
                ++i;
            }
            if (i < notXml.length && "aprimaryIdentifier".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.primaryIdentifier = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "aid".equals(notXml[i])) {
                this.id = Integer.valueOf(notXml[++i]);
                ++i;
            }
            if (startI != i) continue;
            throw new IllegalArgumentException("Unknown field " + notXml[i]);
        }
        this.locatedFeatures = new ProxyCollection(os, (InterMineObject)this, "locatedFeatures", Location.class);
        this.locations = new ProxyCollection(os, (InterMineObject)this, "locations", Location.class);
        this.synonyms = new ProxyCollection(os, (InterMineObject)this, "synonyms", Synonym.class);
        this.dataSets = new ProxyCollection(os, (InterMineObject)this, "dataSets", DataSet.class);
        this.crossReferences = new ProxyCollection(os, (InterMineObject)this, "crossReferences", CrossReference.class);
        this.ontologyAnnotations = new ProxyCollection(os, (InterMineObject)this, "ontologyAnnotations", OntologyAnnotation.class);
        this.publications = new ProxyCollection(os, (InterMineObject)this, "publications", Publication.class);
    }

    public void addCollectionElement(String fieldName, InterMineObject element) {
        if ("locatedFeatures".equals(fieldName)) {
            this.locatedFeatures.add((Location)element);
        } else if ("locations".equals(fieldName)) {
            this.locations.add((Location)element);
        } else if ("synonyms".equals(fieldName)) {
            this.synonyms.add((Synonym)element);
        } else if ("dataSets".equals(fieldName)) {
            this.dataSets.add((DataSet)element);
        } else if ("crossReferences".equals(fieldName)) {
            this.crossReferences.add((CrossReference)element);
        } else if ("ontologyAnnotations".equals(fieldName)) {
            this.ontologyAnnotations.add((OntologyAnnotation)element);
        } else if ("publications".equals(fieldName)) {
            this.publications.add((Publication)element);
        } else {
            if (!BioEntity.class.equals(this.getClass())) {
                TypeUtil.addCollectionElement((Object)this, (String)fieldName, (Object)element);
                return;
            }
            throw new IllegalArgumentException("Unknown collection " + fieldName);
        }
    }

    public Class<?> getElementType(String fieldName) {
        if ("locatedFeatures".equals(fieldName)) {
            return Location.class;
        }
        if ("locations".equals(fieldName)) {
            return Location.class;
        }
        if ("synonyms".equals(fieldName)) {
            return Synonym.class;
        }
        if ("dataSets".equals(fieldName)) {
            return DataSet.class;
        }
        if ("crossReferences".equals(fieldName)) {
            return CrossReference.class;
        }
        if ("ontologyAnnotations".equals(fieldName)) {
            return OntologyAnnotation.class;
        }
        if ("publications".equals(fieldName)) {
            return Publication.class;
        }
        if (!BioEntity.class.equals(this.getClass())) {
            return TypeUtil.getElementType(BioEntity.class, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
}

