/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.text.MessageFormat;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.intermine.util.MailUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class MailUtils {
    private MailUtils() {
    }

    public static void welcome(String to, Properties webProperties) throws MessagingException {
        String subject = webProperties.getProperty("mail.subject");
        String text = webProperties.getProperty("mail.text");
        MailUtils.email((String)to, (String)subject, (String)text, (Properties)webProperties);
    }

    public static void email(String to, String subject, String body, String from, Properties webProperties) throws MessagingException {
        Session session;
        String user = webProperties.getProperty("mail.smtp.user");
        String smtpPort = webProperties.getProperty("mail.smtp.port");
        String authFlag = webProperties.getProperty("mail.smtp.auth");
        String starttlsFlag = webProperties.getProperty("mail.smtp.starttls.enable");
        Properties properties = System.getProperties();
        properties.put("mail.smtp.host", webProperties.get("mail.host"));
        properties.put("mail.smtp.user", user);
        properties.put("mail.smtp.localhost", "localhost");
        if (smtpPort != null) {
            properties.put("mail.smtp.port", smtpPort);
        }
        if (starttlsFlag != null) {
            properties.put("mail.smtp.starttls.enable", starttlsFlag);
        }
        if (authFlag != null) {
            properties.put("mail.smtp.auth", authFlag);
        }
        if (authFlag != null && ("true".equals(authFlag) || "t".equals(authFlag))) {
            1 authenticator = new /* Unavailable Anonymous Inner Class!! */;
            session = Session.getInstance((Properties)properties, (Authenticator)authenticator);
        } else {
            session = Session.getInstance((Properties)properties);
        }
        MimeMessage message = new MimeMessage(session);
        if (StringUtils.isEmpty((String)user)) {
            message.setFrom((Address)new InternetAddress(from));
        } else {
            if (from != null) {
                message.setReplyTo((Address[])InternetAddress.parse((String)from, (boolean)true));
            }
            message.setFrom((Address)new InternetAddress(user));
        }
        message.addRecipient(Message.RecipientType.TO, (Address)InternetAddress.parse((String)to, (boolean)true)[0]);
        message.setSubject(subject);
        message.setContent((Object)body, "text/plain");
        Transport.send((Message)message);
    }

    public static void email(String to, String subject, String body, Properties webProperties) throws MessagingException {
        String from = (String)webProperties.get("mail.from");
        MailUtils.email((String)to, (String)subject, (String)body, (String)from, (Properties)webProperties);
    }

    public static void emailPasswordToken(String to, String url, Properties webProperties) throws Exception {
        String projectTitle = (String)webProperties.get("project.title");
        String baseSubject = (String)webProperties.get("mail.passwordSubject");
        String mailSubject = MessageFormat.format(baseSubject, projectTitle);
        String mailText = (String)webProperties.get("mail.passwordText");
        String mailTextWithUrl = MessageFormat.format(mailText, url);
        MailUtils.email((String)to, (String)mailSubject, (String)mailTextWithUrl, (Properties)webProperties);
    }

    public static void subscribe(String email, Properties webProperties) throws MessagingException {
        String to = (String)webProperties.get("mail.mailing-list");
        String subject = "";
        String body = "";
        MailUtils.email((String)to, (String)subject, (String)body, (String)email, (Properties)webProperties);
    }
}

