/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.autocompletion;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

final class PropertiesManager {
    private static final Logger LOG = Logger.getLogger(PropertiesManager.class);
    private static PropertiesManager propertiesManager;
    private static final String CONFIG_FILE_NAME = "objectstoresummary.config.properties";
    private Properties properties = null;
    private HashMap<String, String> classFieldMap = new HashMap();
    private String solrUrl;

    private PropertiesManager() {
        this.parseProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PropertiesManager getInstance() {
        if (propertiesManager != null) return propertiesManager;
        Class<PropertiesManager> clazz = PropertiesManager.class;
        synchronized (PropertiesManager.class) {
            if (propertiesManager != null) return propertiesManager;
            propertiesManager = new PropertiesManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return propertiesManager;
        }
    }

    private synchronized void parseProperties() {
        if (this.properties != null) {
            return;
        }
        String configFileName = CONFIG_FILE_NAME;
        ClassLoader classLoader = PropertiesManager.class.getClassLoader();
        InputStream configStream = classLoader.getResourceAsStream(configFileName);
        if (configStream != null) {
            this.properties = new Properties();
            try {
                this.properties.load(configStream);
                for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (key.endsWith(".autocomplete")) {
                        String className = key.substring(0, key.lastIndexOf("."));
                        this.classFieldMap.put(className, value);
                        continue;
                    }
                    if (!"autocomplete.solrurl".equals(key) || StringUtils.isBlank((String)value)) continue;
                    this.solrUrl = value;
                }
            }
            catch (IOException e) {
                LOG.error((Object)("keyword_search.properties: errow while loading file '" + configFileName + "'"), (Throwable)e);
            }
        } else {
            LOG.error((Object)("objectstore_summary.properties: file '" + configFileName + "' not found!"));
        }
    }

    HashMap<String, String> getClassFieldMap() {
        return this.classFieldMap;
    }

    String getSolrUrl() {
        return this.solrUrl;
    }
}

