/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.context;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.intermine.util.Emailer;
import org.intermine.web.context.MailAction;

public final class MailDaemon
implements Runnable {
    private static final Logger LOG = Logger.getLogger(MailDaemon.class);
    private final ArrayBlockingQueue<MailAction> mailQueue;
    private final Emailer emailer;

    public MailDaemon(ArrayBlockingQueue<MailAction> mailQueue, Emailer emailer) {
        this.mailQueue = mailQueue;
        this.emailer = emailer;
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                MailAction nextAction = (MailAction)this.mailQueue.poll(1L, TimeUnit.SECONDS);
                if (nextAction == null) continue;
                nextAction.act(this.emailer);
                continue;
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Could not send email", (Throwable)e);
                continue;
            }
            break;
        }
        return;
    }
}

