/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.displayer;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.web.displayer.ReportDisplayerNoResultsException;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;

public abstract class ReportDisplayer {
    protected ReportDisplayerConfig config;
    protected InterMineAPI im;
    private static final Logger LOG = Logger.getLogger(ReportDisplayer.class);

    public ReportDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        this.config = config;
        this.im = im;
    }

    public void execute(HttpServletRequest request, ReportObject reportObject) {
        block3: {
            request.setAttribute("reportObject", (Object)reportObject);
            request.setAttribute("jspPage", (Object)this.getJspPage());
            try {
                this.display(request, reportObject);
            }
            catch (ReportDisplayerNoResultsException e) {
                request.setAttribute("displayerName", (Object)this.getClass().getSimpleName());
                request.setAttribute("jspPage", (Object)"reportDisplayerNoResults.jsp");
            }
            catch (Exception e) {
                LOG.error((Object)("Error rendering report displayer " + this.getClass() + " for " + reportObject.getType() + "(" + reportObject.getId() + "): " + ExceptionUtils.getFullStackTrace((Throwable)e)));
                request.setAttribute("displayerName", (Object)this.getClass().getSimpleName());
                request.setAttribute("jspPage", (Object)"reportDisplayerError.jsp");
                Profile profile = SessionMethods.getProfile((HttpSession)request.getSession());
                if (!profile.isSuperuser()) break block3;
                request.setAttribute("exception", (Object)ExceptionUtils.getStackTrace((Throwable)ExceptionUtils.getRootCause((Throwable)e)));
            }
        }
    }

    public abstract void display(HttpServletRequest var1, ReportObject var2) throws ReportDisplayerNoResultsException;

    public Boolean getShowImmediately() {
        return this.config.getShowImmediately();
    }

    public String getJspPage() {
        return this.config.getJspName();
    }

    public Set<String> getReplacedFieldExprs() {
        return this.config.getReplacedFieldNames();
    }

    public String getDisplayerName() {
        return this.getClass().getSimpleName();
    }

    public String getNicerDisplayerName() {
        String name = "";
        for (String w : this.getDisplayerName().split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])")) {
            name = name + w + " ";
        }
        return name.trim();
    }
}

