/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.bag;

import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.intermine.InterMineException;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.TypeConverter;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.template.ApiTemplate;
import org.intermine.metadata.Model;
import org.intermine.metadata.TypeUtil;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.pathqueryresult.PathQueryResultHelper;
import org.intermine.web.logic.session.SessionMethods;

public final class BagConversionHelper {
    private BagConversionHelper() {
    }

    public static PathQuery getConvertedObjects(HttpSession session, List<ApiTemplate> conversionTemplates, Class<? extends InterMineObject> typeA, Class<? extends InterMineObject> typeB, InterMineBag imBag) throws InterMineException, ObjectStoreException {
        String convertFrom;
        ServletContext servletContext = session.getServletContext();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        PathQuery pq = TypeConverter.getConversionQuery(conversionTemplates, typeA, typeB, (Object)imBag);
        if (pq == null) {
            return null;
        }
        try {
            Path convertFromPath = pq.makePath((String)pq.getView().get(0));
            convertFrom = convertFromPath.getPrefix().getNoConstraintsString();
        }
        catch (PathException e) {
            throw new RuntimeException("Invalid path in bag conversion query: " + (String)pq.getView().get(0), e);
        }
        WebConfig webConfig = SessionMethods.getWebConfig((ServletContext)servletContext);
        Model model = im.getModel();
        String typeBStr = TypeUtil.unqualifiedName((String)typeB.getName());
        pq.addViews((Collection)PathQueryResultHelper.getDefaultViewForClass((String)typeBStr, (Model)model, (WebConfig)webConfig, (String)convertFrom));
        List views = pq.getView();
        for (String viewPath : views) {
            if (!viewPath.endsWith(".id")) continue;
            pq.removeView(viewPath);
        }
        return pq;
    }
}

