/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathException;
import org.intermine.web.logic.config.Displayer;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.HeaderConfigLink;
import org.intermine.web.logic.config.HeaderConfigTitle;
import org.intermine.web.logic.config.InlineListConfig;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.config.TableExportConfig;
import org.intermine.web.logic.config.Type;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.logic.widget.config.EnrichmentWidgetConfig;
import org.intermine.web.logic.widget.config.GraphWidgetConfig;
import org.intermine.web.logic.widget.config.HTMLWidgetConfig;
import org.intermine.web.logic.widget.config.TableWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebConfig {
    private static final Logger LOG = Logger.getLogger(WebConfig.class);
    private final Map<String, Type> types = new TreeMap();
    private final Map<String, TableExportConfig> tableExportConfigs = new TreeMap();
    private final Map<String, WidgetConfig> widgets = new HashMap();
    private final List<ReportDisplayerConfig> reportDisplayerConfigs = new ArrayList();

    public static WebConfig parse(ServletContext context, Model model) throws IOException, SAXException, ClassNotFoundException {
        BasicConfigurator.configure();
        InputStream webconfXML = context.getResourceAsStream("/WEB-INF/webconfig-model.xml");
        if (webconfXML == null) {
            throw new FileNotFoundException("Could not find webconfig-model.xml");
        }
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("webconfig", WebConfig.class);
        digester.addObjectCreate("webconfig/class", Type.class);
        digester.addSetProperties("webconfig/class", "className", "className");
        digester.addSetProperties("webconfig/class", "fieldName", "fieldName");
        digester.addObjectCreate("webconfig/class/headerconfig/titles", HeaderConfigTitle.class);
        digester.addSetProperties("webconfig/class/headerconfig/titles/title", "mainTitles", "mainTitles");
        digester.addSetProperties("webconfig/class/headerconfig/titles/title", "subTitles", "subTitles");
        digester.addSetProperties("webconfig/class/headerconfig/titles/title", "numberOfMainTitlesToShow", "numberOfMainTitlesToShow");
        digester.addSetProperties("webconfig/class/headerconfig/titles/title", "appendConfig", "appendConfig");
        digester.addSetNext("webconfig/class/headerconfig/titles", "addHeaderConfigTitle");
        digester.addObjectCreate("webconfig/class/headerconfig/customlinks", HeaderConfigLink.class);
        digester.addSetProperties("webconfig/class/headerconfig/customlinks/customlink", "url", "url");
        digester.addSetProperties("webconfig/class/headerconfig/customlinks/customlink", "text", "text");
        digester.addSetProperties("webconfig/class/headerconfig/customlinks/customlink", "image", "image");
        digester.addSetNext("webconfig/class/headerconfig/customlinks", "addHeaderConfigLink");
        digester.addObjectCreate("webconfig/class/tabledisplayer", Displayer.class);
        digester.addSetProperties("webconfig/class/tabledisplayer", "src", "src");
        digester.addSetNext("webconfig/class/tabledisplayer", "setTableDisplayer");
        digester.addCallMethod("webconfig/class/tabledisplayer/param", "addParam", 2);
        digester.addCallParam("webconfig/class/tabledisplayer/param", 0, "name");
        digester.addCallParam("webconfig/class/tabledisplayer/param", 1, "value");
        digester.addObjectCreate("webconfig/class/fields/fieldconfig", FieldConfig.class);
        digester.addSetProperties("webconfig/class/fields/fieldconfig", "fieldExpr", "fieldExpr");
        digester.addSetProperties("webconfig/class/fields/fieldconfig", "name", "name");
        digester.addSetProperties("webconfig/class/fields/fieldconfig", "displayer", "displayer");
        digester.addSetProperties("webconfig/class/fields/fieldconfig", "showInQB", "showInQB");
        digester.addSetProperties("webconfig/class/fields/fieldconfig", "showInListAnalysisPreviewTable", "showInListAnalysisPreviewTable");
        digester.addSetNext("webconfig/class/fields/fieldconfig", "addFieldConfig");
        digester.addObjectCreate("webconfig/class/longdisplayers/displayer", Displayer.class);
        digester.addSetProperties("webconfig/class/longdisplayers/displayer");
        digester.addSetNext("webconfig/class/longdisplayers/displayer", "addLongDisplayer");
        digester.addCallMethod("webconfig/class/longdisplayers/displayer/param", "addParam", 2);
        digester.addCallParam("webconfig/class/longdisplayers/displayer/param", 0, "name");
        digester.addCallParam("webconfig/class/longdisplayers/displayer/param", 1, "value");
        digester.addObjectCreate("webconfig/class/inlinelist/table", InlineListConfig.class);
        digester.addSetProperties("webconfig/class/inlinelist/table");
        digester.addSetNext("webconfig/class/inlinelist/table", "addInlineList");
        digester.addSetProperties("webconfig/class/inlinelist/table", "path", "path");
        digester.addSetProperties("webconfig/class/inlinelist/table", "showLinksToObjects", "showLinksToObjects");
        digester.addSetProperties("webconfig/class/inlinelist/table", "showInHeader", "showInHeader");
        digester.addSetProperties("webconfig/class/inlinelist/table", "lineLength", "lineLength");
        digester.addObjectCreate("webconfig/class/bagdisplayers/displayer", Displayer.class);
        digester.addSetProperties("webconfig/class/bagdisplayers/displayer");
        digester.addSetNext("webconfig/class/bagdisplayers/displayer", "addBagDisplayer");
        digester.addCallMethod("webconfig/class/bagdisplayers/displayer/param", "addParam", 2);
        digester.addCallParam("webconfig/class/bagdisplayers/displayer/param", 0, "name");
        digester.addCallParam("webconfig/class/bagdisplayers/displayer/param", 1, "value");
        digester.addObjectCreate("webconfig/widgets/graphdisplayer", GraphWidgetConfig.class);
        digester.addSetProperties("webconfig/widgets/graphdisplayer");
        digester.addSetNext("webconfig/widgets/graphdisplayer", "addWidget");
        digester.addObjectCreate("webconfig/widgets/enrichmentwidgetdisplayer", EnrichmentWidgetConfig.class);
        digester.addSetProperties("webconfig/widgets/enrichmentwidgetdisplayer");
        digester.addSetNext("webconfig/widgets/enrichmentwidgetdisplayer", "addWidget");
        digester.addObjectCreate("webconfig/widgets/bagtabledisplayer", TableWidgetConfig.class);
        digester.addSetProperties("webconfig/widgets/bagtabledisplayer");
        digester.addSetNext("webconfig/widgets/bagtabledisplayer", "addWidget");
        digester.addObjectCreate("webconfig/widgets/htmldisplayer", HTMLWidgetConfig.class);
        digester.addSetProperties("webconfig/widgets/htmldisplayer");
        digester.addSetNext("webconfig/widgets/htmldisplayer", "addWidget");
        digester.addSetNext("webconfig/class", "addType");
        digester.addObjectCreate("webconfig/tableExportConfig", TableExportConfig.class);
        digester.addSetProperties("webconfig/tableExportConfig", "id", "id");
        digester.addSetProperties("webconfig/tableExportConfig", "className", "className");
        digester.addSetNext("webconfig/tableExportConfig", "addTableExportConfig");
        digester.addObjectCreate("webconfig/reportdisplayers/reportdisplayer", ReportDisplayerConfig.class);
        digester.addSetProperties("webconfig/reportdisplayers/reportdisplayer");
        digester.addSetNext("webconfig/reportdisplayers/reportdisplayer", "addReportDisplayer");
        WebConfig webConfig = (WebConfig)digester.parse(webconfXML);
        webConfig.validate(model);
        webConfig.setSubClassConfig(model);
        webConfig.loadLabelsFromMappingsFile(context, model);
        return webConfig;
    }

    private static List<String> getClassMappingFileNames(Properties props) {
        return WebConfig.getMappingFileNames((Properties)props, (String)"web.config.classname.mappings");
    }

    private static List<String> getFieldMappingFileNames(Properties props) {
        return WebConfig.getMappingFileNames((Properties)props, (String)"web.config.fieldname.mappings");
    }

    private static List<String> getMappingFileNames(Properties props, String prefix) {
        ArrayList<String> returnVal = new ArrayList<String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix)) continue;
            returnVal.add(props.getProperty(key));
        }
        return returnVal;
    }

    private static Properties loadMergedProperties(List<String> fileNames, ServletContext context) throws IOException {
        Properties props = new Properties();
        for (String fileName : fileNames) {
            LOG.info((Object)("Loading properties from " + fileName));
            Properties theseProps = new Properties();
            InputStream is = context.getResourceAsStream("/WEB-INF/" + fileName);
            if (is == null) {
                throw new FileNotFoundException("Could not find mappings file: " + fileName);
            }
            try {
                theseProps.load(is);
            }
            catch (IOException e) {
                throw new Error("Problem reading from " + fileName, e);
            }
            if (!props.isEmpty()) {
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!theseProps.containsKey(key)) continue;
                    throw new IllegalStateException("Duplicate label found for " + key + " in " + fileName);
                }
            }
            if (theseProps.isEmpty()) {
                LOG.info((Object)("No properties loaded from " + fileName));
                continue;
            }
            LOG.info((Object)("Merging in " + theseProps.size() + " mappings from " + fileName));
            props.putAll((Map<?, ?>)theseProps);
        }
        return props;
    }

    private void loadLabelsFromMappingsFile(ServletContext context, Model model) throws IOException {
        Properties webProperties = SessionMethods.getWebProperties((ServletContext)context);
        List classFileNames = WebConfig.getClassMappingFileNames((Properties)webProperties);
        List fieldFileNames = WebConfig.getFieldMappingFileNames((Properties)webProperties);
        Properties fieldNameProperties = WebConfig.loadMergedProperties((List)fieldFileNames, (ServletContext)context);
        Properties classNameProperties = WebConfig.loadMergedProperties((List)classFileNames, (ServletContext)context);
        for (ClassDescriptor cd : model.getClassDescriptors()) {
            this.labelClass(cd, classNameProperties, fieldNameProperties);
        }
    }

    private void labelClass(ClassDescriptor cd, Properties classNameProperties, Properties fieldNameProperties) {
        String originalName = cd.getUnqualifiedName();
        if ("InterMineObject".equals(originalName)) {
            return;
        }
        Type classConfig = (Type)this.getTypes().get(cd.getName());
        if (classConfig == null) {
            classConfig = new Type();
            classConfig.setClassName(cd.getName());
            this.addType(classConfig);
        }
        if (classNameProperties.containsKey(originalName)) {
            String classNameLabel = classNameProperties.getProperty(originalName);
            String label = WebConfig.deSlashify((String)classNameLabel);
            if (classConfig.getLabel() == null) {
                LOG.info((Object)("Setting label as " + label + " on " + originalName));
                classConfig.setLabel(label);
            }
        }
        for (FieldDescriptor fd : cd.getAllFieldDescriptors()) {
            if (!fieldNameProperties.containsKey(fd.getName())) continue;
            String fieldNameLabel = fieldNameProperties.getProperty(fd.getName());
            String label = WebConfig.deSlashify((String)fieldNameLabel);
            FieldConfig fc = (FieldConfig)classConfig.getFieldConfigMap().get(fd.getName());
            if (fc == null) {
                fc = new FieldConfig();
                fc.setFieldExpr(fd.getName());
                fc.setShowInSummary(false);
                fc.setShowInInlineCollection(false);
                fc.setShowInResults(false);
                fc.setShowInQB(true);
                classConfig.addFieldConfig(fc);
            }
            if (fc.getLabel() != null) continue;
            LOG.info((Object)("Setting label as " + label + " on " + fd.getName() + " in " + originalName));
            fc.setLabel(label);
        }
    }

    private static String deSlashify(String input) {
        String[] parts = StringUtils.split((String)input, (String)"_");
        Object[] outputParts = new String[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            outputParts[i] = part.equals(StringUtils.lowerCase((String)part)) ? StringUtils.capitalize((String)part) : part;
        }
        return StringUtils.join((Object[])outputParts, (String)" ");
    }

    void validate(Model model) {
        StringBuffer invalidClasses = new StringBuffer();
        StringBuffer badFieldExpressions = new StringBuffer();
        for (String typeName : this.types.keySet()) {
            if (!model.getClassNames().contains(typeName)) {
                invalidClasses.append(" " + typeName);
                continue;
            }
            Type type = (Type)this.types.get(typeName);
            for (FieldConfig fieldConfig : type.getFieldConfigs()) {
                String pathString;
                try {
                    pathString = Class.forName(typeName).getSimpleName() + "." + fieldConfig.getFieldExpr();
                }
                catch (ClassNotFoundException e) {
                    String msg = "Invalid web config. '" + typeName + "' doesn't exist in the model.";
                    LOG.warn((Object)msg);
                    continue;
                }
                try {
                    new Path(model, pathString);
                }
                catch (PathException e) {
                    badFieldExpressions.append(" " + pathString);
                }
            }
        }
        if (invalidClasses.length() > 0 || badFieldExpressions.length() > 0) {
            String msg = "Invalid web config. " + (invalidClasses.length() > 0 ? "Classes specified in web config that don't exist in model: " + invalidClasses.toString() + ". " : "") + (badFieldExpressions.length() > 0 ? "Path specified in a fieldExpr does note exist in model: " + badFieldExpressions + ". " : "");
            LOG.error((Object)msg);
        }
    }

    private Type getType(String simpleClassName) {
        for (String type : this.types.keySet()) {
            if (!type.endsWith("." + simpleClassName)) continue;
            return (Type)this.types.get(type);
        }
        return null;
    }

    public String validateWidgetsConfig(Model model) {
        WidgetConfig widget = null;
        StringBuffer validationMessage = new StringBuffer();
        for (String widgetId : this.widgets.keySet()) {
            String typeClass;
            String startClass;
            if (widgetId.contains(" ")) {
                validationMessage.append("The id for the widget " + widgetId + " contains spaces.");
            }
            if ((startClass = (widget = (WidgetConfig)this.widgets.get(widgetId)).getStartClass()) != null && !"".equals(startClass)) {
                startClass = model.getPackageName() + "." + widget.getStartClass();
                if (!model.getClassNames().contains(startClass)) {
                    validationMessage = validationMessage.append("The attribute startClass '" + startClass + "' for the widget " + widgetId + " is not in the model.");
                }
            }
            if ((typeClass = widget.getTypeClass()) != null && !"".equals(typeClass) && !model.getClassNames().contains(model.getPackageName() + "." + widget.getTypeClass())) {
                validationMessage = validationMessage.append("The attribute typeClass '" + typeClass + "' for the widget " + widgetId + " is not in the model.");
            }
            List pathConstraints = widget.getPathConstraints();
            for (PathConstraint pathConstraint : pathConstraints) {
                this.validateAttributePath(model, widget.getStartClass(), pathConstraint.getPath(), "constraints", widgetId, validationMessage);
            }
            String views = widget.getViews();
            String simpleStartClass = widget.getStartClass();
            if (views != null && !"".equals(views)) {
                String[] viewsBites = widget.getViews().split("\\s*,\\s*");
                if (widget instanceof TableWidgetConfig) {
                    simpleStartClass = typeClass.substring(typeClass.lastIndexOf(".") + 1);
                }
                for (String viewPath : viewsBites) {
                    this.validateAttributePath(model, simpleStartClass, viewPath, "views", widgetId, validationMessage);
                }
            }
            if (widget instanceof EnrichmentWidgetConfig) {
                String enrich = ((EnrichmentWidgetConfig)widget).getEnrich();
                this.validateAttributePath(model, widget.getStartClass(), enrich, "enrich", widgetId, validationMessage);
                String enrichId = ((EnrichmentWidgetConfig)widget).getEnrichIdentifier();
                if (enrichId != null) {
                    this.validateAttributePath(model, widget.getStartClass(), enrichId, "enrichIdentifier", widgetId, validationMessage);
                }
            }
            if (!(widget instanceof GraphWidgetConfig)) continue;
            String categoryPath = ((GraphWidgetConfig)widget).getCategoryPath();
            this.validateAttributePath(model, widget.getStartClass(), categoryPath, "categoryPath", widgetId, validationMessage);
            String seriesPath = ((GraphWidgetConfig)widget).getSeriesPath();
            if ("".equals(seriesPath) || "ActualExpectedCriteria".equals(seriesPath)) continue;
            this.validateAttributePath(model, widget.getStartClass(), seriesPath, "seriesPath", widgetId, validationMessage);
        }
        return validationMessage.toString();
    }

    private void validateAttributePath(Model model, String startClass, String pathToValidate, String label, String widgetId, StringBuffer validationMsg) {
        try {
            Path path = new Path(model, startClass + "." + pathToValidate);
            if (!path.endIsAttribute()) {
                validationMsg.append("The path " + pathToValidate + " set in " + label + " for the widget " + widgetId + " is not an attribute.");
            }
        }
        catch (PathException e) {
            validationMsg.append("The path " + pathToValidate + " set in " + label + " for the widget " + widgetId + " is not in the model.");
        }
    }

    public void addType(Type type) {
        String typeString = type.getClassName();
        if (this.types.containsKey(typeString)) {
            throw new IllegalArgumentException("Type " + typeString + " defined more than once in webconfig-model.xml");
        }
        this.types.put(type.getClassName(), type);
    }

    public Map<String, Type> getTypes() {
        return this.types;
    }

    public Collection<FieldConfig> getFieldConfigs(String clsName) {
        Type type = (Type)this.types.get(clsName);
        if (type != null) {
            return type.getFieldConfigs();
        }
        return Collections.emptyList();
    }

    public FieldConfig getFieldConfig(String clsName, String fieldName) {
        Type type = (Type)this.types.get(clsName);
        if (type != null) {
            return type.getFieldConfig(fieldName);
        }
        return null;
    }

    public Map<String, WidgetConfig> getWidgets() {
        return this.widgets;
    }

    public void addWidget(WidgetConfig widget) {
        if (!this.widgets.containsKey(widget.getId())) {
            String[] widgetTypes;
            this.widgets.put(widget.getId(), widget);
            for (String widgetType : widgetTypes = widget.getTypeClass().split(",")) {
                Type type = this.getType(widgetType);
                if (type == null) {
                    String msg = "Invalid web config. " + widgetType + " is not a valid class. Please correct the entry in the webconfig-model.xml for the " + widget.getId() + " widget.";
                    LOG.warn((Object)msg);
                    continue;
                }
                type.addWidget(widget);
            }
        }
    }

    public void addReportDisplayer(ReportDisplayerConfig reportDisplayerConfig) {
        Set displayForTypes = reportDisplayerConfig.getConfiguredTypes();
        if (displayForTypes.isEmpty()) {
            LOG.error((Object)("Report displayer: " + reportDisplayerConfig.getJavaClass() + "/" + reportDisplayerConfig.getJspName() + " is not configured for any types"));
        } else {
            this.reportDisplayerConfigs.add(reportDisplayerConfig);
        }
    }

    public List<ReportDisplayerConfig> getReportDisplayerConfigs() {
        return this.reportDisplayerConfigs;
    }

    public void addTableExportConfig(TableExportConfig tableExportConfig) {
        this.tableExportConfigs.put(tableExportConfig.getId(), tableExportConfig);
    }

    public Map<String, TableExportConfig> getTableExportConfigs() {
        return this.tableExportConfigs;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebConfig)) {
            return false;
        }
        WebConfig webConfigObj = (WebConfig)obj;
        return this.types.equals(webConfigObj.types) && this.tableExportConfigs.equals(webConfigObj.tableExportConfigs);
    }

    public int hashCode() {
        return this.types.hashCode();
    }

    void setSubClassConfig(Model model) throws ClassNotFoundException {
        for (ClassDescriptor cld : model.getTopDownLevelTraversal()) {
            Type thisClassType = (Type)this.types.get(cld.getName());
            if (thisClassType == null) {
                thisClassType = new Type();
                thisClassType.setClassName(cld.getName());
                this.types.put(cld.getName(), thisClassType);
            }
            Set cds = model.getClassDescriptorsForClass(Class.forName(cld.getName()));
            for (ClassDescriptor cd : cds) {
                Iterator titles;
                Type superClassType;
                if (cld.getName().equals(cd.getName()) || (superClassType = (Type)this.types.get(cd.getName())) == null) continue;
                HeaderConfigTitle hc = superClassType.getHeaderConfigTitle();
                if (hc != null && (titles = hc.getTitles()) != null) {
                    HeaderConfigTitle subclassHc = thisClassType.getHeaderConfigTitle();
                    if (subclassHc != null) {
                        if (subclassHc.getAppendConfig().booleanValue()) {
                            subclassHc.addTitleParts(hc.getTitles());
                        }
                    } else {
                        thisClassType.addHeaderConfigTitle(hc);
                    }
                }
                if (thisClassType.getFieldConfigs().size() == 0) {
                    titles = superClassType.getFieldConfigs().iterator();
                    while (titles.hasNext()) {
                        FieldConfig fc = (FieldConfig)titles.next();
                        thisClassType.addFieldConfig(fc);
                    }
                } else {
                    titles = superClassType.getFieldConfigs().iterator();
                    while (titles.hasNext()) {
                        FieldConfig superfc = (FieldConfig)titles.next();
                        for (FieldConfig thisfc : thisClassType.getFieldConfigs()) {
                            if (!thisfc.getFieldExpr().equals(superfc.getFieldExpr()) || superfc.getLabel() == null || thisfc.getLabel() != null) continue;
                            thisfc.setLabel(superfc.getLabel());
                        }
                    }
                }
                if (thisClassType.getLongDisplayers().size() == 0) {
                    for (Displayer ld : superClassType.getLongDisplayers()) {
                        thisClassType.addLongDisplayer(ld);
                    }
                }
                if (thisClassType.getTableDisplayer() == null) {
                    thisClassType.setTableDisplayer(superClassType.getTableDisplayer());
                }
                if (thisClassType.getInlineListConfig() == null || thisClassType.getInlineListConfig().isEmpty()) {
                    for (InlineListConfig cfg : superClassType.getInlineListConfig()) {
                        thisClassType.addInlineList(cfg);
                    }
                }
                if (thisClassType.getWidgets().size() != 0 || superClassType.getWidgets() == null || superClassType.getWidgets().size() <= 0) continue;
                for (WidgetConfig wi : superClassType.getWidgets()) {
                    thisClassType.addWidget(wi);
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<webconfig>");
        Iterator typesIter = this.types.values().iterator();
        while (typesIter.hasNext()) {
            sb.append(((Type)typesIter.next()).toString() + "\n");
        }
        Iterator tableExportConfigIter = this.tableExportConfigs.values().iterator();
        while (tableExportConfigIter.hasNext()) {
            sb.append(((TableExportConfig)tableExportConfigIter.next()).toString());
        }
        sb.append("</webconfig>");
        return sb.toString();
    }
}

