/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.profile;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.BagState;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.profile.SavedQuery;
import org.intermine.api.util.NameUtil;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.intermine.ObjectStoreWriterInterMineImpl;
import org.intermine.sql.DatabaseUtil;
import org.intermine.web.logic.profile.LoginHandler;
import org.intermine.web.logic.profile.ProfileMergeIssues;
import org.intermine.web.logic.profile.UpgradeBagList;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class LoginHandler
extends InterMineAction {
    private static final Logger LOG = Logger.getLogger(LoginHandler.class);

    public ProfileMergeIssues doLogin(HttpServletRequest request, String username, String password) {
        ProfileMergeIssues issues = LoginHandler.doStaticLogin((HttpServletRequest)request, (String)username, (String)password);
        HttpSession session = request.getSession();
        ProfileManager pm = SessionMethods.getInterMineAPI((HttpSession)session).getProfileManager();
        Profile profile = pm.getProfile(username);
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        if (im.getBagManager().isAnyBagNotCurrentOrUpgrading(profile)) {
            this.recordError(new ActionMessage("login.upgradeListStarted"), request);
        } else if (im.getBagManager().isAnyBagToUpgrade(profile)) {
            this.recordError(new ActionMessage("login.upgradeListManually"), request);
        }
        return issues;
    }

    public static ProfileMergeIssues mergeProfiles(Profile fromProfile, Profile toProfile) {
        Map mergeQueries = Collections.emptyMap();
        Map mergeBags = Collections.emptyMap();
        Map mergeTemplates = Collections.emptyMap();
        ProfileMergeIssues issues = new ProfileMergeIssues();
        if (!fromProfile.getPreferences().isEmpty()) {
            toProfile.getPreferences().putAll(fromProfile.getPreferences());
        }
        if (fromProfile != null) {
            mergeQueries = fromProfile.getHistory();
            mergeBags = fromProfile.getSavedBags();
        }
        for (SavedQuery savedQuery : mergeQueries.values()) {
            toProfile.saveHistory(savedQuery);
        }
        for (Map.Entry entry : mergeBags.entrySet()) {
            InterMineBag bag = (InterMineBag)entry.getValue();
            try {
                bag.setProfileId(toProfile.getUserId());
                String name = NameUtil.validateName(toProfile.getSavedBags().keySet(), (String)((String)entry.getKey()));
                if (!((String)entry.getKey()).equals(name)) {
                    issues.addRenamedBag((String)entry.getKey(), name);
                }
                bag.setName(name);
                toProfile.saveBag(name, bag);
            }
            catch (ObjectStoreException iex) {
                throw new RuntimeException(iex.getMessage());
            }
        }
        return issues;
    }

    public static ProfileMergeIssues doStaticLogin(HttpServletRequest request, String username, String password) {
        Profile currentProfile = SessionMethods.getProfile((HttpSession)request.getSession());
        HttpSession session = request.getSession();
        Profile profile = LoginHandler.setUpProfile((HttpSession)session, (String)username, (String)password);
        ProfileMergeIssues issues = new ProfileMergeIssues();
        if (currentProfile != null && StringUtils.isEmpty((String)currentProfile.getUsername())) {
            issues = LoginHandler.mergeProfiles((Profile)currentProfile, (Profile)profile);
        }
        return issues;
    }

    public static Profile setUpProfile(HttpSession session, String username, String password) {
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        ProfileManager pm = SessionMethods.getInterMineAPI((HttpSession)session).getProfileManager();
        if (!pm.hasProfile(username)) {
            throw new LoginException("There is no profile for " + username, null);
        }
        Profile profile = pm.getProfile(username, password, (Map)im.getClassKeys());
        return LoginHandler.setUpProfile((HttpSession)session, (Profile)profile);
    }

    public static void setUpPermission(InterMineAPI api, ProfileManager.ApiPermission permission) {
        ProfileManager pm = api.getProfileManager();
        Profile profile = permission.getProfile();
        String userName = profile.getUsername();
        if (profile.isSuperuser() || userName != null && userName.equals(pm.getSuperuser())) {
            permission.addRole("SUPERUSER");
        }
        if (!api.getBagManager().isAnyBagInState(profile, BagState.UPGRADING)) {
            UpgradeBagList upgrade = new UpgradeBagList(profile, api.getBagQueryRunner());
            LoginHandler.runBagUpgrade((UpgradeBagList)upgrade, (InterMineAPI)api, (Profile)profile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runBagUpgrade(UpgradeBagList procedure, InterMineAPI api, Profile profile) {
        Connection con = null;
        try {
            con = ((ObjectStoreWriterInterMineImpl)api.getProfileManager().getProfileObjectStoreWriter()).getDatabase().getConnection();
            if (api.getBagManager().isAnyBagNotCurrent(profile) && !DatabaseUtil.isBagValuesEmpty((Connection)con)) {
                Thread upgrade = new Thread((Runnable)procedure);
                upgrade.setDaemon(true);
                upgrade.start();
            }
        }
        catch (SQLException sqle) {
            LOG.error((Object)"Problems retrieving the connection", (Throwable)sqle);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public static Profile setUpProfile(HttpSession session, Profile profile) {
        SessionMethods.setProfile((HttpSession)session, (Profile)profile);
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        if (profile.isSuperuser()) {
            session.setAttribute("IS_SUPERUSER", (Object)Boolean.TRUE);
        }
        UpgradeBagList upgrade = new UpgradeBagList(profile, im.getBagQueryRunner());
        LoginHandler.runBagUpgrade((UpgradeBagList)upgrade, (InterMineAPI)im, (Profile)profile);
        return profile;
    }
}

