/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.querybuilder;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.Profile;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.objectstore.ObjectStoreSummary;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.FieldConfigHelper;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.query.MetadataNode;
import org.intermine.web.logic.querybuilder.ModelBrowserHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ModelBrowserHelper {
    private ModelBrowserHelper() {
    }

    public static Collection<MetadataNode> makeSelectedNodes(String stringPath, String prefix, Model model, boolean isSuperUser, PathQuery query, WebConfig webConfig, Map<String, List<FieldDescriptor>> classKeys, BagManager bagManager, Profile profile, ObjectStoreSummary oss) throws PathException {
        Collection nodes = ModelBrowserHelper.makeNodes((String)stringPath, (Model)model, (boolean)isSuperUser, (PathQuery)query, (WebConfig)webConfig, classKeys, (BagManager)bagManager, (Profile)profile, (ObjectStoreSummary)oss);
        List view = query.getView();
        for (MetadataNode node : nodes) {
            Path path;
            String fullPath;
            String pathName = node.getPathString();
            int firstDot = pathName.indexOf(46);
            if (firstDot == -1) {
                fullPath = prefix;
            } else {
                String pathNameWithoutClass = pathName.substring(firstDot + 1);
                fullPath = prefix + "." + pathNameWithoutClass;
            }
            if (view.contains(fullPath)) {
                node.setSelected(true);
                continue;
            }
            try {
                path = query.makePath(pathName);
            }
            catch (PathException e) {
                throw new Error("There must be a bug", e);
            }
            if (path.getEndFieldDescriptor() != null && !path.endIsReference() && !path.endIsCollection() || !view.contains(path)) continue;
            ClassDescriptor cld = path.getEndClassDescriptor();
            for (FieldConfig fc : FieldConfigHelper.getClassFieldConfigs((WebConfig)webConfig, (ClassDescriptor)cld)) {
                String pathFromField = pathName + "." + fc.getFieldExpr();
                if (view.contains(pathFromField)) {
                    node.setSelected(true);
                    continue;
                }
                node.setSelected(false);
            }
        }
        return nodes;
    }

    public static Collection<MetadataNode> makeNodes(String path, Model model, boolean isSuperUser, PathQuery query, WebConfig webConfig, Map<String, List<FieldDescriptor>> classKeys, BagManager bagManager, Profile profile, ObjectStoreSummary oss) throws PathException {
        NodeBuilder builder = new NodeBuilder(isSuperUser, query, classKeys, bagManager, profile, oss, webConfig);
        builder.buildTree(path);
        return builder.nodes.values();
    }
}

