/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.querybuilder;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintAttribute;
import org.intermine.pathquery.PathConstraintBag;
import org.intermine.pathquery.PathConstraintIds;
import org.intermine.pathquery.PathConstraintLookup;
import org.intermine.pathquery.PathConstraintLoop;
import org.intermine.pathquery.PathConstraintMultiValue;
import org.intermine.pathquery.PathConstraintNull;
import org.intermine.pathquery.PathConstraintSubclass;

public class SummaryConstraint {
    private PathConstraint con;
    private boolean editableInTemplate;
    private String code;
    private String description;
    private String switchable;

    public SummaryConstraint(PathConstraint con, String code, boolean editableInTemplate, String description, String switchable) {
        this.con = con;
        this.code = code;
        this.editableInTemplate = editableInTemplate;
        this.description = description;
        this.switchable = switchable;
    }

    public String getOp() {
        return this.con.getOp().toString();
    }

    public String getCode() {
        return this.code;
    }

    public String getValue() {
        if (this.con instanceof PathConstraintAttribute) {
            return ((PathConstraintAttribute)this.con).getValue();
        }
        if (this.con instanceof PathConstraintBag) {
            return ((PathConstraintBag)this.con).getBag();
        }
        if (this.con instanceof PathConstraintLookup) {
            PathConstraintLookup pcl = (PathConstraintLookup)this.con;
            if (StringUtils.isBlank((String)pcl.getExtraValue())) {
                return pcl.getValue();
            }
            return pcl.getValue() + " IN " + pcl.getExtraValue();
        }
        if (this.con instanceof PathConstraintSubclass) {
            return ((PathConstraintSubclass)this.con).getType();
        }
        if (this.con instanceof PathConstraintLoop) {
            String loopPath = ((PathConstraintLoop)this.con).getLoopPath();
            loopPath = loopPath.replace(".", " > ");
            return loopPath;
        }
        if (this.con instanceof PathConstraintNull) {
            return null;
        }
        if (this.con instanceof PathConstraintMultiValue) {
            Collection multiValues = ((PathConstraintMultiValue)this.con).getValues();
            return Arrays.toString(multiValues.toArray());
        }
        if (this.con instanceof PathConstraintIds) {
            return Arrays.toString(PathConstraint.getIds((PathConstraint)this.con).toArray());
        }
        throw new Error("PathConstraint type not recognised: " + this.con.getClass().getName());
    }

    public boolean isEditableInTemplate() {
        return this.editableInTemplate;
    }

    public boolean isValidEditableConstraintType() {
        return this.con instanceof PathConstraintAttribute || this.con instanceof PathConstraintLookup || this.con instanceof PathConstraintNull || this.con instanceof PathConstraintMultiValue;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSwitchable() {
        return this.switchable;
    }
}

