/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.widget;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.util.CacheMap;
import org.intermine.web.logic.widget.EnrichmentInput;
import org.intermine.web.logic.widget.EnrichmentWidgetImplLdr;
import org.intermine.web.logic.widget.PopulationInfo;

public class EnrichmentInputWidgetLdr
implements EnrichmentInput {
    private final EnrichmentWidgetImplLdr ldr;
    private final ObjectStore os;
    private Map<String, Integer> sampleCounts = null;
    private Map<String, PopulationInfo> populationCounts = null;
    private Map<String, String> labels = null;
    private static final int BATCH_SIZE = 20000;
    private static CacheMap<String, PopulationInfo> populationCache = new CacheMap();
    private static CacheMap<String, Map<String, PopulationInfo>> populationCountsCache = new CacheMap();

    public EnrichmentInputWidgetLdr(ObjectStore os, EnrichmentWidgetImplLdr ldr) {
        this.os = os;
        this.ldr = ldr;
    }

    public Map<String, PopulationInfo> getAnnotatedCountsInPopulation() {
        if (this.populationCounts == null) {
            Query query = this.ldr.getPopulationQuery(false);
            this.populationCounts = (Map)populationCountsCache.get((Object)query.toString());
            if (this.populationCounts == null) {
                this.populationCounts = new HashMap();
                Results results = this.os.execute(query, 20000, true, true, true);
                for (ResultsRow row : results) {
                    String identifier = String.valueOf(row.get(0));
                    Integer count = ((Long)row.get(1)).intValue();
                    float geneLengthAverage = 0.0f;
                    if (row.size() > 2 && row.get(2) != null) {
                        geneLengthAverage = ((BigDecimal)row.get(2)).floatValue();
                    }
                    this.populationCounts.put(identifier, new PopulationInfo(count.intValue(), geneLengthAverage));
                }
                populationCountsCache.put((Object)query.toString(), (Object)this.populationCounts);
            }
        }
        return this.populationCounts;
    }

    public Map<String, Integer> getAnnotatedCountsInSample() {
        if (this.sampleCounts == null) {
            this.sampleCounts = new HashMap();
            this.labels = new HashMap();
            Query query = this.ldr.getSampleQuery(false);
            Results results = this.os.execute(query, 20000, true, true, true);
            for (ResultsRow row : results) {
                String identifier = String.valueOf(row.get(0));
                Integer count = ((Long)row.get(1)).intValue();
                this.sampleCounts.put(identifier, count);
                this.labels.put(identifier, String.valueOf(row.get(2)));
            }
        }
        return this.sampleCounts;
    }

    public Map<String, String> getLabels() {
        if (this.labels == null) {
            this.getAnnotatedCountsInSample();
        }
        return this.labels;
    }

    public PopulationInfo getPopulationInfo() {
        Query q = this.ldr.getPopulationQuery(true);
        PopulationInfo populationInfo = (PopulationInfo)populationCache.get((Object)q.toString());
        if (populationInfo == null) {
            int size = 0;
            float extraAttribute = 0.0f;
            Results res = this.os.execute(q);
            List info = (List)res.get(0);
            size = ((Long)info.get(0)).intValue();
            if (info.size() > 1 && info.get(1) != null) {
                extraAttribute = ((BigDecimal)info.get(1)).floatValue();
            }
            populationInfo = new PopulationInfo(size, extraAttribute);
            populationCache.put((Object)q.toString(), (Object)populationInfo);
        }
        return populationInfo;
    }

    public int getSampleSize() {
        Query q = this.ldr.getSampleQuery(true);
        return this.calcTotal(q);
    }

    public int getTestCount() {
        return this.populationCounts.keySet().size();
    }

    private int calcTotal(Query q) {
        Object[] o = this.os.executeSingleton(q).toArray();
        if (o.length == 0) {
            return 0;
        }
        return ((Long)o[0]).intValue();
    }
}

