/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.widget;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.intermine.api.profile.InterMineBag;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.widget.CorrectionCoefficient;
import org.intermine.web.logic.widget.EnrichmentCalculation;
import org.intermine.web.logic.widget.EnrichmentInput;
import org.intermine.web.logic.widget.EnrichmentInputWidgetLdr;
import org.intermine.web.logic.widget.EnrichmentOptions;
import org.intermine.web.logic.widget.EnrichmentResults;
import org.intermine.web.logic.widget.EnrichmentWidgetImplLdr;
import org.intermine.web.logic.widget.PopulationInfo;
import org.intermine.web.logic.widget.Widget;
import org.intermine.web.logic.widget.config.EnrichmentWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfigUtil;

public class EnrichmentWidget
extends Widget {
    private static final Logger LOG = Logger.getLogger(EnrichmentWidget.class);
    private InterMineBag populationBag;
    private String filter;
    private EnrichmentResults results;
    private String errorCorrection;
    private double max = 0.05;
    private boolean extraCorrectionCoefficient = false;
    private CorrectionCoefficient correctionCoefficient = null;
    private EnrichmentWidgetImplLdr ldr;
    private String pathConstraint;
    private ClassDescriptor typeDescriptor;
    private String ids;
    private String populationIds;

    public EnrichmentWidget(EnrichmentWidgetConfig config, InterMineBag interMineBag, InterMineBag populationBag, ObjectStore os, EnrichmentOptions options, String ids, String populationIds) {
        super((WidgetConfig)config);
        String correctionCoefficientClassName;
        this.bag = interMineBag;
        this.populationBag = populationBag;
        this.os = os;
        this.typeDescriptor = os.getModel().getClassDescriptorByName(config.getTypeClass());
        this.errorCorrection = options.getCorrection();
        this.max = options.getMaxPValue();
        this.filter = options.getFilter();
        this.ids = ids;
        this.populationIds = populationIds;
        if (this.bag != null) {
            this.validateBagType();
        }
        String string = correctionCoefficientClassName = config.getCorrectionCoefficient() != null ? config.getCorrectionCoefficient().trim() : "";
        if (!correctionCoefficientClassName.isEmpty()) {
            try {
                Class<?> clazz = Class.forName(correctionCoefficientClassName);
                Constructor<?> c = clazz.getConstructor(WidgetConfig.class, ObjectStore.class, InterMineBag.class, String.class);
                this.correctionCoefficient = (CorrectionCoefficient)c.newInstance(config, os, this.bag, ids);
                this.extraCorrectionCoefficient = this.correctionCoefficient.isSelected(options.getExtraCorrectionCoefficient());
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error((Object)cnfe);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    public void setFilter(String filter) {
        this.checkNotProcessed();
        this.filter = filter;
    }

    private void checkProcessed() {
        if (this.ldr == null) {
            throw new IllegalStateException("This widget has not been processed yet.");
        }
    }

    private void checkNotProcessed() {
        if (this.ldr != null) {
            throw new IllegalStateException("This widget has already been processed.");
        }
    }

    private void validateBagType() {
        ClassDescriptor bagType = this.os.getModel().getClassDescriptorByName(this.bag.getType());
        if (bagType == null) {
            throw new IllegalArgumentException("This bag has a type not found in the current model: " + this.bag.getType());
        }
        if ("InterMineObject".equals(this.typeDescriptor.getName())) {
            return;
        }
        if (bagType.equals((Object)this.typeDescriptor)) {
            return;
        }
        if (bagType.getAllSuperDescriptors().contains(this.typeDescriptor)) {
            return;
        }
        throw new IllegalArgumentException(String.format("The %s enrichment query only accepts lists of %s, but you provided a list of %s ", this.config.getId(), this.config.getTypeClass(), this.bag.getType()));
    }

    public void process() {
        this.checkNotProcessed();
        try {
            this.ldr = new EnrichmentWidgetImplLdr(this.bag, this.populationBag, this.os, (EnrichmentWidgetConfig)this.config, this.filter, this.extraCorrectionCoefficient, this.correctionCoefficient, this.ids, this.populationIds);
            EnrichmentInputWidgetLdr input = new EnrichmentInputWidgetLdr(this.os, this.ldr);
            this.results = EnrichmentCalculation.calculate((EnrichmentInput)input, (Double)this.max, (String)this.errorCorrection, (boolean)this.extraCorrectionCoefficient, (CorrectionCoefficient)this.correctionCoefficient);
            int size = 0;
            if (this.bag != null) {
                size = this.bag.getSize();
            } else if (this.ids != null) {
                String[] idArray = this.ids.split(",");
                size = idArray.length;
            }
            this.setNotAnalysed(size - this.results.getAnalysedTotal());
            this.setPopulationCount(this.results.getPopulationTotal());
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean getHasResults() {
        this.checkProcessed();
        return this.results.getPValues().size() > 0;
    }

    private Map<String, List<String>> getTermsToIdsForExport(List<String> selectedIds) throws Exception {
        this.checkProcessed();
        Query q = this.ldr.getExportQuery(selectedIds);
        Results res = this.os.execute(q);
        Iterator iter = res.iterator();
        HashMap<String, List<String>> termsToIds = new HashMap<String, List<String>>();
        while (iter.hasNext()) {
            ResultsRow resRow = (ResultsRow)iter.next();
            String termId = resRow.get(0).toString();
            String id = resRow.get(1).toString();
            if (!termsToIds.containsKey(termId)) {
                termsToIds.put(termId, new ArrayList());
            }
            termsToIds.get(termId).add(id);
        }
        return termsToIds;
    }

    public List<List<String>> getExportResults(String[] selected) throws Exception {
        this.checkProcessed();
        Map pValues = this.results.getPValues();
        Map labels = this.results.getLabels();
        ArrayList<List<String>> exportResults = new ArrayList<List<String>>();
        List<String> selectedIds = Arrays.asList(selected);
        Map termsToIds = this.getTermsToIdsForExport(selectedIds);
        for (String id : selectedIds) {
            if (labels.get(id) == null) continue;
            LinkedList<String> row = new LinkedList<String>();
            row.add(id);
            String label = (String)labels.get(id);
            if (!label.equals(id)) {
                row.add(label);
            }
            BigDecimal bd = (BigDecimal)pValues.get(id);
            row.add(new Double(bd.doubleValue()).toString());
            List termIds = (List)termsToIds.get(id);
            StringBuffer sb = new StringBuffer();
            for (String term : termIds) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(term);
            }
            row.add(sb.toString());
            exportResults.add(row);
        }
        return exportResults;
    }

    public List<List<Object>> getResults() throws Exception {
        this.checkProcessed();
        LinkedList<List<Object>> exportResults = new LinkedList<List<Object>>();
        if (this.results != null) {
            Map pValues = this.results.getPValues();
            Map counts = this.results.getCounts();
            Map labels = this.results.getLabels();
            Map annotatedPopulationInfo = this.results.getPopulationAnnotations();
            for (String id : pValues.keySet()) {
                LinkedList<Object> row = new LinkedList<Object>();
                row.add(id);
                row.add(labels.get(id));
                row.add(((BigDecimal)pValues.get(id)).doubleValue());
                row.add(counts.get(id));
                row.add(((PopulationInfo)annotatedPopulationInfo.get(id)).getSize());
                exportResults.add(row);
            }
        }
        return exportResults;
    }

    public String getPathConstraint() {
        return this.pathConstraint;
    }

    public PathQuery getPathQuery() {
        PathQuery q = this.createPathQueryView(this.os, this.config);
        if (this.bag != null) {
            q.addConstraint((PathConstraint)Constraints.in((String)this.config.getStartClass(), (String)this.bag.getName()));
        } else if (this.ids != null) {
            String[] idStrings = this.ids.split(",");
            ArrayList intermineIds = new ArrayList();
            for (int i = 0; i < idStrings.length; ++i) {
                try {
                    intermineIds.add(Integer.parseInt(idStrings[i]));
                    continue;
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)"bad IDs for list in enrichment.", (Throwable)e);
                    return null;
                }
            }
            q.addConstraint((PathConstraint)Constraints.inIds((String)this.config.getStartClass(), (Collection)intermineIds));
        }
        List pathConstraintsForView = ((EnrichmentWidgetConfig)this.config).getPathConstraintsForView();
        if (pathConstraintsForView != null) {
            for (PathConstraint pc : pathConstraintsForView) {
                q.addConstraint(pc);
            }
        }
        String enrichIdentifier = ((EnrichmentWidgetConfig)this.config).getEnrichIdentifier();
        boolean subClassContraint = false;
        String subClassType = "";
        String subClassPath = "";
        if (enrichIdentifier != null && !"".equals(enrichIdentifier)) {
            enrichIdentifier = this.config.getStartClass() + "." + ((EnrichmentWidgetConfig)this.config).getEnrichIdentifier();
        } else {
            String enrichPath = this.config.getStartClass() + "." + ((EnrichmentWidgetConfig)this.config).getEnrich();
            if (WidgetConfigUtil.isPathContainingSubClass((Model)this.os.getModel(), (String)enrichPath)) {
                subClassContraint = true;
                subClassType = enrichPath.substring(enrichPath.indexOf("[") + 1, enrichPath.indexOf("]"));
                subClassPath = enrichPath.substring(0, enrichPath.indexOf("["));
                enrichIdentifier = subClassPath + enrichPath.substring(enrichPath.indexOf("]") + 1);
            } else {
                enrichIdentifier = enrichPath;
            }
        }
        this.pathConstraint = enrichIdentifier;
        if (subClassContraint) {
            q.addConstraint((PathConstraint)Constraints.type((String)subClassPath, (String)subClassType));
        }
        return q;
    }

    public PathQuery getPathQueryForMatches() {
        List pathConstraintsForView;
        String enrichIdentifier;
        Model model = this.os.getModel();
        PathQuery pathQuery = new PathQuery(model);
        boolean subClassContraint = false;
        String subClassType = "";
        String subClassPath = "";
        EnrichmentWidgetConfig ewc = (EnrichmentWidgetConfig)this.config;
        if (ewc.getEnrichIdentifier() != null) {
            enrichIdentifier = this.config.getStartClass() + "." + ewc.getEnrichIdentifier();
        } else {
            String enrichPath = this.config.getStartClass() + "." + ewc.getEnrich();
            if (WidgetConfigUtil.isPathContainingSubClass((Model)model, (String)enrichPath)) {
                subClassContraint = true;
                subClassType = enrichPath.substring(enrichPath.indexOf("[") + 1, enrichPath.indexOf("]"));
                subClassPath = enrichPath.substring(0, enrichPath.indexOf("["));
                enrichIdentifier = subClassPath + enrichPath.substring(enrichPath.indexOf("]") + 1);
            } else {
                enrichIdentifier = enrichPath;
            }
        }
        String startClassDisplayView = this.config.getStartClass() + "." + ewc.getStartClassDisplay();
        pathQuery.addView(enrichIdentifier);
        pathQuery.addView(startClassDisplayView);
        pathQuery.addOrderBy(enrichIdentifier, OrderDirection.ASC);
        if (this.bag != null) {
            pathQuery.addConstraint((PathConstraint)Constraints.in((String)this.config.getStartClass(), (String)this.bag.getName()));
        } else if (this.ids != null) {
            String[] idStrings = this.ids.split(",");
            ArrayList<Integer> intermineIds = new ArrayList<Integer>();
            for (int i = 0; i < idStrings.length; ++i) {
                try {
                    intermineIds.add(Integer.parseInt(idStrings[i]));
                    continue;
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)"bad IDs for list in enrichment.", (Throwable)e);
                    return null;
                }
            }
            pathQuery.addConstraint((PathConstraint)Constraints.inIds((String)this.config.getStartClass(), intermineIds));
        }
        if (subClassContraint) {
            pathQuery.addConstraint((PathConstraint)Constraints.type((String)subClassPath, (String)subClassType));
        }
        if ((pathConstraintsForView = ewc.getPathConstraintsForView()) != null) {
            for (PathConstraint pc : pathConstraintsForView) {
                pathQuery.addConstraint(pc);
            }
        }
        return pathQuery;
    }

    public CorrectionCoefficient getExtraCorrectionCoefficient() {
        return this.correctionCoefficient;
    }
}

