/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.widget;

import java.util.List;
import org.intermine.api.profile.InterMineBag;
import org.intermine.metadata.Model;
import org.intermine.objectstore.ObjectStore;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfigUtil;

public abstract class Widget {
    protected WidgetConfig config;
    protected InterMineBag bag;
    protected String ids;
    protected ObjectStore os;
    protected int notAnalysed = 0;
    protected int poplationCount = 0;

    public Widget(WidgetConfig config) {
        this.config = config;
    }

    public abstract void process() throws Exception;

    public int getNotAnalysed() {
        return this.notAnalysed;
    }

    public void setNotAnalysed(int notAnalysed) {
        this.notAnalysed = notAnalysed;
    }

    public int getPopulationCount() {
        return this.poplationCount;
    }

    public void setPopulationCount(int poplationCount) {
        this.poplationCount = poplationCount;
    }

    public abstract List<List<String>> getExportResults(String[] var1) throws Exception;

    public abstract boolean getHasResults();

    public String getConfigId() {
        return this.config.getId();
    }

    public String getTitle() {
        return this.config.getTitle();
    }

    public abstract List<List<Object>> getResults() throws Exception;

    public abstract PathQuery getPathQuery();

    protected PathQuery createPathQueryView(ObjectStore os, WidgetConfig config) {
        Model model = os.getModel();
        PathQuery q = new PathQuery(model);
        String[] views = config.getViews().split("\\s*,\\s*");
        String prefix = config.getStartClass() + ".";
        for (String view : views) {
            if (!view.startsWith(prefix)) {
                view = prefix + view;
            }
            view = WidgetConfigUtil.getPathWithoutSubClass((Model)model, (String)view);
            q.addView(view);
        }
        return q;
    }
}

