/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.widget.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.intermine.api.profile.InterMineBag;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.Model;
import org.intermine.metadata.TypeUtil;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintAttribute;
import org.intermine.web.logic.widget.Widget;
import org.intermine.web.logic.widget.WidgetOptions;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class WidgetConfig {
    private String id;
    private String description;
    private String title;
    private String filterLabel;
    private String filters;
    private String startClass;
    private List<PathConstraint> pathConstraints = new ArrayList();
    private String typeClass;
    private String views;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFilters() {
        return this.filters;
    }

    public List<String> getFiltersValues(ObjectStore os, InterMineBag bag, String ids) {
        QueryClass startClassQueryClass;
        if (this.filters == null) {
            return Collections.emptyList();
        }
        if (!this.filters.contains("[list]")) {
            return Arrays.asList(this.filters.split("\\,"));
        }
        ArrayList<String> ret = new ArrayList<String>();
        String filterPath = this.filters.substring(0, this.filters.indexOf("=")).trim();
        Query q = new Query();
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        q.setConstraint((Constraint)cs);
        Model model = os.getModel();
        try {
            startClassQueryClass = new QueryClass(new Class[]{Class.forName(model.getPackageName() + "." + this.startClass)});
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found " + bag.getType(), e);
        }
        q.addFrom((FromElement)startClassQueryClass);
        QueryClass qc = startClassQueryClass;
        String[] paths = filterPath.split("\\.");
        for (int i = 0; i < paths.length; ++i) {
            if (i == paths.length - 1) {
                QueryField qfFilter = new QueryField(qc, paths[i]);
                q.addToSelect((QuerySelectable)qfFilter);
                q.addToOrderBy((QueryOrderable)qfFilter);
                continue;
            }
            try {
                QueryObjectReference qor = new QueryObjectReference(qc, paths[i]);
                qc = new QueryClass(qor.getType());
                q.addFrom((FromElement)qc);
                cs.addConstraint((Constraint)new ContainsConstraint((QueryReference)qor, ConstraintOp.CONTAINS, qc));
                continue;
            }
            catch (IllegalArgumentException e) {
                QueryCollectionReference qcr = new QueryCollectionReference(qc, paths[i]);
                qc = new QueryClass(TypeUtil.getElementType((Class)qc.getType(), (String)paths[i]));
                q.addFrom((FromElement)qc);
                cs.addConstraint((Constraint)new ContainsConstraint((QueryReference)qcr, ConstraintOp.CONTAINS, qc));
            }
        }
        QueryField qfGeneId = new QueryField(startClassQueryClass, "id");
        if (bag == null) {
            String[] idArray = ids.split(",");
            LinkedHashSet<Integer> idsCollection = new LinkedHashSet<Integer>();
            for (String intermineId : idArray) {
                try {
                    idsCollection.add(Integer.valueOf(intermineId.trim()));
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("List of IDs contains invalid integer: " + intermineId, e);
                }
            }
            BagConstraint bc = new BagConstraint((QueryNode)qfGeneId, ConstraintOp.IN, idsCollection);
            cs.addConstraint((Constraint)bc);
        } else {
            BagConstraint bc = new BagConstraint((QueryNode)qfGeneId, ConstraintOp.IN, bag.getOsb());
            cs.addConstraint((Constraint)bc);
        }
        Results r = os.execute(q);
        for (ResultsRow rr : r) {
            Object value = rr.get(0);
            if (value == null) continue;
            ret.add(value.toString());
        }
        return ret;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public String getFilterLabel() {
        return this.filterLabel;
    }

    public void setFilterLabel(String filterLabel) {
        this.filterLabel = filterLabel;
    }

    public String getStartClass() {
        return this.startClass;
    }

    public void setStartClass(String startClass) {
        this.startClass = startClass;
    }

    public abstract Map<String, Collection<String>> getExtraAttributes(InterMineBag var1, ObjectStore var2) throws Exception;

    public String getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(String typeClass) {
        this.typeClass = typeClass;
    }

    public String getViews() {
        return this.views;
    }

    public void setViews(String views) {
        this.views = views;
    }

    public void setConstraints(String constraints) {
        WidgetConfig.setPathConstraints((String)constraints, (List)this.pathConstraints);
    }

    protected static void setPathConstraints(String constraints, List<? super PathConstraint> pathConstraints) {
        String[] constraintsList = constraints.split("\\s*,\\s*");
        String path = null;
        String value = null;
        ConstraintOp op = null;
        for (String constraint : constraintsList) {
            String[] splitConstraint;
            int opIndex = constraint.indexOf("!=");
            if (opIndex != -1) {
                op = ConstraintOp.NOT_EQUALS;
                splitConstraint = constraint.split("\\s*!=\\s*");
                path = splitConstraint[0];
                value = splitConstraint[1];
            } else {
                opIndex = constraint.indexOf("=");
                if (opIndex != -1) {
                    op = ConstraintOp.EQUALS;
                    splitConstraint = constraint.split("\\s*=\\s*");
                    path = splitConstraint[0];
                    value = splitConstraint[1];
                }
            }
            if (!value.contains("[") && !path.contains("]")) {
                value = value.toLowerCase();
            }
            pathConstraints.add((PathConstraint)new PathConstraintAttribute(path, op, value));
        }
    }

    public List<PathConstraint> getPathConstraints() {
        return this.pathConstraints;
    }

    public abstract Widget getWidget(InterMineBag var1, InterMineBag var2, ObjectStore var3, WidgetOptions var4, String var5, String var6);
}

